/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.pluginforgery.impl;

import by.fxg.pluginforgery.PluginForgery;
import by.fxg.pluginforgery.abuse.IBukkitAbuse;
import by.fxg.pluginforgery.api.player.IForgeryPlayer;
import by.fxg.pluginforgery.api.tools.PFDirection;
import by.fxg.pluginforgery.api.tools.PFPlayerAction;
import by.fxg.pluginforgery.api.tools.PFPlayerHand;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class BukkitForgeryPlayer
implements IForgeryPlayer {
    private final IBukkitAbuse bukkitAbuse = PluginForgery.getBukkitAbuseInterface();

    @Override
    public String getName() {
        return "Bukkit";
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public boolean isPlayerCanBreakBlock(Object EntityPlayer, int x, int y, int z) {
        return this.isPlayerCanBreakBlock(this.bukkitAbuse.getBukkitPlayerExplicit(EntityPlayer), x, y, z);
    }

    @Override
    public boolean isPlayerCanBreakBlock(String username, int x, int y, int z) {
        return this.isPlayerCanBreakBlock(Bukkit.getPlayer((String)username), x, y, z);
    }

    @Override
    public boolean isPlayerCanBreakBlock(UUID playerUniqueID, int x, int y, int z) {
        return this.isPlayerCanBreakBlock(Bukkit.getPlayer((UUID)playerUniqueID), x, y, z);
    }

    private boolean isPlayerCanBreakBlock(Player player, int x, int y, int z) {
        if (player != null) {
            BlockBreakEvent event = new BlockBreakEvent(player.getWorld().getBlockAt(x, y, z), player);
            Bukkit.getPluginManager().callEvent((Event)event);
            return !event.isCancelled();
        }
        return false;
    }

    @Override
    public boolean isPlayerCanAttackEntity(Object EntityPlayer, Object Entity2) {
        return this.isPlayerCanAttackEntity(this.bukkitAbuse.getBukkitPlayerExplicit(EntityPlayer), this.bukkitAbuse.getBukkitEntityExplicit(Entity2));
    }

    @Override
    public boolean isPlayerCanAttackEntity(String username, Object Entity2) {
        return this.isPlayerCanAttackEntity(Bukkit.getPlayer((String)username), this.bukkitAbuse.getBukkitEntityExplicit(Entity2));
    }

    @Override
    public boolean isPlayerCanAttackEntity(UUID playerUniqueID, Object Entity2) {
        return this.isPlayerCanAttackEntity(Bukkit.getPlayer((UUID)playerUniqueID), this.bukkitAbuse.getBukkitEntityExplicit(Entity2));
    }

    private boolean isPlayerCanAttackEntity(Player player, Entity entity) {
        if (player != null && entity != null) {
            EntityDamageByEntityEvent event = new EntityDamageByEntityEvent((Entity)player, entity, EntityDamageEvent.DamageCause.ENTITY_ATTACK, 0);
            Bukkit.getPluginManager().callEvent((Event)event);
            return !event.isCancelled();
        }
        return false;
    }

    @Override
    public boolean isPlayerCanInteract(Object EntityPlayer, PFPlayerHand hand, PFPlayerAction action, PFDirection direction, int x, int y, int z) {
        return this.isPlayerCanInteract(this.bukkitAbuse.getBukkitPlayerExplicit(EntityPlayer), action, direction, x, y, z);
    }

    @Override
    public boolean isPlayerCanInteract(String username, PFPlayerHand hand, PFPlayerAction action, PFDirection direction, int x, int y, int z) {
        return this.isPlayerCanInteract(Bukkit.getPlayer((String)username), action, direction, x, y, z);
    }

    @Override
    public boolean isPlayerCanInteract(UUID playerUniqueID, PFPlayerHand hand, PFPlayerAction action, PFDirection direction, int x, int y, int z) {
        return this.isPlayerCanInteract(Bukkit.getPlayer((UUID)playerUniqueID), action, direction, x, y, z);
    }

    private boolean isPlayerCanInteract(Player player, PFPlayerAction action, PFDirection direction, int x, int y, int z) {
        if (player != null) {
            PlayerInteractEvent event = new PlayerInteractEvent(player, action == PFPlayerAction.RIGHT_CLICK ? Action.RIGHT_CLICK_BLOCK : Action.LEFT_CLICK_BLOCK, player.getInventory().getItemInHand(), player.getWorld().getBlockAt(x, y, z), this.getBlockFaceFrom(direction));
            Bukkit.getPluginManager().callEvent((Event)event);
            return !event.isCancelled();
        }
        return false;
    }

    private BlockFace getBlockFaceFrom(PFDirection direction) {
        switch (direction) {
            case DOWN: {
                return BlockFace.DOWN;
            }
            case UP: {
                return BlockFace.UP;
            }
            case NORTH: {
                return BlockFace.NORTH;
            }
            case SOUTH: {
                return BlockFace.SOUTH;
            }
            case WEST: {
                return BlockFace.WEST;
            }
            case EAST: {
                return BlockFace.EAST;
            }
        }
        return null;
    }
}

