/*
 * Decompiled with CFR 0.152.
 */
package net.quumi.mwtab.core;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.quumi.multicore.api.resource.IMCTexture;
import net.quumi.multicore.core.resource.ResourceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0016\u001a\u00020\bJ(\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\b2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00180\u001aH\u0086\b\u00f8\u0001\u0000R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\n\u001a&\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\b0\b \u0005*\u0012\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\b0\b\u0018\u00010\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001b"}, d2={"Lnet/quumi/mwtab/core/PlayerSkinCache;", "", "()V", "fetchSkinsPool", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "map", "Ljava/util/HashMap;", "", "Lnet/quumi/multicore/api/resource/IMCTexture;", "pending", "", "", "skinBufferedImages", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/awt/image/BufferedImage;", "extend", "img", "newW", "", "newH", "getSkin", "playerName", "withSkin", "", "code", "Lkotlin/Function1;", "uni"})
public final class PlayerSkinCache {
    @NotNull
    public static final PlayerSkinCache INSTANCE = new PlayerSkinCache();
    private static final Set<String> pending = Collections.newSetFromMap(new ConcurrentHashMap());
    @NotNull
    private static final ConcurrentHashMap<String, BufferedImage> skinBufferedImages = new ConcurrentHashMap();
    @NotNull
    private static final HashMap<String, IMCTexture> map = new HashMap();
    private static final ExecutorService fetchSkinsPool = Executors.newCachedThreadPool(PlayerSkinCache::fetchSkinsPool$lambda$1);

    private PlayerSkinCache() {
    }

    @Nullable
    public final IMCTexture getSkin(@NotNull String playerName) {
        Intrinsics.checkNotNullParameter((Object)playerName, (String)"playerName");
        Object object = map.get(playerName);
        if (object != null) {
            IMCTexture it = object;
            boolean bl = false;
            return it;
        }
        object = skinBufferedImages.get(playerName);
        if (object != null) {
            Object it = object;
            boolean bl = false;
            IMCTexture mcTex = ResourceManager.INSTANCE.getDynamicTexture((BufferedImage)it);
            ((Map)map).put(playerName, mcTex);
            skinBufferedImages.remove(playerName);
            return mcTex;
        }
        if (pending.contains(playerName)) {
            return null;
        }
        pending.add(playerName);
        fetchSkinsPool.submit(() -> PlayerSkinCache.getSkin$lambda$4(playerName));
        return null;
    }

    public final void withSkin(@NotNull String playerName, @NotNull Function1<? super IMCTexture, Unit> code) {
        Intrinsics.checkNotNullParameter((Object)playerName, (String)"playerName");
        Intrinsics.checkNotNullParameter(code, (String)"code");
        boolean $i$f$withSkin = false;
        IMCTexture skin = this.getSkin(playerName);
        if (skin != null) {
            code.invoke((Object)skin);
        }
    }

    private final BufferedImage extend(BufferedImage img, int newW, int newH) {
        BufferedImage dimg = new BufferedImage(newW, newH, 2);
        Graphics2D g2d = dimg.createGraphics();
        g2d.drawImage((Image)img, 0, 0, null);
        g2d.dispose();
        return dimg;
    }

    private static final Thread fetchSkinsPool$lambda$1(Runnable it) {
        Thread thread;
        Thread thr = thread = new Thread(it);
        boolean bl = false;
        thr.setName("MW-TAB Skins download thread");
        thr.setDaemon(true);
        return thread;
    }

    private static final void getSkin$lambda$4(String $playerName) {
        Intrinsics.checkNotNullParameter((Object)$playerName, (String)"$playerName");
        URL url = new URL("https://skin.mythicalworld.net/game/v2/skin/" + $playerName + ".png");
        URLConnection uRLConnection = url.openConnection();
        Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
        HttpURLConnection req = (HttpURLConnection)uRLConnection;
        req.setRequestProperty("User-Agent", "silly skin downloader 3000");
        BufferedImage img = ImageIO.read(req.getInputStream());
        Intrinsics.checkNotNullExpressionValue((Object)img, (String)"img");
        BufferedImage fixedImg = INSTANCE.extend(img, img.getWidth(), img.getWidth());
        img.flush();
        ((Map)skinBufferedImages).put($playerName, fixedImg);
        pending.remove($playerName);
    }
}

