/*
 * Decompiled with CFR 0.152.
 */
package makamys.neodymium;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import makamys.neodymium.Compat;
import makamys.neodymium.config.Config;
import makamys.neodymium.util.OFUtil;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class MixinConfigPlugin
implements IMixinConfigPlugin {
    public void onLoad(String mixinPackage) {
        if (MixinEnvironment.getCurrentEnvironment().getSide() == MixinEnvironment.Side.SERVER) {
            return;
        }
        Config.reloadConfig();
        MixinEnvironment.Phase phase = MixinEnvironment.getCurrentEnvironment().getPhase();
        if (phase == MixinEnvironment.Phase.INIT) {
            Compat.forceEnableOptiFineDetectionOfFastCraft();
        }
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        if (MixinEnvironment.getCurrentEnvironment().getSide() == MixinEnvironment.Side.SERVER) {
            return Collections.emptyList();
        }
        ArrayList<String> mixins = new ArrayList<String>();
        MixinEnvironment.Phase phase = MixinEnvironment.getCurrentEnvironment().getPhase();
        if (phase == MixinEnvironment.Phase.DEFAULT) {
            mixins.addAll(Arrays.asList("MixinRenderGlobal", "MixinWorldRenderer", "MixinTessellator"));
            if (OFUtil.isOptiFinePresent()) {
                System.out.println("Detected OptiFine");
                mixins.add("MixinRenderGlobal_OptiFine");
                mixins.add("MixinGameSettings_OptiFine");
            }
            if (Config.replaceOpenGLSplash) {
                mixins.add("MixinGuiMainMenu");
            }
        }
        return mixins;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

