/*
 * Decompiled with CFR 0.152.
 */
package makamys.neodymium;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLConstructionEvent;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import makamys.neodymium.Compat;
import makamys.neodymium.Constants;
import makamys.neodymium.command.NeodymiumCommand;
import makamys.neodymium.config.Config;
import makamys.neodymium.renderer.NeoRenderer;
import makamys.neodymium.renderer.compat.RenderUtil;
import makamys.neodymium.renderer.compat.RenderUtilRPLE;
import makamys.neodymium.renderer.compat.RenderUtilShaderRPLE;
import makamys.neodymium.renderer.compat.RenderUtilShaders;
import makamys.neodymium.renderer.compat.RenderUtilVanilla;
import makamys.neodymium.repackage.makamys.mclib.core.MCLib;
import makamys.neodymium.repackage.makamys.mclib.core.MCLibModules;
import makamys.neodymium.util.ChatUtil;
import makamys.neodymium.util.Proxy;
import makamys.neodymium.util.WarningHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.world.World;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import org.apache.commons.lang3.tuple.Pair;

public class Neodymium
implements Proxy {
    private static final Config.ReloadInfo CONFIG_RELOAD_INFO = new Config.ReloadInfo();
    private boolean renderDebugText = false;
    public static NeoRenderer renderer;
    public static RenderUtil util;
    private static World rendererWorld;

    @Override
    public void construct(FMLConstructionEvent event) {
        MCLib.init();
        Compat.init();
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        MCLibModules.updateCheckAPI.submitModTask("neodymium", "https://raw.githubusercontent.com/makamys/neodymium/master/updatejson/update.json");
        if ("0.2.5".equals("0.2.5")) {
            event.getModMetadata().autogenerated = false;
        }
    }

    @Override
    public void init(FMLInitializationEvent event) {
        FMLCommonHandler.instance().bus().register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
        NeodymiumCommand.init();
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent event) {
        if (event.modID.equals("neodymium")) {
            Config.flush();
        }
    }

    private void onPlayerWorldChanged(World newWorld) {
        if (this.getRendererWorld() == null && newWorld != null) {
            Config.reloadConfig();
        }
        if (renderer != null) {
            Neodymium.destroyRenderer();
        }
        if (Config.enabled && newWorld != null) {
            Pair<List<Compat.Warning>, List<Compat.Warning>> warnsAndCriticalWarns = Neodymium.showCompatStatus(false);
            List warns = (List)warnsAndCriticalWarns.getLeft();
            List criticalWarns = (List)warnsAndCriticalWarns.getRight();
            if (criticalWarns.isEmpty()) {
                boolean rple = Compat.isRPLEModPresent();
                boolean optiFineShaders = Compat.isOptiFineShadersEnabled();
                util = rple && optiFineShaders ? RenderUtilShaderRPLE.INSTANCE : (optiFineShaders ? RenderUtilShaders.INSTANCE : (rple ? RenderUtilRPLE.INSTANCE : RenderUtilVanilla.INSTANCE));
                renderer = new NeoRenderer(newWorld);
                Neodymium.renderer.hasIncompatibilities = !warns.isEmpty() || !criticalWarns.isEmpty();
            }
        }
        rendererWorld = newWorld;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onWorldUnload(WorldEvent.Unload event) {
        if (!Config.enabled) {
            return;
        }
        if (event.world == this.getRendererWorld()) {
            this.onPlayerWorldChanged(null);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onConnectToServer(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        Config.reloadConfig();
        ChatUtil.resetShownChatMessages();
        Compat.reset();
        WarningHelper.reset();
    }

    public static boolean isActive() {
        return renderer != null && Neodymium.renderer.hasInited && !Neodymium.renderer.destroyPending;
    }

    private World getRendererWorld() {
        return rendererWorld;
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (!Config.enabled) {
            return;
        }
        if (event.phase == TickEvent.Phase.START && Neodymium.isActive() && Config.hotswap && Config.reloadIfChanged(CONFIG_RELOAD_INFO)) {
            if (Neodymium.CONFIG_RELOAD_INFO.needReload) {
                Minecraft.func_71410_x().field_71438_f.func_72712_a();
            } else if (renderer != null) {
                renderer.reloadShader();
            }
        }
        if (event.phase == TickEvent.Phase.START && Compat.hasChanged()) {
            Pair<List<Compat.Warning>, List<Compat.Warning>> warns = Neodymium.showCompatStatus(false);
            if (renderer != null) {
                Neodymium.renderer.hasIncompatibilities = !((List)warns.getLeft()).isEmpty() || !((List)warns.getRight()).isEmpty();
            }
        }
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        if (!Config.enabled) {
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            World world;
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            World world2 = world = player != null ? player.field_70170_p : null;
            if (world != this.getRendererWorld()) {
                this.onPlayerWorldChanged(world);
            }
            if (Neodymium.isActive()) {
                Neodymium.renderer.forceRenderFog = true;
            }
        } else if (event.phase == TickEvent.Phase.END && renderer != null) {
            renderer.onRenderTickEnd();
        }
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent.Pre event) {
        if (Config.showDebugInfo && Neodymium.isActive()) {
            if (event.type.equals((Object)RenderGameOverlayEvent.ElementType.DEBUG)) {
                this.renderDebugText = true;
            } else if (this.renderDebugText && event instanceof RenderGameOverlayEvent.Text && event.type.equals((Object)RenderGameOverlayEvent.ElementType.TEXT)) {
                this.renderDebugText = false;
                RenderGameOverlayEvent.Text text = (RenderGameOverlayEvent.Text)event;
                text.right.add(null);
                text.right.addAll(renderer.getDebugText(false));
            }
        }
    }

    @SubscribeEvent
    public void onRenderFog(EntityViewRenderEvent.RenderFogEvent event) {
        if (Neodymium.isActive()) {
            Neodymium.renderer.forceRenderFog = false;
        }
    }

    public static boolean shouldRenderVanillaWorld() {
        return !Neodymium.isActive() || Neodymium.isActive() && Neodymium.renderer.renderWorld && !Neodymium.renderer.rendererActive;
    }

    public static String modifySplash(String splash) {
        if (splash.equals("OpenGL 1.2!")) {
            return "OpenGL 3.3 (if supported)!";
        }
        return splash;
    }

    public static void destroyRenderer() {
        if (renderer != null) {
            renderer.destroy();
            renderer = null;
        }
        rendererWorld = null;
    }

    public static Pair<List<Compat.Warning>, List<Compat.Warning>> showCompatStatus(boolean statusCommand) {
        ArrayList<Compat.Warning> warns = new ArrayList<Compat.Warning>();
        ArrayList<Compat.Warning> criticalWarns = new ArrayList<Compat.Warning>();
        Compat.getCompatibilityWarnings(warns, criticalWarns, statusCommand);
        if (!criticalWarns.isEmpty() && !Config.ignoreIncompatibilities) {
            criticalWarns.add(new Compat.Warning("Neodymium has been disabled due to a critical incompatibility."));
        }
        for (Compat.Warning warn : warns) {
            Constants.LOGGER.warn(warn.text);
        }
        for (Compat.Warning criticalWarn : criticalWarns) {
            Constants.LOGGER.warn("Critical: " + criticalWarn.text);
        }
        return Pair.of(warns, criticalWarns);
    }

    @Mod(modid="neodymium", version="0.2.5", guiFactory="makamys.neodymium.config.GuiFactory", acceptableRemoteVersions="*")
    public static class ModContainer {
        @SidedProxy(serverSide="makamys.neodymium.util.Proxy$NullProxy", clientSide="makamys.neodymium.Neodymium")
        private static Proxy proxy;

        @Mod.EventHandler
        public void construct(FMLConstructionEvent event) {
            proxy.construct(event);
        }

        @Mod.EventHandler
        public void preInit(FMLPreInitializationEvent event) {
            proxy.preInit(event);
        }

        @Mod.EventHandler
        public void init(FMLInitializationEvent event) {
            proxy.init(event);
        }
    }
}

