/*
 * Decompiled with CFR 0.152.
 */
package makamys.neodymium.mixin;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import makamys.neodymium.Compat;
import makamys.neodymium.Neodymium;
import makamys.neodymium.ducks.ITessellator;
import makamys.neodymium.ducks.IWorldRenderer;
import makamys.neodymium.renderer.ChunkMesh;
import makamys.neodymium.renderer.NeoRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.entity.EntityLivingBase;
import org.lwjgl.opengl.GL11;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WorldRenderer.class})
abstract class MixinWorldRenderer
implements IWorldRenderer {
    @Shadow
    private boolean field_78927_l;
    @Shadow
    public boolean[] field_78928_m;
    @Shadow
    public boolean field_78939_q;
    private boolean nd$savedDrawnStatus;
    private List<ChunkMesh> nd$chunkMeshes;

    MixinWorldRenderer() {
    }

    @Inject(method={"updateRenderer"}, at={@At(value="FIELD", target="Lnet/minecraft/client/renderer/WorldRenderer;needsUpdate:Z", ordinal=0)}, require=1)
    private void preUpdateRenderer(CallbackInfo ci) {
        this.preUpdateRenderer(false);
    }

    @Inject(method={"updateRendererSort"}, at={@At(value="HEAD")}, require=1)
    private void preUpdateRendererSort(CallbackInfo ci) {
        this.preUpdateRenderer(true);
    }

    @Unique
    private void preUpdateRenderer(boolean sort) {
        this.saveDrawnStatus();
        if (Neodymium.isActive()) {
            if (this.nd$chunkMeshes != null) {
                Collections.fill(this.nd$chunkMeshes, null);
            } else {
                this.nd$chunkMeshes = Lists.newArrayList((Object[])new ChunkMesh[]{null, null});
            }
        }
    }

    @Inject(method={"updateRenderer"}, at={@At(value="FIELD", target="Lnet/minecraft/client/renderer/WorldRenderer;isInitialized:Z", ordinal=0, shift=At.Shift.AFTER)}, require=1)
    private void postUpdateRenderer(CallbackInfo ci) {
        this.postUpdateRenderer(false);
    }

    @Inject(method={"updateRendererSort"}, at={@At(value="RETURN")}, require=1)
    private void postUpdateRendererSort(CallbackInfo ci) {
        this.postUpdateRenderer(true);
    }

    @Unique
    private void postUpdateRenderer(boolean sort) {
        this.notifyIfDrawnStatusChanged();
        if (Neodymium.isActive() && this.nd$chunkMeshes != null) {
            Neodymium.renderer.onWorldRendererPost((WorldRenderer)WorldRenderer.class.cast(this), sort);
            Collections.fill(this.nd$chunkMeshes, null);
        }
    }

    @Inject(method={"preRenderBlocks"}, at={@At(value="HEAD")}, require=1)
    private void prePreRenderBlocks(int pass, CallbackInfo ci) {
        if (Neodymium.isActive()) {
            ((ITessellator)Tessellator.field_78398_a).enableMeshCapturing(true);
            ChunkMesh cm = new ChunkMesh((WorldRenderer)this, pass);
            this.nd$chunkMeshes.set(pass, cm);
            ChunkMesh.setCaptureTarget(cm);
        }
    }

    @Redirect(method={"preRenderBlocks"}, at=@At(value="INVOKE", target="Lorg/lwjgl/opengl/GL11;glNewList(II)V"), require=1)
    private void noNewList(int list, int mode) {
        if (!Neodymium.isActive() || Compat.keepRenderListLogic()) {
            GL11.glNewList((int)list, (int)mode);
        }
    }

    @Redirect(method={"postRenderBlocks"}, at=@At(value="INVOKE", target="Lorg/lwjgl/opengl/GL11;glEndList()V"), require=1)
    private void noEndList() {
        if (!Neodymium.isActive() || Compat.keepRenderListLogic()) {
            GL11.glEndList();
        }
    }

    @Inject(method={"postRenderBlocks"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/Tessellator;draw()I")}, require=1)
    private void prePostRenderBlocks(int pass, EntityLivingBase entity, CallbackInfo ci) {
    }

    @Inject(method={"postRenderBlocks"}, at={@At(value="RETURN")}, require=1)
    private void postPostRenderBlocks(int pass, EntityLivingBase entity, CallbackInfo ci) {
        if (Neodymium.isActive()) {
            this.nd$chunkMeshes.get(pass).finishConstruction();
            ((ITessellator)Tessellator.field_78398_a).enableMeshCapturing(false);
            ChunkMesh.setCaptureTarget(null);
        }
    }

    @Inject(method={"setDontDraw"}, at={@At(value="HEAD")}, require=1)
    private void preSetDontDraw(CallbackInfo ci) {
        if (Neodymium.isActive()) {
            Neodymium.renderer.onWorldRendererChanged((WorldRenderer)WorldRenderer.class.cast(this), NeoRenderer.WorldRendererChange.DELETED);
        }
    }

    @Override
    public List<ChunkMesh> getChunkMeshes() {
        return this.nd$chunkMeshes;
    }

    @Inject(method={"updateInFrustum"}, at={@At(value="HEAD")}, require=1)
    private void preUpdateInFrustum(CallbackInfo ci) {
        this.saveDrawnStatus();
    }

    @Inject(method={"updateInFrustum"}, at={@At(value="RETURN")}, require=1)
    private void postUpdateInFrustum(CallbackInfo ci) {
        this.notifyIfDrawnStatusChanged();
    }

    @Unique
    private void saveDrawnStatus() {
        this.nd$savedDrawnStatus = this.isDrawn();
    }

    @Unique
    private void notifyIfDrawnStatusChanged() {
        boolean drawn = this.isDrawn();
        if (Neodymium.isActive() && drawn != this.nd$savedDrawnStatus) {
            Neodymium.renderer.onWorldRendererChanged((WorldRenderer)WorldRenderer.class.cast(this), drawn ? NeoRenderer.WorldRendererChange.VISIBLE : NeoRenderer.WorldRendererChange.INVISIBLE);
        }
    }

    @Override
    public boolean isDrawn() {
        return !(!this.field_78927_l && !Compat.isOptiFineShadersEnabled() || this.field_78928_m[0] && this.field_78928_m[1]);
    }
}

