/*
 * Decompiled with CFR 0.152.
 */
package makamys.neodymium.renderer;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import makamys.neodymium.renderer.NeoRegion;
import makamys.neodymium.renderer.QuadNormal;
import makamys.neodymium.util.Util;

public abstract class Mesh {
    public ByteBuffer buffer;
    public int quadCount;
    public boolean visible;
    public GPUStatus gpuStatus = GPUStatus.UNSENT;
    public int iFirst = -1;
    public int iCount = -1;
    public long offset = -1L;
    public int pass;
    int x;
    int y;
    int z;
    public QuadNormal normal = QuadNormal.NONE;
    public NeoRegion containingRegion;

    public double distSq(double x2, double y2, double z2) {
        return Util.distSq((double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5, x2, y2, z2);
    }

    public int bufferSize() {
        return this.buffer == null ? 0 : this.buffer.limit();
    }

    public long getEnd() {
        return this.offset + (long)this.bufferSize();
    }

    public void prepareBuffer() {
    }

    public void destroyBuffer() {
    }

    public int writeToIndexBuffer(IntBuffer piFirst, IntBuffer piCount, int cameraXDiv, int cameraYDiv, int cameraZDiv, int pass) {
        piFirst.put(this.iFirst);
        piCount.put(this.iCount);
        return 1;
    }

    public static enum GPUStatus {
        UNSENT,
        SENT,
        PENDING_DELETE;

    }
}

