/*
 * Decompiled with CFR 0.152.
 */
package makamys.neodymium.renderer;

import java.util.List;
import makamys.neodymium.Neodymium;
import makamys.neodymium.renderer.ChunkMesh;
import makamys.neodymium.renderer.NeoRegion;
import makamys.neodymium.renderer.NeoRenderer;
import net.minecraft.entity.Entity;

public class NeoChunk {
    int x;
    int z;
    int lod = 0;
    boolean visible;
    boolean dirty;
    NeoRegion region;
    ChunkMesh[] chunkMeshes = new ChunkMesh[32];
    public boolean[] isSectionVisible = new boolean[16];
    NeoRenderer renderer = Neodymium.renderer;

    public NeoChunk(int x, int z, NeoRegion region) {
        this.x = x;
        this.z = z;
        this.region = region;
    }

    public String toString() {
        return "NeoChunk(" + this.x + ", " + this.z + ")";
    }

    public double distSq(Entity entity) {
        return Math.pow(entity.field_70165_t - (double)(this.x * 16), 2.0) + Math.pow(entity.field_70161_v - (double)(this.z * 16), 2.0);
    }

    public void putChunkMeshes(int cy, List<ChunkMesh> newChunkMeshes, boolean addOnly) {
        for (int i = 0; i < 2; ++i) {
            ChunkMesh newChunkMesh;
            ChunkMesh chunkMesh = newChunkMesh = newChunkMeshes.size() > i ? newChunkMeshes.get(i) : null;
            if (newChunkMesh == null && addOnly) continue;
            if (this.chunkMeshes[cy * 2 + i] != null) {
                this.renderer.removeMesh(this.chunkMeshes[cy * 2 + i]);
                this.chunkMeshes[cy * 2 + i].destroy();
                --this.region.meshes;
                this.dirty = true;
            }
            if (newChunkMesh != null) {
                ++this.region.meshes;
                this.dirty = true;
            }
            this.chunkMeshes[cy * 2 + i] = newChunkMesh;
        }
        if (this.dirty) {
            Neodymium.renderer.neoChunkChanged(this);
        }
    }

    public boolean hasChunkMeshes() {
        for (ChunkMesh cm : this.chunkMeshes) {
            if (cm == null) continue;
            return true;
        }
        return false;
    }

    public void tick() {
        this.setLOD(2);
    }

    public void setLOD(int lod) {
        if (lod == this.lod) {
            return;
        }
        this.lod = lod;
        Neodymium.renderer.neoChunkChanged(this);
        if (!this.dirty && lod < 2) {
            for (int i = 0; i < this.chunkMeshes.length; ++i) {
                if (this.chunkMeshes[i] == null) continue;
                this.chunkMeshes[i].destroy();
                this.chunkMeshes[i] = null;
                --this.region.meshes;
            }
        }
    }

    public void destroy() {
        for (ChunkMesh cm : this.chunkMeshes) {
            if (cm == null) continue;
            cm.destroy();
            --this.region.meshes;
        }
        Neodymium.renderer.setVisible(this, false);
    }

    public boolean isFullyVisible() {
        if (!this.visible) {
            return false;
        }
        for (boolean b : this.isSectionVisible) {
            if (b) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        for (ChunkMesh cm : this.chunkMeshes) {
            if (cm == null) continue;
            return false;
        }
        return true;
    }
}

