/*
 * Decompiled with CFR 0.152.
 */
package makamys.neodymium.renderer;

import com.falsepattern.falsetweaks.api.triangulator.VertexAPI;
import com.falsepattern.rple.api.client.RPLELightMapUtil;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import makamys.neodymium.Compat;
import makamys.neodymium.Neodymium;
import makamys.neodymium.config.Config;
import makamys.neodymium.ducks.IWorldRenderer;
import makamys.neodymium.renderer.ChunkMesh;
import makamys.neodymium.renderer.Comparators;
import makamys.neodymium.renderer.GPUMemoryManager;
import makamys.neodymium.renderer.Mesh;
import makamys.neodymium.renderer.NeoChunk;
import makamys.neodymium.renderer.NeoRegion;
import makamys.neodymium.renderer.attribs.AttributeSet;
import makamys.neodymium.util.CheatHelper;
import makamys.neodymium.util.GuiHelper;
import makamys.neodymium.util.OFUtil;
import makamys.neodymium.util.Preprocessor;
import makamys.neodymium.util.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import org.lwjgl.BufferUtils;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.ARBVertexShader;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL14;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector4f;

public class NeoRenderer {
    public boolean hasInited = false;
    public boolean destroyPending;
    public boolean reloadPending;
    public int rendererSpeedup;
    private static boolean[] wasDown = new boolean[256];
    public boolean renderWorld;
    public boolean rendererActive;
    private boolean showMemoryDebugger;
    public boolean forceRenderFog;
    public boolean hasIncompatibilities;
    private boolean fogEnabled;
    private static int MAX_MESHES;
    private int VAO;
    private int[] shaderProgramsFog = new int[]{0, 0};
    private int[] shaderProgramsNoFog = new int[]{0, 0};
    private IntBuffer[] piFirst = new IntBuffer[2];
    private IntBuffer[] piCount = new IntBuffer[2];
    GPUMemoryManager mem;
    private AttributeSet attributes;
    private Map<ChunkCoordIntPair, NeoRegion> loadedRegionsMap = new HashMap<ChunkCoordIntPair, NeoRegion>();
    private List<NeoRegion> loadedRegionsList = new ArrayList<NeoRegion>();
    public World world;
    private double eyePosX;
    private double eyePosY;
    private double eyePosZ;
    private double eyePosXT;
    private double eyePosYT;
    private double eyePosZT;
    int eyePosXTDiv;
    int eyePosYTDiv;
    int eyePosZTDiv;
    private int renderedMeshes;
    private int renderedQuads;
    private int frameCount;
    Vector4f transformedOrigin = new Vector4f();
    FloatBuffer modelView = BufferUtils.createFloatBuffer((int)16);
    FloatBuffer projBuf = BufferUtils.createFloatBuffer((int)16);
    IntBuffer viewportBuf = BufferUtils.createIntBuffer((int)16);
    FloatBuffer projInvBuf = BufferUtils.createFloatBuffer((int)16);
    FloatBuffer fogColorBuf = BufferUtils.createFloatBuffer((int)16);
    FloatBuffer fogStartEnd = BufferUtils.createFloatBuffer((int)2);
    Matrix4f modelViewMatrix = new Matrix4f();
    Matrix4f modelViewMatrixInv = new Matrix4f();
    Matrix4f projMatrix = new Matrix4f();

    public NeoRenderer(World world) {
        this.world = world;
        if (this.shouldRenderInWorld(world)) {
            this.hasInited = this.init();
        }
        this.renderWorld = true;
        this.rendererActive = true;
    }

    public int preRenderSortedRenderers(int renderPass, double alpha, WorldRenderer[] sortedWorldRenderers) {
        int rendered = 0;
        if (this.hasInited) {
            if (renderPass == 0) {
                this.renderedMeshes = 0;
                this.renderedQuads = 0;
                this.mainLoop();
                if (Minecraft.func_71410_x().field_71462_r == null) {
                    this.handleKeyboard();
                }
                if (this.mem.getCoherenceRate() < 0.95f || this.frameCount % 4 == 0) {
                    this.mem.runGC(false);
                }
                if (this.rendererActive && this.renderWorld) {
                    this.updateGLValues();
                    this.transformedOrigin.set(0.0f, 0.0f, 0.0f, 1.0f);
                    Matrix4f.transform((Matrix4f)this.modelViewMatrixInv, (Vector4f)this.transformedOrigin, (Vector4f)this.transformedOrigin);
                    EntityLivingBase rve = Minecraft.func_71410_x().field_71451_h;
                    this.eyePosX = rve.field_70142_S + (rve.field_70165_t - rve.field_70142_S) * alpha;
                    this.eyePosY = rve.field_70137_T + (rve.field_70163_u - rve.field_70137_T) * alpha + (double)rve.func_70047_e();
                    this.eyePosZ = rve.field_70136_U + (rve.field_70161_v - rve.field_70136_U) * alpha;
                    this.eyePosXT = this.eyePosX + (double)this.transformedOrigin.x;
                    this.eyePosYT = this.eyePosY + (double)this.transformedOrigin.y;
                    this.eyePosZT = this.eyePosZ + (double)this.transformedOrigin.z;
                    this.eyePosXTDiv = Math.floorDiv((int)Math.floor(this.eyePosXT), 16);
                    this.eyePosYTDiv = Math.floorDiv((int)Math.floor(this.eyePosYT), 16);
                    this.eyePosZTDiv = Math.floorDiv((int)Math.floor(this.eyePosZT), 16);
                    this.sort(this.frameCount % 100 == 0, this.frameCount % Config.sortFrequency == 0);
                    this.initIndexBuffers();
                    if (!Compat.keepRenderListLogic() && !Compat.isFalseTweaksModPresent()) {
                        NeoRenderer.updateRenderGlobalStats();
                    }
                }
                ++this.frameCount;
            }
            if (this.rendererActive && this.renderWorld) {
                Minecraft.func_71410_x().field_71460_t.func_78463_b(alpha);
                rendered += this.render(renderPass, alpha);
                Minecraft.func_71410_x().field_71460_t.func_78483_a(alpha);
            }
        }
        return rendered;
    }

    public void onRenderTickEnd() {
        if (Neodymium.isActive()) {
            if (this.reloadPending) {
                Minecraft.func_71410_x().field_71438_f.func_72712_a();
            }
            if (this.showMemoryDebugger && this.mem != null) {
                GuiHelper.begin();
                this.mem.drawInfo();
                GuiHelper.end();
            }
        } else if (this.destroyPending) {
            this.destroy();
            this.destroyPending = false;
            Neodymium.renderer = null;
            Minecraft.func_71410_x().field_71438_f.func_72712_a();
        }
    }

    private void sort(boolean pass0, boolean pass1) {
        for (NeoRegion r : this.loadedRegionsMap.values()) {
            r.getRenderData().sort(this.eyePosX, this.eyePosY, this.eyePosZ, pass0, pass1);
        }
    }

    private void initIndexBuffers() {
        this.loadedRegionsList.clear();
        this.loadedRegionsList.addAll(this.loadedRegionsMap.values());
        this.loadedRegionsList.sort(Comparators.REGION_DISTANCE_COMPARATOR.setOrigin(this.eyePosX, this.eyePosY, this.eyePosZ));
        for (int i = 0; i < 2; ++i) {
            int regionI;
            this.piFirst[i].limit(MAX_MESHES);
            this.piCount[i].limit(MAX_MESHES);
            int order = i == 0 ? 1 : -1;
            int n = regionI = order == 1 ? 0 : this.loadedRegionsList.size() - 1;
            while (regionI >= 0 && regionI < this.loadedRegionsList.size()) {
                NeoRegion.RenderData region = this.loadedRegionsList.get(regionI).getRenderData();
                region.batchFirst[i] = this.piFirst[i].position();
                for (Mesh mesh : region.getSentMeshes(i)) {
                    WorldRenderer wr = ((ChunkMesh)mesh).wr;
                    if (!mesh.visible || !wr.field_78936_t || !this.shouldRenderMesh(mesh)) continue;
                    int meshes = mesh.writeToIndexBuffer(this.piFirst[i], this.piCount[i], this.eyePosXTDiv, this.eyePosYTDiv, this.eyePosZTDiv, i);
                    this.renderedMeshes += meshes;
                    for (int j = this.piCount[i].position() - meshes; j < this.piCount[i].position(); ++j) {
                        this.renderedQuads += this.piCount[i].get(j) / 4;
                    }
                    if (!Compat.isSpeedupAnimationsEnabled() || Compat.keepRenderListLogic()) continue;
                    wr.func_78909_a(i);
                }
                region.batchLimit[i] = this.piFirst[i].position();
                regionI += order;
            }
            this.piFirst[i].flip();
            this.piCount[i].flip();
        }
    }

    private boolean shouldRenderMesh(Mesh mesh) {
        return (Config.maxMeshesPerFrame == -1 || this.renderedMeshes < Config.maxMeshesPerFrame) && (!this.isFogEnabled() && !Config.fogOcclusionWithoutFog || Config.fogOcclusion == !Config.fogOcclusion || mesh.distSq(this.eyePosX / 16.0, (double)mesh.y + 0.5, this.eyePosZ / 16.0) < Math.pow((double)this.fogStartEnd.get(1) / 16.0 + 1.0, 2.0));
    }

    private static void updateRenderGlobalStats() {
        RenderGlobal rg = Minecraft.func_71410_x().field_71438_f;
        for (WorldRenderer wr : rg.field_72768_k) {
            if (wr == null) continue;
            ++rg.field_72751_K;
            if (wr.field_78928_m[0]) {
                ++rg.field_72747_O;
                continue;
            }
            if (!wr.field_78927_l) {
                ++rg.field_72744_L;
                continue;
            }
            if (rg.field_72774_t && !wr.field_78936_t) {
                ++rg.field_72745_M;
                continue;
            }
            ++rg.field_72746_N;
        }
    }

    private void mainLoop() {
        if (Minecraft.func_71410_x().field_71442_b.field_78774_b.field_147309_h) {
            Iterator<Map.Entry<ChunkCoordIntPair, NeoRegion>> it = this.loadedRegionsMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<ChunkCoordIntPair, NeoRegion> kv = it.next();
                NeoRegion v = kv.getValue();
                if (v.shouldDelete()) {
                    v.destroy();
                    it.remove();
                    continue;
                }
                v.tick();
            }
        }
    }

    private void handleKeyboard() {
        if (Config.debugPrefix == 0 || Config.debugPrefix != -1 && Keyboard.isKeyDown((int)Config.debugPrefix)) {
            if (CheatHelper.canCheat()) {
                if (Keyboard.isKeyDown((int)33) && !wasDown[33]) {
                    boolean bl = this.rendererActive = !this.rendererActive;
                }
                if (Keyboard.isKeyDown((int)47) && !wasDown[47]) {
                    boolean bl = this.renderWorld = !this.renderWorld;
                }
            }
            if (Keyboard.isKeyDown((int)19) && !wasDown[19]) {
                this.reloadShader();
            }
            if (Keyboard.isKeyDown((int)50) && !wasDown[50]) {
                boolean bl = this.showMemoryDebugger = !this.showMemoryDebugger;
            }
            if (Keyboard.isKeyDown((int)25) && !wasDown[25]) {
                Util.dumpTexture();
            }
            if (Keyboard.isKeyDown((int)203) && !wasDown[203]) {
                this.reloadPending = true;
            }
            if (Keyboard.isKeyDown((int)205) && !wasDown[205]) {
                this.rendererSpeedup = this.rendererSpeedup == 0 ? 300 : 0;
            }
        }
        for (int i = 0; i < 256; ++i) {
            NeoRenderer.wasDown[i] = Keyboard.isKeyDown((int)i);
        }
    }

    private int render(int pass, double alpha) {
        int regionI;
        if (!Compat.isOptiFineShadersEnabled()) {
            int shader = this.getShaderProgram(pass);
            if (shader == 0) {
                return 0;
            }
            GL20.glUseProgram((int)shader);
            this.updateUniforms(alpha, pass);
        }
        GL30.glBindVertexArray((int)this.VAO);
        if (NeoRenderer.isWireframeEnabled()) {
            GL11.glPolygonMode((int)1032, (int)6913);
        }
        int u_renderOffset = -1;
        if (!Compat.isOptiFineShadersEnabled()) {
            u_renderOffset = GL20.glGetUniformLocation((int)this.getShaderProgram(pass), (CharSequence)"renderOffset");
        }
        int oldLimit = this.piFirst[pass].limit();
        int rendered = 0;
        int order = pass == 0 ? 1 : -1;
        int n = regionI = order == 1 ? 0 : this.loadedRegionsList.size() - 1;
        while (regionI >= 0 && regionI < this.loadedRegionsList.size()) {
            NeoRegion.RenderData region = this.loadedRegionsList.get(regionI).getRenderData();
            rendered += region.batchLimit[pass] - region.batchFirst[pass];
            Util.setPositionAndLimit(this.piFirst[pass], region.batchFirst[pass], region.batchLimit[pass]);
            Util.setPositionAndLimit(this.piCount[pass], region.batchFirst[pass], region.batchLimit[pass]);
            if (Compat.isOptiFineShadersEnabled()) {
                GL11.glMatrixMode((int)5888);
                float offsetX = (float)(region.originX - this.eyePosX);
                float offsetY = (float)(region.originY - this.eyePosY + 0.12);
                float offsetZ = (float)(region.originZ - this.eyePosZ);
                GL11.glPushMatrix();
                GL11.glTranslatef((float)offsetX, (float)offsetY, (float)offsetZ);
            } else {
                GL20.glUniform3f((int)u_renderOffset, (float)((float)(region.originX - this.eyePosX)), (float)((float)(region.originY - this.eyePosY)), (float)((float)(region.originZ - this.eyePosZ)));
            }
            GL14.glMultiDrawArrays((int)7, (IntBuffer)this.piFirst[pass], (IntBuffer)this.piCount[pass]);
            if (Compat.isOptiFineShadersEnabled()) {
                GL11.glPopMatrix();
            }
            regionI += order;
        }
        Util.setPositionAndLimit(this.piFirst[pass], 0, oldLimit);
        Util.setPositionAndLimit(this.piCount[pass], 0, oldLimit);
        if (NeoRenderer.isWireframeEnabled()) {
            GL11.glPolygonMode((int)1032, (int)6914);
        }
        if (!Compat.isOptiFineShadersEnabled()) {
            GL20.glUseProgram((int)0);
        }
        GL30.glBindVertexArray((int)0);
        return rendered;
    }

    private void updateGLValues() {
        GL11.glGetFloat((int)2982, (FloatBuffer)this.modelView);
        GL11.glGetFloat((int)2983, (FloatBuffer)this.projBuf);
        GL11.glGetInteger((int)2978, (IntBuffer)this.viewportBuf);
        this.projMatrix.load(this.projBuf);
        this.projBuf.flip();
        this.projMatrix.invert();
        this.projMatrix.store(this.projInvBuf);
        this.projInvBuf.flip();
        this.modelViewMatrix.load(this.modelView);
        this.modelView.flip();
        this.modelViewMatrixInv.load(this.modelViewMatrix).invert();
        this.fogColorBuf.limit(16);
        GL11.glGetFloat((int)2918, (FloatBuffer)this.fogColorBuf);
        this.fogColorBuf.limit(4);
        this.fogStartEnd.put(GL11.glGetFloat((int)2915));
        this.fogStartEnd.put(GL11.glGetFloat((int)2916));
        this.fogStartEnd.flip();
        this.fogEnabled = GL11.glIsEnabled((int)2912) && !OFUtil.isFogOff();
    }

    private void updateUniforms(double alpha, int pass) {
        int shaderProgram = this.getShaderProgram(pass);
        int u_modelView = GL20.glGetUniformLocation((int)shaderProgram, (CharSequence)"modelView");
        int u_proj = GL20.glGetUniformLocation((int)shaderProgram, (CharSequence)"proj");
        int u_playerPos = GL20.glGetUniformLocation((int)shaderProgram, (CharSequence)"playerPos");
        int u_light = 0;
        int u_light_r = 0;
        int u_light_g = 0;
        int u_light_b = 0;
        if (Compat.isRPLEModPresent()) {
            u_light_r = GL20.glGetUniformLocation((int)shaderProgram, (CharSequence)"lightTexR");
            u_light_g = GL20.glGetUniformLocation((int)shaderProgram, (CharSequence)"lightTexG");
            u_light_b = GL20.glGetUniformLocation((int)shaderProgram, (CharSequence)"lightTexB");
        } else {
            u_light = GL20.glGetUniformLocation((int)shaderProgram, (CharSequence)"lightTex");
        }
        int u_viewport = GL20.glGetUniformLocation((int)shaderProgram, (CharSequence)"viewport");
        int u_projInv = GL20.glGetUniformLocation((int)shaderProgram, (CharSequence)"projInv");
        int u_fogColor = GL20.glGetUniformLocation((int)shaderProgram, (CharSequence)"fogColor");
        int u_fogStartEnd = GL20.glGetUniformLocation((int)shaderProgram, (CharSequence)"fogStartEnd");
        int u_fogMode = GL20.glGetUniformLocation((int)shaderProgram, (CharSequence)"fogMode");
        int u_fogDensity = GL20.glGetUniformLocation((int)shaderProgram, (CharSequence)"fogDensity");
        GL20.glUniformMatrix4((int)u_modelView, (boolean)false, (FloatBuffer)this.modelView);
        GL20.glUniformMatrix4((int)u_proj, (boolean)false, (FloatBuffer)this.projBuf);
        GL20.glUniformMatrix4((int)u_projInv, (boolean)false, (FloatBuffer)this.projInvBuf);
        GL20.glUniform4f((int)u_viewport, (float)this.viewportBuf.get(0), (float)this.viewportBuf.get(1), (float)this.viewportBuf.get(2), (float)this.viewportBuf.get(3));
        GL20.glUniform4((int)u_fogColor, (FloatBuffer)this.fogColorBuf);
        GL20.glUniform2((int)u_fogStartEnd, (FloatBuffer)this.fogStartEnd);
        GL20.glUniform1i((int)u_fogMode, (int)GL11.glGetInteger((int)2917));
        GL20.glUniform1f((int)u_fogDensity, (float)GL11.glGetFloat((int)2914));
        GL20.glUniform3f((int)u_playerPos, (float)((float)this.eyePosX), (float)((float)this.eyePosY), (float)((float)this.eyePosZ));
        if (Compat.isRPLEModPresent()) {
            GL20.glUniform1i((int)u_light_r, (int)1);
            GL20.glUniform1i((int)u_light_g, (int)2);
            GL20.glUniform1i((int)u_light_b, (int)3);
        } else {
            GL20.glUniform1i((int)u_light, (int)1);
        }
        this.modelView.position(0);
        this.projBuf.position(0);
        this.viewportBuf.position(0);
        this.projInvBuf.position(0);
        this.fogColorBuf.position(0);
        this.fogStartEnd.position(0);
    }

    public boolean init() {
        MAX_MESHES = Config.VRAMSize * 128;
        Compat.updateOptiFineShadersState();
        this.attributes = new AttributeSet();
        Neodymium.util.initVertexAttributes(this.attributes);
        this.reloadShader();
        this.VAO = GL30.glGenVertexArrays();
        GL30.glBindVertexArray((int)this.VAO);
        this.mem = new GPUMemoryManager();
        GL15.glBindBuffer((int)34962, (int)this.mem.VBO);
        boolean optiFineShaders = Compat.isOptiFineShadersEnabled();
        if (optiFineShaders) {
            NeoRenderer.initOptiFineShadersVertexPointers();
        } else {
            this.attributes.enable();
        }
        for (int i = 0; i < 2; ++i) {
            this.piFirst[i] = BufferUtils.createIntBuffer((int)MAX_MESHES);
            this.piFirst[i].flip();
            this.piCount[i] = BufferUtils.createIntBuffer((int)MAX_MESHES);
            this.piCount[i].flip();
        }
        GL15.glBindBuffer((int)34962, (int)0);
        GL30.glBindVertexArray((int)0);
        return true;
    }

    private static void initOptiFineShadersVertexPointers() {
        int stride = Compat.isFalseTweaksModPresent() ? VertexAPI.recomputeVertexInfo((int)18, (int)4) : 72;
        int entityAttrib = 10;
        int midTexCoordAttrib = 11;
        int tangentAttrib = 12;
        GL11.glVertexPointer((int)3, (int)5126, (int)stride, (long)0L);
        GL11.glEnableClientState((int)32884);
        GL11.glTexCoordPointer((int)2, (int)5126, (int)stride, (long)12L);
        GL11.glEnableClientState((int)32888);
        GL11.glColorPointer((int)4, (int)5121, (int)stride, (long)20L);
        GL11.glEnableClientState((int)32886);
        if (!Compat.isRPLEModPresent()) {
            OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77476_b);
            GL11.glTexCoordPointer((int)2, (int)5122, (int)stride, (long)24L);
            GL11.glEnableClientState((int)32888);
            OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
        }
        GL20.glVertexAttribPointer((int)10, (int)3, (int)5122, (boolean)false, (int)stride, (long)28L);
        GL20.glEnableVertexAttribArray((int)10);
        GL11.glNormalPointer((int)5126, (int)stride, (long)36L);
        GL11.glEnableClientState((int)32885);
        GL20.glVertexAttribPointer((int)12, (int)4, (int)5126, (boolean)false, (int)stride, (long)48L);
        GL20.glEnableVertexAttribArray((int)12);
        GL13.glClientActiveTexture((int)33987);
        GL11.glTexCoordPointer((int)2, (int)5126, (int)stride, (long)64L);
        GL11.glEnableClientState((int)32888);
        OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
        ARBVertexShader.glVertexAttribPointerARB((int)11, (int)2, (int)5126, (boolean)false, (int)stride, (long)64L);
        ARBVertexShader.glEnableVertexAttribArrayARB((int)11);
        if (Compat.isRPLEModPresent()) {
            RPLELightMapUtil.enableVertexPointersVBO();
            ARBVertexShader.glVertexAttribPointerARB((int)13, (int)2, (int)5126, (boolean)false, (int)stride, (long)80L);
            ARBVertexShader.glEnableVertexAttribArrayARB((int)13);
        }
    }

    public int getStride() {
        return this.attributes.stride();
    }

    public void reloadShader(int pass, AttributeSet attributeSet) {
        for (int hasFog = 0; hasFog <= 1; ++hasFog) {
            HashMap<String, String> defines = new HashMap<String, String>();
            if (hasFog == 1) {
                defines.put("RENDER_FOG", "");
            }
            if (Config.shortUV) {
                defines.put("SHORT_UV", "");
            }
            if (Compat.isRPLEModPresent()) {
                defines.put("RPLE", "");
            }
            if (pass == 0) {
                defines.put("PASS_0", "");
            }
            attributeSet.addDefines(defines);
            boolean errors = false;
            int vertexShader = GL20.glCreateShader((int)35633);
            GL20.glShaderSource((int)vertexShader, (CharSequence)Preprocessor.preprocess(Util.readFile("shaders/chunk.vert"), defines));
            GL20.glCompileShader((int)vertexShader);
            if (GL20.glGetShaderi((int)vertexShader, (int)35713) == 0) {
                System.out.println("Error compiling vertex shader: " + GL20.glGetShaderInfoLog((int)vertexShader, (int)256));
                errors = true;
            }
            int fragmentShader = GL20.glCreateShader((int)35632);
            GL20.glShaderSource((int)fragmentShader, (CharSequence)Preprocessor.preprocess(Util.readFile("shaders/chunk.frag"), defines));
            GL20.glCompileShader((int)fragmentShader);
            if (GL20.glGetShaderi((int)fragmentShader, (int)35713) == 0) {
                System.out.println("Error compiling fragment shader: " + GL20.glGetShaderInfoLog((int)fragmentShader, (int)256));
                errors = true;
            }
            int newShaderProgram = GL20.glCreateProgram();
            GL20.glAttachShader((int)newShaderProgram, (int)vertexShader);
            GL20.glAttachShader((int)newShaderProgram, (int)fragmentShader);
            GL20.glLinkProgram((int)newShaderProgram);
            if (GL20.glGetProgrami((int)newShaderProgram, (int)35714) == 0) {
                System.out.println("Error linking shader: " + GL20.glGetShaderInfoLog((int)newShaderProgram, (int)256));
                errors = true;
            }
            if (!errors) {
                (hasFog == 1 ? this.shaderProgramsFog : this.shaderProgramsNoFog)[pass] = newShaderProgram;
            }
            GL20.glDeleteShader((int)vertexShader);
            GL20.glDeleteShader((int)fragmentShader);
        }
    }

    public void reloadShader() {
        this.reloadShader(0, this.attributes);
        this.reloadShader(1, this.attributes);
    }

    public void destroy() {
        if (!this.hasInited) {
            return;
        }
        GL20.glDeleteProgram((int)this.shaderProgramsFog[0]);
        GL20.glDeleteProgram((int)this.shaderProgramsFog[1]);
        GL20.glDeleteProgram((int)this.shaderProgramsNoFog[0]);
        GL20.glDeleteProgram((int)this.shaderProgramsNoFog[1]);
        GL30.glDeleteVertexArrays((int)this.VAO);
        this.mem.destroy();
        ChunkMesh.instances = 0;
        ChunkMesh.usedRAM = 0;
    }

    public void onWorldRendererChanged(WorldRenderer wr, WorldRendererChange change) {
        int x = Math.floorDiv(wr.field_78923_c, 16);
        int y = Math.floorDiv(wr.field_78920_d, 16);
        int z = Math.floorDiv(wr.field_78921_e, 16);
        NeoChunk neoChunk = this.getNeoChunk(x, z);
        boolean bl = neoChunk.isSectionVisible[y] = change == WorldRendererChange.VISIBLE;
        if (change == WorldRendererChange.DELETED) {
            this.removeMesh(neoChunk.chunkMeshes[y]);
            if (neoChunk.chunkMeshes[y] != null) {
                neoChunk.chunkMeshes[y].destroy();
                neoChunk.chunkMeshes[y] = null;
                --neoChunk.region.meshes;
            }
        }
        this.neoChunkChanged(neoChunk);
    }

    public void onWorldRendererPost(WorldRenderer wr, boolean sort) {
        int x = Math.floorDiv(wr.field_78923_c, 16);
        int y = Math.floorDiv(wr.field_78920_d, 16);
        int z = Math.floorDiv(wr.field_78921_e, 16);
        if (Minecraft.func_71410_x().field_71441_e.func_72964_e((int)x, (int)z).field_76636_d) {
            NeoChunk neoChunk = this.getNeoChunk(x, z);
            neoChunk.isSectionVisible[y] = ((IWorldRenderer)wr).isDrawn();
            neoChunk.putChunkMeshes(y, ((IWorldRenderer)wr).getChunkMeshes(), sort);
        }
    }

    public void onRenderFog() {
        this.forceRenderFog = false;
    }

    private NeoChunk getNeoChunk(int chunkX, int chunkZ) {
        return this.getRegionContaining(chunkX, chunkZ).getChunkAbsolute(chunkX, chunkZ);
    }

    private NeoRegion getRegionContaining(int chunkX, int chunkZ) {
        int regionZ;
        int regionX = Math.floorDiv(chunkX, 64);
        ChunkCoordIntPair key = new ChunkCoordIntPair(regionX, regionZ = Math.floorDiv(chunkZ, 64));
        NeoRegion region = this.loadedRegionsMap.get(key);
        if (region == null) {
            region = NeoRegion.load(regionX, regionZ);
            this.loadedRegionsMap.put(key, region);
        }
        return region;
    }

    public void setVisible(NeoChunk chunk, boolean visible) {
        this.setVisible(chunk, visible, false);
    }

    public void setVisible(NeoChunk neoChunk, boolean visible, boolean forceCheck) {
        if (!forceCheck && visible == neoChunk.visible) {
            return;
        }
        neoChunk.visible = visible;
        this.neoChunkChanged(neoChunk);
    }

    public void neoChunkChanged(NeoChunk neoChunk) {
        int newLOD = neoChunk.hasChunkMeshes() ? 2 : 0;
        for (int y = 0; y < 16; ++y) {
            for (int pass = 0; pass < 2; ++pass) {
                ChunkMesh cm = neoChunk.chunkMeshes[y * 2 + pass];
                if (cm == null) continue;
                if (neoChunk.isSectionVisible[y] && newLOD == 2) {
                    if (cm.visible) continue;
                    this.setMeshVisible(cm, true);
                    continue;
                }
                if (!cm.visible) continue;
                this.setMeshVisible(cm, false);
            }
        }
    }

    protected void setMeshVisible(Mesh mesh, boolean visible) {
        if (mesh == null) {
            return;
        }
        if (mesh.visible != visible) {
            mesh.visible = visible;
            if (mesh.gpuStatus == Mesh.GPUStatus.UNSENT) {
                this.mem.sendMeshToGPU(mesh);
                NeoRegion region = this.getRegionContaining(mesh.x, mesh.z);
                region.getRenderData().getSentMeshes(mesh.pass).add(mesh);
                mesh.containingRegion = region;
            }
        }
    }

    public void removeMesh(Mesh mesh) {
        if (mesh == null) {
            return;
        }
        this.mem.deleteMeshFromGPU(mesh);
        if (mesh.containingRegion != null) {
            mesh.containingRegion.getRenderData().getSentMeshes(mesh.pass).remove(mesh);
        }
        this.setMeshVisible(mesh, false);
    }

    public List<String> getDebugText(boolean statusCommand) {
        ArrayList<String> text = new ArrayList<String>();
        text.add((!this.rendererActive ? EnumChatFormatting.RED + "(OFF) " : "") + (statusCommand ? EnumChatFormatting.LIGHT_PURPLE : "") + "Neodymium " + "0.2.5");
        text.addAll(this.mem.getDebugText());
        text.addAll(Arrays.asList("Meshes: " + ChunkMesh.instances + " (" + ChunkMesh.usedRAM / 1024 / 1024 + "MB)", "Rendered: " + this.renderedMeshes + " (" + this.renderedQuads / 1000 + "KQ)"));
        if (this.rendererSpeedup > 0) {
            text.add(EnumChatFormatting.YELLOW + "(!) Renderer speedup active");
        }
        if (this.hasIncompatibilities) {
            text.add(EnumChatFormatting.YELLOW + "(!) Incompatibilities");
            if (!statusCommand) {
                text.add(EnumChatFormatting.YELLOW + "Type '/neodymium status'");
            }
        }
        return text;
    }

    private int getShaderProgram(int pass) {
        return (this.forceRenderFog || this.isFogEnabled() ? this.shaderProgramsFog : this.shaderProgramsNoFog)[pass];
    }

    private boolean isFogEnabled() {
        switch (Config.renderFog) {
            case TRUE: {
                return true;
            }
            case FALSE: {
                return false;
            }
        }
        return this.fogEnabled;
    }

    private boolean shouldRenderInWorld(World world) {
        return world != null;
    }

    private static boolean isWireframeEnabled() {
        return Config.wireframe && CheatHelper.canCheat();
    }

    public static enum WorldRendererChange {
        VISIBLE,
        INVISIBLE,
        DELETED;

    }
}

