/*
 * Decompiled with CFR 0.152.
 */
package makamys.neodymium.renderer.attribs;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.lwjgl.opengl.GL20;

public class AttributeSet {
    private final List<VertexAttribute> attributes = new ArrayList<VertexAttribute>();
    private int stride = 0;

    public void addAttribute(String name, int size, int elementSize, int type) {
        int index = this.attributes.size();
        this.attributes.add(new VertexAttribute(name, index, size, elementSize, type));
        this.stride += elementSize * size;
    }

    public int stride() {
        return this.stride;
    }

    public void enable() {
        int offset = 0;
        int size = this.attributes.size();
        for (int i = 0; i < size; ++i) {
            VertexAttribute attribute = this.attributes.get(i);
            GL20.glVertexAttribPointer((int)i, (int)attribute.size, (int)attribute.type, (boolean)false, (int)this.stride, (long)offset);
            offset += attribute.size * attribute.elementSize;
            GL20.glEnableVertexAttribArray((int)i);
        }
    }

    public void addDefines(Map<String, String> defines) {
        for (VertexAttribute attribute : this.attributes) {
            defines.put("ATTRIB_" + attribute.name, Integer.toString(attribute.index));
        }
    }

    public static class VertexAttribute {
        public final String name;
        public final int index;
        public final int size;
        public final int elementSize;
        public final int type;

        private VertexAttribute(String name, int index, int size, int elementSize, int type) {
            this.name = name;
            this.index = index;
            this.size = size;
            this.elementSize = elementSize;
            this.type = type;
        }
    }
}

