/*
 * Decompiled with CFR 0.152.
 */
package DelirusCrux.Netherlicious.Common.Blocks.NetherPlants;

import DelirusCrux.Netherlicious.Client.Render.RenderingUtility;
import DelirusCrux.Netherlicious.Common.BlockItemUtility.ModBlocks;
import DelirusCrux.Netherlicious.Common.Blocks.BlockNylium;
import DelirusCrux.Netherlicious.Utility.ModSounds;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ShroomFruit
extends Block {
    private IIcon[] icon = new IIcon[1];

    public ShroomFruit() {
        super(Material.field_151575_d);
        this.func_149711_c(0.4f);
        this.func_149675_a(true);
        this.func_149672_a(field_149766_f);
        this.func_149715_a(1.0f);
        this.func_149672_a(ModSounds.soundShroomlight);
    }

    public void func_149651_a(IIconRegister iconRegister) {
        this.icon[0] = iconRegister.func_94245_a("netherlicious:shroomlight");
    }

    public IIcon func_149691_a(int side, int meta) {
        return this.icon[0];
    }

    public int func_149645_b() {
        return RenderingUtility.ShroomFruit;
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        if (world.field_72995_K) {
            return;
        }
        int meta = world.func_72805_g(x, y, z);
        if (meta >= 5) {
            return;
        }
        if (!this.func_149718_j(world, x, y, z)) {
            world.func_147480_a(x, y, z, true);
        } else if (world.func_147437_c(x, y + 1, z)) {
            boolean canGrowUp = false;
            boolean isSegmentOnEndstone = false;
            Block lowerBlock = world.func_147439_a(x, y - 1, z);
            if (lowerBlock instanceof BlockNylium) {
                canGrowUp = true;
            } else if (lowerBlock == ModBlocks.ShroomStalk) {
                int height;
                int par8 = 1;
                for (height = 0; height < 4; ++height) {
                    Block b = world.func_147439_a(x, y - (par8 + 1), z);
                    if (b != ModBlocks.ShroomStalk) {
                        if (!(b instanceof BlockNylium)) break;
                        isSegmentOnEndstone = true;
                        break;
                    }
                    ++par8;
                }
                height = 4;
                if (isSegmentOnEndstone) {
                    ++height;
                }
                if (par8 < 2 || rand.nextInt(height) >= par8) {
                    canGrowUp = true;
                }
            } else if (lowerBlock.isAir((IBlockAccess)world, x, y - 1, z)) {
                canGrowUp = true;
            }
            if (canGrowUp && ShroomFruit.isSpaceAroundFree(world, x, y + 1, z, ForgeDirection.DOWN) && world.func_147437_c(x, y + 2, z)) {
                world.func_147449_b(x, y, z, ModBlocks.ShroomStalk);
                world.func_147465_d(x, y + 1, z, (Block)this, meta, 3);
            } else if (meta < 4) {
                int tries = rand.nextInt(4);
                boolean grew = false;
                if (isSegmentOnEndstone) {
                    ++tries;
                }
                for (int i = 0; i < tries; ++i) {
                    ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[rand.nextInt(ForgeDirection.VALID_DIRECTIONS.length)];
                    int xx = x + dir.offsetX;
                    int yy = y + dir.offsetY;
                    int zz = z + dir.offsetZ;
                    if (!world.func_147437_c(xx, yy, zz) || !ShroomFruit.isSpaceAroundFree(world, xx, yy, zz, dir.getOpposite())) continue;
                    world.func_147465_d(xx, yy, zz, (Block)this, meta + 1, 3);
                    grew = true;
                }
                if (grew) {
                    world.func_147465_d(x, y, z, ModBlocks.ShroomStalk, 0, 3);
                } else {
                    world.func_147465_d(x, y, z, (Block)this, 5, 3);
                }
            } else if (meta == 4) {
                world.func_147465_d(x, y, z, (Block)this, 5, 3);
            }
        }
    }

    public static boolean isSpaceAroundFree(World world, int x, int y, int z, ForgeDirection skip) {
        ForgeDirection dir;
        Iterator<ForgeDirection> iterator = Arrays.asList(ForgeDirection.VALID_DIRECTIONS).iterator();
        do {
            if (iterator.hasNext()) continue;
            return true;
        } while ((dir = iterator.next()) == skip || world.func_147437_c(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ));
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return this.func_149718_j(world, x, y, z);
    }
}

