/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.base;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import greymerk.roguelike.dungeon.base.DungeonRoom;
import greymerk.roguelike.dungeon.base.IDungeonRoom;
import greymerk.roguelike.dungeon.base.ISecretRoom;
import greymerk.roguelike.dungeon.base.SecretRoom;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.WorldEditor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class SecretFactory
implements ISecretRoom {
    private int count;
    private List<ISecretRoom> secrets;

    public SecretFactory() {
        this.count = 0;
        this.secrets = new ArrayList<ISecretRoom>();
    }

    public SecretFactory(SecretFactory toCopy) {
        this.secrets = new ArrayList<ISecretRoom>();
        this.count = toCopy.count;
        for (ISecretRoom room : toCopy.secrets) {
            ISecretRoom toAdd = room instanceof SecretFactory ? new SecretFactory((SecretFactory)room) : new SecretRoom((SecretRoom)room);
            this.secrets.add(toAdd);
        }
    }

    public SecretFactory(JsonArray data) {
        this.secrets = new ArrayList<ISecretRoom>();
        for (JsonElement e : data) {
            JsonObject room = e.getAsJsonObject();
            String type = room.get("type").getAsString();
            int num = room.get("num").getAsInt();
            this.count += num;
            this.secrets.add(new SecretRoom(DungeonRoom.valueOf(type), num));
        }
    }

    public void addRoom(DungeonRoom type) {
        this.addRoom(type, 1);
    }

    public void addRoom(DungeonRoom type, int count) {
        this.secrets.add(new SecretRoom(type, count));
        this.count += count;
    }

    public void addRoom(List<DungeonRoom> rooms, int count) {
        SecretFactory toAdd = new SecretFactory();
        for (DungeonRoom type : rooms) {
            toAdd.addRoom(type);
        }
        this.secrets.add(toAdd);
        this.count += count;
    }

    @Override
    public IDungeonRoom genRoom(WorldEditor editor, Random rand, LevelSettings settings, Cardinal dir, Coord pos) {
        if (this.count <= 0) {
            return null;
        }
        Collections.shuffle(this.secrets, rand);
        for (ISecretRoom room : this.secrets) {
            IDungeonRoom generated = room.genRoom(editor, rand, settings, dir, pos);
            if (generated == null) continue;
            return generated;
        }
        return null;
    }
}

