/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.rooms;

import greymerk.roguelike.dungeon.base.DungeonBase;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.theme.ITheme;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IBlockFactory;
import greymerk.roguelike.worldgen.IStair;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.MetaStair;
import greymerk.roguelike.worldgen.WorldEditor;
import greymerk.roguelike.worldgen.blocks.BlockType;
import greymerk.roguelike.worldgen.blocks.ColorBlock;
import greymerk.roguelike.worldgen.blocks.DyeColor;
import greymerk.roguelike.worldgen.blocks.Furnace;
import greymerk.roguelike.worldgen.blocks.StairType;
import greymerk.roguelike.worldgen.redstone.Torch;
import java.util.Random;

public class DungeonAshlea
extends DungeonBase {
    IBlockFactory plank;
    IStair stair;
    IBlockFactory log;

    @Override
    public boolean generate(WorldEditor editor, Random rand, LevelSettings settings, Cardinal[] entrances, Coord origin) {
        int x = origin.getX();
        int y = origin.getY();
        int z = origin.getZ();
        ITheme theme = settings.getTheme();
        this.plank = theme.getSecondaryWall();
        this.stair = theme.getSecondaryStair();
        this.log = theme.getSecondaryPillar();
        MetaBlock air = BlockType.get(BlockType.AIR);
        editor.fillRectSolid(rand, x - 6, y, z - 6, x + 6, y + 2, z + 6, air);
        editor.fillRectSolid(rand, x - 6, y + 3, z - 6, x + 6, y + 4, z + 6, this.plank, true, true);
        editor.fillRectSolid(rand, x - 4, y + 3, z - 2, x + 4, y + 3, z - 2, this.stair.setOrientation(Cardinal.SOUTH, true), true, true);
        editor.fillRectSolid(rand, x - 4, y + 3, z + 2, x + 4, y + 3, z + 2, this.stair.setOrientation(Cardinal.NORTH, true), true, true);
        editor.fillRectSolid(rand, x - 2, y + 3, z - 4, x - 2, y + 3, z + 4, this.stair.setOrientation(Cardinal.EAST, true), true, true);
        editor.fillRectSolid(rand, x + 2, y + 3, z - 4, x + 2, y + 3, z + 4, this.stair.setOrientation(Cardinal.WEST, true), true, true);
        editor.fillRectSolid(rand, x - 1, y + 3, z - 4, x + 1, y + 3, z + 4, air);
        editor.fillRectSolid(rand, x - 4, y + 3, z - 1, x + 4, y + 3, z + 1, air);
        MetaBlock clay = ColorBlock.get(ColorBlock.CLAY, DyeColor.PINK);
        editor.fillRectSolid(rand, x - 7, y - 1, z - 7, x + 7, y - 1, z + 7, clay, true, true);
        editor.fillRectSolid(rand, x - 1, y - 1, z - 6, x + 1, y - 1, z + 6, this.log, true, true);
        editor.fillRectSolid(rand, x - 5, y - 1, z - 1, x - 2, y - 1, z + 1, this.log, true, true);
        editor.fillRectSolid(rand, x + 2, y - 1, z - 1, x + 5, y - 1, z + 1, this.log, true, true);
        editor.fillRectSolid(rand, x + 7, y, z - 2, x + 7, y + 2, z + 6, this.plank, false, true);
        editor.fillRectSolid(rand, x - 7, y, z - 6, x - 7, y + 2, z + 6, this.plank, false, true);
        editor.fillRectSolid(rand, x - 6, y, z - 7, x + 2, y + 2, z - 7, this.plank, false, true);
        editor.fillRectSolid(rand, x - 6, y, z + 7, x + 6, y + 2, z + 7, this.plank, false, true);
        int i = -6;
        while (i <= 6) {
            for (int j = -6; j <= 6; j += 4) {
                DungeonAshlea.pillar(editor, rand, theme, x + i, y, z + j);
            }
            i += 4;
        }
        this.stove(editor, rand, x + 4, y, z - 4);
        this.storage(editor, rand, x + 4, y, z + 4);
        this.northTable(editor, rand, x - 4, y, z - 4);
        this.southTable(editor, rand, x - 4, y, z + 4);
        return true;
    }

    private void stove(WorldEditor editor, Random rand, int x, int y, int z) {
        MetaBlock brick = BlockType.get(BlockType.BRICK);
        MetaStair stair = new MetaStair(StairType.BRICK);
        editor.fillRectSolid(rand, x - 1, y - 1, z - 4, x + 2, y - 1, z + 1, brick);
        editor.fillRectSolid(rand, x - 1, y, z - 4, x + 1, y + 2, z - 3, brick);
        editor.setBlock(rand, x - 1, y, z - 2, stair.setOrientation(Cardinal.EAST, false), true, true);
        editor.setBlock(rand, x - 1, y + 1, z - 2, stair.setOrientation(Cardinal.EAST, true), true, true);
        editor.setBlock(rand, x + 1, y, z - 2, stair.setOrientation(Cardinal.WEST, false), true, true);
        editor.setBlock(rand, x + 1, y + 1, z - 2, stair.setOrientation(Cardinal.WEST, true), true, true);
        editor.fillRectSolid(rand, x - 1, y + 2, z - 2, x + 1, y + 2, z - 2, brick);
        editor.fillRectSolid(rand, x - 1, y + 2, z - 1, x + 2, y + 2, z - 1, stair.setOrientation(Cardinal.SOUTH, true), true, true);
        editor.setBlock(x, y - 1, z - 3, BlockType.get(BlockType.NETHERRACK));
        editor.setBlock(x, y, z - 3, BlockType.get(BlockType.FIRE));
        editor.setBlock(rand, x, y + 1, z - 3, stair.setOrientation(Cardinal.SOUTH, true), true, true);
        editor.fillRectSolid(rand, x + 2, y, z - 1, x + 2, y + 2, z + 1, brick);
        editor.fillRectSolid(rand, x + 1, y + 2, z - 1, x + 1, y + 2, z + 1, stair.setOrientation(Cardinal.WEST, true), true, true);
        Furnace.generate(editor, Cardinal.WEST, new Coord(x + 2, y, z));
        editor.setBlock(rand, x + 2, y + 1, z, stair.setOrientation(Cardinal.WEST, true), true, true);
        editor.fillRectSolid(rand, x - 1, y + 3, z - 1, x + 1, y + 3, z + 1, brick);
    }

    private void northTable(WorldEditor editor, Random rand, int x, int y, int z) {
        editor.fillRectSolid(rand, x - 1, y - 1, z - 1, x + 1, y - 1, z + 1, this.plank, true, true);
        editor.fillRectSolid(rand, x - 1, y, z - 2, x + 1, y, z - 2, this.stair.setOrientation(Cardinal.SOUTH, false), true, true);
        editor.fillRectSolid(rand, x - 2, y, z - 1, x - 2, y, z + 1, this.stair.setOrientation(Cardinal.EAST, false), true, true);
        editor.setBlock(rand, x, y, z, this.stair.setOrientation(Cardinal.NORTH, true), true, true);
        editor.setBlock(rand, x + 1, y, z, this.stair.setOrientation(Cardinal.EAST, true), true, true);
        editor.setBlock(rand, x + 1, y, z + 1, this.stair.setOrientation(Cardinal.SOUTH, true), true, true);
        editor.setBlock(rand, x, y, z + 1, this.stair.setOrientation(Cardinal.WEST, true), true, true);
        Torch.generate(editor, Torch.WOODEN, Cardinal.UP, new Coord(x, y + 1, z));
    }

    private void southTable(WorldEditor editor, Random rand, int x, int y, int z) {
        editor.fillRectSolid(rand, x - 1, y - 1, z - 1, x + 1, y - 1, z + 1, this.plank, true, true);
        editor.fillRectSolid(rand, x - 1, y, z + 2, x + 1, y, z + 2, this.stair.setOrientation(Cardinal.NORTH, false), true, true);
        editor.fillRectSolid(rand, x - 2, y, z - 1, x - 2, y, z + 1, this.stair.setOrientation(Cardinal.EAST, false), true, true);
        editor.setBlock(rand, x, y, z - 1, this.stair.setOrientation(Cardinal.NORTH, true), true, true);
        editor.setBlock(rand, x + 1, y, z - 1, this.stair.setOrientation(Cardinal.EAST, true), true, true);
        editor.setBlock(rand, x + 1, y, z, this.stair.setOrientation(Cardinal.SOUTH, true), true, true);
        editor.setBlock(rand, x, y, z, this.stair.setOrientation(Cardinal.WEST, true), true, true);
        Torch.generate(editor, Torch.WOODEN, Cardinal.UP, new Coord(x, y + 1, z));
    }

    private void storage(WorldEditor editor, Random rand, int x, int y, int z) {
        editor.fillRectSolid(rand, x - 1, y - 1, z - 1, x + 1, y - 1, z + 1, this.plank, true, true);
        editor.setBlock(rand, x + 2, y, z - 1, this.stair.setOrientation(Cardinal.SOUTH, true), true, true);
        editor.setBlock(rand, x + 2, y, z, this.stair.setOrientation(Cardinal.WEST, true), true, true);
        editor.setBlock(rand, x + 2, y, z + 1, this.stair.setOrientation(Cardinal.NORTH, true), true, true);
        editor.setBlock(rand, x - 1, y, z + 2, this.stair.setOrientation(Cardinal.EAST, true), true, true);
        editor.setBlock(rand, x, y, z + 2, this.stair.setOrientation(Cardinal.NORTH, true), true, true);
        editor.setBlock(rand, x + 1, y, z + 2, this.stair.setOrientation(Cardinal.WEST, true), true, true);
    }

    private static void pillar(WorldEditor editor, Random rand, ITheme theme, int x, int y, int z) {
        IStair stair = theme.getSecondaryStair();
        IBlockFactory pillar = theme.getSecondaryPillar();
        IBlockFactory wall = theme.getSecondaryWall();
        editor.fillRectSolid(rand, x, y, z, x, y + 1, z, pillar, true, true);
        editor.setBlock(rand, x, y + 2, z, wall, true, true);
        editor.setBlock(rand, x + 1, y + 2, z, stair.setOrientation(Cardinal.EAST, true), true, true);
        editor.setBlock(rand, x - 1, y + 2, z, stair.setOrientation(Cardinal.WEST, true), true, true);
        editor.setBlock(rand, x, y + 2, z + 1, stair.setOrientation(Cardinal.SOUTH, true), true, true);
        editor.setBlock(rand, x, y + 2, z - 1, stair.setOrientation(Cardinal.NORTH, true), true, true);
        editor.fillRectSolid(rand, x - 1, y + 3, z - 1, x + 1, y + 3, z + 1, wall, true, true);
    }

    @Override
    public int getSize() {
        return 10;
    }
}

