/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.rooms;

import greymerk.roguelike.dungeon.Dungeon;
import greymerk.roguelike.dungeon.base.DungeonBase;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.theme.ITheme;
import greymerk.roguelike.treasure.Treasure;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IBlockFactory;
import greymerk.roguelike.worldgen.IStair;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.Spawner;
import greymerk.roguelike.worldgen.WorldEditor;
import greymerk.roguelike.worldgen.blocks.BlockType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;

public class DungeonsBrick
extends DungeonBase {
    @Override
    public boolean generate(WorldEditor editor, Random rand, LevelSettings settings, Cardinal[] entrances, Coord origin) {
        int x = origin.getX();
        int y = origin.getY();
        int z = origin.getZ();
        ITheme theme = settings.getTheme();
        IStair stair = theme.getPrimaryStair();
        IBlockFactory blocks = theme.getPrimaryWall();
        IBlockFactory pillar = theme.getPrimaryPillar();
        MetaBlock air = BlockType.get(BlockType.AIR);
        editor.fillRectSolid(rand, x - 3, y, z - 3, x + 3, y + 3, z + 3, air);
        editor.fillRectSolid(rand, x - 1, y + 4, z - 1, x + 1, y + 4, z + 1, air);
        editor.fillRectHollow(rand, x - 4, y - 1, z - 4, x + 4, y + 4, z + 4, blocks, false, true);
        editor.fillRectSolid(rand, new Coord(x - 4, y - 1, z - 4), new Coord(x + 4, y - 1, z + 4), theme.getPrimaryFloor(), false, true);
        Coord cursor = new Coord(x, y, z);
        cursor.add(Cardinal.UP, 5);
        air.setBlock(editor, cursor);
        cursor.add(Cardinal.UP, 1);
        editor.setBlock(rand, cursor, blocks, true, true);
        ArrayList<Coord> space = new ArrayList<Coord>();
        for (Cardinal dir : Cardinal.directions) {
            cursor = new Coord(x, y, z);
            cursor.add(dir, 1);
            cursor.add(Cardinal.UP, 5);
            stair.setOrientation(Cardinal.reverse(dir), true);
            editor.setBlock(rand, cursor, stair, false, true);
            cursor.add(Cardinal.getOrthogonal(dir)[0], 1);
            editor.setBlock(rand, cursor, blocks, false, true);
            cursor = new Coord(x, y, z);
            cursor.add(dir, 2);
            cursor.add(Cardinal.UP, 4);
            air.setBlock(editor, cursor);
            cursor.add(Cardinal.UP, 1);
            editor.setBlock(rand, cursor, blocks, false, true);
            cursor = new Coord(x, y, z);
            cursor.add(dir, 3);
            cursor.add(Cardinal.getOrthogonal(dir)[0], 3);
            Coord start = new Coord(cursor);
            cursor.add(Cardinal.UP, 2);
            Coord end = new Coord(cursor);
            editor.fillRectSolid(rand, start, end, pillar, true, true);
            cursor.add(Cardinal.UP, 1);
            editor.setBlock(rand, cursor, blocks, true, true);
            for (Cardinal orth : Cardinal.getOrthogonal(dir)) {
                cursor = new Coord(x, y, z);
                cursor.add(dir, 3);
                cursor.add(orth, 2);
                cursor.add(Cardinal.UP, 3);
                stair.setOrientation(Cardinal.reverse(orth), true);
                editor.setBlock(rand, cursor, stair, true, true);
            }
            cursor = new Coord(x, y, z);
            cursor.add(dir, 2);
            cursor.add(Cardinal.getOrthogonal(dir)[0], 2);
            cursor.add(Cardinal.UP, 4);
            editor.setBlock(rand, cursor, blocks, false, true);
            for (Cardinal orth : Cardinal.getOrthogonal(dir)) {
                cursor = new Coord(x, y, z);
                cursor.add(Cardinal.UP, 4);
                cursor.add(dir, 2);
                cursor.add(orth, 1);
                stair.setOrientation(Cardinal.reverse(orth), true);
                editor.setBlock(rand, cursor, stair, false, true);
            }
            cursor = new Coord(x, y, z);
            cursor.add(dir, 1);
            cursor.add(Cardinal.getOrthogonal(dir)[0], 1);
            cursor.add(Cardinal.UP, 5);
            editor.setBlock(rand, cursor, blocks, false, true);
            for (Cardinal orth : Cardinal.getOrthogonal(dir)) {
                cursor = new Coord(x, y, z);
                cursor.add(dir, 3);
                cursor.add(orth, 2);
                space.add(cursor);
            }
        }
        ArrayList<Treasure> types = new ArrayList<Treasure>(Arrays.asList(Treasure.ARMOUR, Treasure.WEAPONS, Treasure.TOOLS));
        Treasure.createChests(editor, rand, 1, space, types, Dungeon.getLevel(origin.getY()));
        Spawner.generate(editor, rand, settings, new Coord(x, y, z));
        return true;
    }

    public boolean isValidDungeonLocation(WorldEditor editor, int x, int y, int z) {
        return false;
    }

    @Override
    public int getSize() {
        return 6;
    }
}

