/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.rooms;

import greymerk.roguelike.dungeon.base.DungeonBase;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.theme.ITheme;
import greymerk.roguelike.treasure.Treasure;
import greymerk.roguelike.worldgen.BlockWeightedRandom;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.Spawner;
import greymerk.roguelike.worldgen.WorldEditor;
import greymerk.roguelike.worldgen.blocks.BlockType;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class DungeonsCreeperDen
extends DungeonBase {
    @Override
    public boolean generate(WorldEditor editor, Random rand, LevelSettings settings, Cardinal[] entrances, Coord origin) {
        ITheme theme = settings.getTheme();
        MetaBlock tnt = BlockType.get(BlockType.TNT);
        BlockWeightedRandom mossy = new BlockWeightedRandom();
        mossy.addBlock(theme.getPrimaryWall(), 3);
        mossy.addBlock(BlockType.get(BlockType.COBBLESTONE_MOSSY), 1);
        BlockWeightedRandom floor = new BlockWeightedRandom();
        floor.addBlock(theme.getPrimaryFloor(), 1);
        mossy.addBlock(BlockType.get(BlockType.COBBLESTONE_MOSSY), 1);
        floor.addBlock(BlockType.get(BlockType.GRAVEL), 3);
        BlockWeightedRandom subfloor = new BlockWeightedRandom();
        subfloor.addBlock(floor, 3);
        subfloor.addBlock(tnt, 1);
        Coord start = new Coord(origin);
        Coord end = new Coord(origin);
        start.add(new Coord(-4, -4, -4));
        end.add(new Coord(4, 5, 4));
        mossy.fillRectHollow(editor, rand, start, end, false, true);
        start = new Coord(origin);
        end = new Coord(origin);
        start.add(new Coord(-3, -1, -3));
        end.add(new Coord(3, -1, 3));
        floor.fillRectSolid(editor, rand, start, end, true, true);
        start = new Coord(origin);
        end = new Coord(origin);
        start.add(new Coord(-3, -3, -3));
        end.add(new Coord(3, -2, 3));
        subfloor.fillRectSolid(editor, rand, start, end, true, true);
        start = new Coord(origin);
        end = new Coord(origin);
        start.add(new Coord(-3, 0, -3));
        end.add(new Coord(3, 0, 3));
        List<Coord> chestSpaces = WorldEditor.getRectSolid(start, end);
        Collections.shuffle(chestSpaces, rand);
        int counter = 0;
        for (Coord spot : chestSpaces) {
            if (Treasure.isValidChestSpace(editor, spot)) {
                Treasure.generate(editor, rand, spot, Treasure.ORE, settings.getDifficulty(spot), true);
                Coord cursor = new Coord(spot);
                cursor.add(Cardinal.DOWN, 2);
                tnt.setBlock(editor, cursor);
                ++counter;
            }
            if (counter < 2) continue;
            break;
        }
        Spawner.generate(editor, rand, settings, new Coord(origin), Spawner.CREEPER);
        return true;
    }

    @Override
    public int getSize() {
        return 7;
    }
}

