/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.rooms;

import greymerk.roguelike.dungeon.Dungeon;
import greymerk.roguelike.dungeon.base.DungeonBase;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.theme.ITheme;
import greymerk.roguelike.treasure.Treasure;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IBlockFactory;
import greymerk.roguelike.worldgen.IStair;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.Spawner;
import greymerk.roguelike.worldgen.WorldEditor;
import greymerk.roguelike.worldgen.blocks.BlockType;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class DungeonsCrypt
extends DungeonBase {
    @Override
    public boolean generate(WorldEditor editor, Random rand, LevelSettings settings, Cardinal[] entrances, Coord origin) {
        ITheme theme = settings.getTheme();
        MetaBlock air = BlockType.get(BlockType.AIR);
        IStair stair = theme.getPrimaryStair();
        IBlockFactory walls = theme.getPrimaryWall();
        IBlockFactory floor = theme.getPrimaryFloor();
        Coord start = new Coord(origin);
        Coord end = new Coord(origin);
        start.add(-3, 0, -3);
        end.add(3, 4, 3);
        air.fillRectSolid(editor, rand, start, end, true, true);
        start = new Coord(origin);
        end = new Coord(origin);
        start.add(-9, -1, -9);
        end.add(9, -1, 9);
        floor.fillRectSolid(editor, rand, start, end, true, true);
        start = new Coord(origin);
        end = new Coord(origin);
        start.add(-9, 5, -9);
        end.add(9, 6, 9);
        walls.fillRectSolid(editor, rand, start, end, false, true);
        for (Cardinal dir : Cardinal.directions) {
            Coord cursor;
            Cardinal[] orth = Cardinal.getOrthogonal(dir);
            List<Cardinal> doorways = Arrays.asList(entrances);
            if (doorways.contains((Object)dir) && doorways.contains((Object)orth[0])) {
                start = new Coord(origin);
                end = new Coord(origin);
                start.add(dir, 3);
                end.add(orth[0], 5);
                end.add(dir, 5);
                end.add(Cardinal.UP, 4);
                air.fillRectSolid(editor, rand, start, end, true, true);
            }
            if (doorways.contains((Object)dir)) {
                start = new Coord(origin);
                end = new Coord(origin);
                start.add(dir, 3);
                start.add(orth[0], 2);
                end.add(dir, 8);
                end.add(orth[1], 2);
                end.add(Cardinal.UP, 4);
                air.fillRectSolid(editor, rand, start, end, true, true);
                for (Cardinal o : orth) {
                    if (doorways.contains((Object)o)) {
                        cursor = new Coord(origin);
                        cursor.add(dir, 7);
                        cursor.add(o, 3);
                        cursor.add(Cardinal.UP);
                        this.crypt(editor, rand, settings, cursor, o);
                        continue;
                    }
                    start = new Coord(origin);
                    end = new Coord(origin);
                    start.add(dir, 4);
                    start.add(o, 3);
                    end.add(dir, 8);
                    end.add(o, 8);
                    end.add(Cardinal.UP, 4);
                    air.fillRectSolid(editor, rand, start, end, true, true);
                    cursor = new Coord(origin);
                    cursor.add(dir, 6);
                    cursor.add(o, 3);
                    cursor.add(Cardinal.UP);
                    this.sarcophagus(editor, rand, settings, cursor, o);
                }
            } else {
                cursor = new Coord(origin);
                cursor.add(dir, 4);
                this.mausoleumWall(editor, rand, settings, cursor, dir);
            }
            cursor = new Coord(origin);
            cursor.add(dir, 3);
            cursor.add(orth[0], 3);
            this.pillar(editor, rand, settings, cursor);
            start = new Coord(origin);
            start.add(dir, 8);
            start.add(Cardinal.UP, 4);
            end = new Coord(start);
            start.add(orth[0], 2);
            end.add(orth[1], 2);
            stair.setOrientation(Cardinal.reverse(dir), true);
            stair.fillRectSolid(editor, rand, start, end, true, false);
        }
        return true;
    }

    private void sarcophagus(WorldEditor editor, Random rand, LevelSettings settings, Coord origin, Cardinal dir) {
        ITheme theme = settings.getTheme();
        IBlockFactory walls = theme.getPrimaryWall();
        IStair stair = theme.getPrimaryStair();
        Cardinal[] orth = Cardinal.getOrthogonal(dir);
        Coord start = new Coord(origin);
        start.add(Cardinal.DOWN);
        start.add(dir, 5);
        Coord end = new Coord(start);
        start.add(orth[0], 2);
        end.add(orth[1], 2);
        walls.fillRectSolid(editor, rand, start, end, true, true);
        Coord cursor = new Coord(origin);
        cursor.add(dir, 5);
        cursor.add(Cardinal.UP, 3);
        stair.setOrientation(Cardinal.reverse(dir), true).setBlock(editor, cursor);
        start = new Coord(origin);
        for (Cardinal o : Cardinal.getOrthogonal(dir)) {
            start = new Coord(origin);
            start.add(Cardinal.DOWN);
            start.add(dir);
            start.add(o, 3);
            end = new Coord(start);
            end.add(dir, 4);
            end.add(Cardinal.UP, 4);
            walls.fillRectSolid(editor, rand, start, end, true, true);
            cursor = new Coord(origin);
            cursor.add(Cardinal.DOWN);
            cursor.add(dir, 5);
            cursor.add(o, 2);
            this.pillar(editor, rand, settings, cursor);
            start = new Coord(origin);
            start.add(Cardinal.UP, 3);
            start.add(o, 2);
            end = new Coord(start);
            end.add(dir, 3);
            stair.setOrientation(Cardinal.reverse(o), true);
            stair.fillRectSolid(editor, rand, start, end, true, true);
        }
        cursor = new Coord(origin);
        this.tomb(editor, rand, settings, cursor, dir);
        cursor.add(Cardinal.UP);
        stair.setOrientation(Cardinal.reverse(dir), false).setBlock(editor, cursor);
        cursor.add(Cardinal.DOWN, 2);
        stair.setOrientation(Cardinal.reverse(dir), true).setBlock(editor, cursor);
        cursor.add(dir);
        walls.setBlock(editor, rand, cursor);
        cursor.add(dir);
        walls.setBlock(editor, rand, cursor);
        cursor.add(dir);
        stair.setOrientation(dir, false).setBlock(editor, cursor);
        cursor.add(Cardinal.UP);
        stair.setOrientation(dir, true).setBlock(editor, cursor);
        cursor.add(Cardinal.UP);
        stair.setOrientation(dir, false).setBlock(editor, cursor);
        for (Cardinal o : Cardinal.getOrthogonal(dir)) {
            cursor = new Coord(origin);
            cursor.add(Cardinal.DOWN);
            cursor.add(o);
            start = new Coord(cursor);
            end = new Coord(cursor);
            end.add(dir, 3);
            stair.setOrientation(o, false);
            stair.fillRectSolid(editor, rand, start, end, true, true);
            start.add(Cardinal.UP);
            end.add(Cardinal.UP);
            stair.setOrientation(o, true);
            stair.fillRectSolid(editor, rand, start, end, true, true);
            start.add(Cardinal.UP);
            end.add(Cardinal.UP);
            stair.setOrientation(o, false);
            stair.fillRectSolid(editor, rand, start, end, true, true);
        }
    }

    private void crypt(WorldEditor editor, Random rand, LevelSettings settings, Coord origin, Cardinal dir) {
        ITheme theme = settings.getTheme();
        IBlockFactory walls = theme.getPrimaryWall();
        IStair stair = theme.getPrimaryStair();
        Cardinal[] orth = Cardinal.getOrthogonal(dir);
        Coord start = new Coord(origin);
        start.add(Cardinal.DOWN);
        start.add(orth[0]);
        Coord end = new Coord(origin);
        end.add(Cardinal.UP, 3);
        end.add(orth[1]);
        end.add(dir, 3);
        walls.fillRectSolid(editor, rand, start, end, true, true);
        Coord cursor = new Coord(origin);
        cursor.add(Cardinal.reverse(dir));
        cursor.add(Cardinal.UP, 2);
        stair.setOrientation(Cardinal.reverse(dir), true).setBlock(editor, cursor);
        cursor.add(Cardinal.UP);
        walls.setBlock(editor, rand, cursor);
        for (Cardinal o : orth) {
            cursor = new Coord(origin);
            cursor.add(Cardinal.reverse(dir));
            cursor.add(Cardinal.UP);
            cursor.add(o);
            stair.setOrientation(Cardinal.reverse(dir), true).setBlock(editor, cursor);
            cursor.add(Cardinal.UP);
            walls.setBlock(editor, rand, cursor);
            cursor.add(Cardinal.UP);
            walls.setBlock(editor, rand, cursor);
            start = new Coord(origin);
            start.add(Cardinal.UP, 3);
            start.add(Cardinal.reverse(dir), 2);
            start.add(o, 2);
            end = new Coord(start);
            end.add(dir, 7);
            stair.setOrientation(o, true);
            stair.fillRectSolid(editor, rand, start, end, true, false);
        }
        start = new Coord(origin);
        start.add(Cardinal.UP, 3);
        start.add(Cardinal.reverse(dir), 2);
        end = new Coord(start);
        start.add(orth[0]);
        end.add(orth[1]);
        stair.setOrientation(Cardinal.reverse(dir), true);
        stair.fillRectSolid(editor, rand, start, end, true, true);
        this.tomb(editor, rand, settings, origin, dir);
    }

    private void mausoleumWall(WorldEditor editor, Random rand, LevelSettings settings, Coord origin, Cardinal dir) {
        ITheme theme = settings.getTheme();
        IBlockFactory walls = theme.getPrimaryWall();
        Cardinal[] orth = Cardinal.getOrthogonal(dir);
        Coord start = new Coord(origin);
        Coord end = new Coord(origin);
        start.add(orth[0], 3);
        end.add(orth[1], 3);
        end.add(dir, 4);
        end.add(Cardinal.UP, 4);
        walls.fillRectSolid(editor, rand, start, end, true, true);
        Coord cursor = new Coord(origin);
        cursor.add(Cardinal.UP);
        this.tomb(editor, rand, settings, cursor, dir);
        cursor.add(Cardinal.UP, 2);
        this.tomb(editor, rand, settings, cursor, dir);
        for (Cardinal o : orth) {
            cursor = new Coord(origin);
            cursor.add(Cardinal.UP);
            cursor.add(o, 2);
            this.tomb(editor, rand, settings, cursor, dir);
            cursor.add(Cardinal.UP, 2);
            this.tomb(editor, rand, settings, cursor, dir);
        }
    }

    private void pillar(WorldEditor editor, Random rand, LevelSettings settings, Coord origin) {
        ITheme theme = settings.getTheme();
        IBlockFactory walls = theme.getPrimaryWall();
        IStair stair = theme.getPrimaryStair();
        Coord start = new Coord(origin);
        Coord end = new Coord(origin);
        end.add(Cardinal.UP, 4);
        walls.fillRectSolid(editor, rand, start, end, true, true);
        for (Cardinal dir : Cardinal.directions) {
            Coord cursor = new Coord(end);
            cursor.add(dir);
            stair.setOrientation(dir, true);
            stair.setBlock(editor, rand, cursor, true, false);
        }
    }

    private void tomb(WorldEditor editor, Random rand, LevelSettings settings, Coord origin, Cardinal dir) {
        ITheme theme = settings.getTheme();
        IStair stair = theme.getPrimaryStair();
        MetaBlock tombStone = BlockType.get(BlockType.QUARTZ);
        MetaBlock air = BlockType.get(BlockType.AIR);
        Coord cursor = new Coord(origin);
        cursor.add(dir, 2);
        cursor.add(Cardinal.UP);
        stair.setOrientation(Cardinal.reverse(dir), true).setBlock(editor, cursor);
        cursor.add(Cardinal.reverse(dir));
        stair.setOrientation(dir, true).setBlock(editor, cursor);
        cursor = new Coord(origin);
        cursor.add(dir, 2);
        air.fillRectSolid(editor, rand, origin, cursor, true, true);
        if (rand.nextInt(3) == 0) {
            return;
        }
        cursor = new Coord(origin);
        tombStone.setBlock(editor, cursor);
        if (rand.nextInt(4) != 0) {
            return;
        }
        cursor.add(dir);
        Spawner spawnerType = rand.nextBoolean() ? Spawner.SKELETON : Spawner.ZOMBIE;
        Spawner.generate(editor, rand, settings, cursor, spawnerType);
        cursor.add(dir);
        Treasure[] types = new Treasure[]{Treasure.ARMOUR, Treasure.WEAPONS};
        Treasure chestType = types[rand.nextInt(types.length)];
        Treasure.generate(editor, rand, cursor, chestType, Dungeon.getLevel(cursor.getY()), false);
    }

    @Override
    public int getSize() {
        return 10;
    }
}

