/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.rooms;

import greymerk.roguelike.dungeon.base.DungeonBase;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.theme.ITheme;
import greymerk.roguelike.treasure.Treasure;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IBlockFactory;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.WorldEditor;
import greymerk.roguelike.worldgen.blocks.BlockType;
import greymerk.roguelike.worldgen.blocks.ColorBlock;
import greymerk.roguelike.worldgen.blocks.Wood;
import greymerk.roguelike.worldgen.blocks.WoodBlock;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;

public class DungeonsMusic
extends DungeonBase {
    WorldEditor editor;
    Random rand;
    int originX;
    int originY;
    int originZ;

    @Override
    public boolean generate(WorldEditor editor, Random inRandom, LevelSettings settings, Cardinal[] entrances, Coord origin) {
        ITheme theme = settings.getTheme();
        this.editor = editor;
        this.rand = inRandom;
        this.originX = origin.getX();
        this.originY = origin.getY();
        this.originZ = origin.getZ();
        MetaBlock air = BlockType.get(BlockType.AIR);
        IBlockFactory wall = theme.getPrimaryWall();
        IBlockFactory deco = theme.getSecondaryWall();
        MetaBlock rug1 = ColorBlock.get(ColorBlock.CARPET, this.rand);
        MetaBlock rug2 = ColorBlock.get(ColorBlock.CARPET, this.rand);
        MetaBlock rug3 = ColorBlock.get(ColorBlock.CARPET, this.rand);
        editor.fillRectSolid(inRandom, this.originX - 5, this.originY, this.originZ - 5, this.originX + 5, this.originY + 3, this.originZ + 5, air);
        editor.fillRectHollow(this.rand, new Coord(this.originX - 6, this.originY - 2, this.originZ - 6), new Coord(this.originX + 6, this.originY + 5, this.originZ + 6), wall, false, true);
        editor.fillRectSolid(this.rand, this.originX - 5, this.originY - 1, this.originZ - 5, this.originX + 5, this.originY - 1, this.originZ + 5, deco, true, true);
        editor.fillRectSolid(this.rand, this.originX - 3, this.originY, this.originZ - 3, this.originX + 3, this.originY, this.originZ + 3, rug1, true, true);
        editor.fillRectSolid(this.rand, this.originX - 2, this.originY, this.originZ - 2, this.originX + 2, this.originY, this.originZ + 2, rug2, true, true);
        editor.fillRectSolid(this.rand, this.originX - 1, this.originY, this.originZ - 1, this.originX + 1, this.originY, this.originZ + 1, rug3, true, true);
        MetaBlock log = Wood.get(WoodBlock.LOG);
        editor.fillRectSolid(inRandom, this.originX - 2, this.originY, this.originZ - 5, this.originX - 2, this.originY + 2, this.originZ - 5, log, true, true);
        editor.fillRectSolid(inRandom, this.originX + 2, this.originY, this.originZ - 5, this.originX + 2, this.originY + 2, this.originZ - 5, log, true, true);
        editor.fillRectSolid(inRandom, this.originX - 2, this.originY, this.originZ + 5, this.originX - 2, this.originY + 2, this.originZ + 5, log, true, true);
        editor.fillRectSolid(inRandom, this.originX + 2, this.originY, this.originZ + 5, this.originX + 2, this.originY + 2, this.originZ + 5, log, true, true);
        editor.fillRectSolid(this.rand, this.originX - 5, this.originY, this.originZ - 2, this.originX - 5, this.originY + 2, this.originZ - 2, log, true, true);
        editor.fillRectSolid(this.rand, this.originX - 5, this.originY, this.originZ + 2, this.originX - 5, this.originY + 2, this.originZ + 2, log, true, true);
        editor.fillRectSolid(this.rand, this.originX + 5, this.originY, this.originZ - 2, this.originX + 5, this.originY + 2, this.originZ - 2, log, true, true);
        editor.fillRectSolid(this.rand, this.originX + 5, this.originY, this.originZ + 2, this.originX + 5, this.originY + 2, this.originZ + 2, log, true, true);
        editor.fillRectSolid(this.rand, this.originX - 5, this.originY, this.originZ - 5, this.originX - 5, this.originY + 2, this.originZ - 5, log, true, true);
        editor.fillRectSolid(this.rand, this.originX - 5, this.originY, this.originZ + 5, this.originX - 5, this.originY + 2, this.originZ + 5, log, true, true);
        editor.fillRectSolid(this.rand, this.originX + 5, this.originY, this.originZ - 5, this.originX + 5, this.originY + 2, this.originZ - 5, log, true, true);
        editor.fillRectSolid(this.rand, this.originX + 5, this.originY, this.originZ + 5, this.originX + 5, this.originY + 2, this.originZ + 5, log, true, true);
        editor.fillRectSolid(this.rand, this.originX - 4, this.originY, this.originZ - 5, this.originX - 3, this.originY, this.originZ - 5, deco, true, true);
        editor.fillRectSolid(this.rand, this.originX + 3, this.originY, this.originZ - 5, this.originX + 4, this.originY, this.originZ - 5, deco, true, true);
        editor.fillRectSolid(this.rand, this.originX - 4, this.originY, this.originZ + 5, this.originX - 3, this.originY, this.originZ + 5, deco, true, true);
        editor.fillRectSolid(this.rand, this.originX + 3, this.originY, this.originZ + 5, this.originX + 4, this.originY, this.originZ + 5, deco, true, true);
        editor.fillRectSolid(this.rand, this.originX - 5, this.originY, this.originZ - 4, this.originX - 5, this.originY, this.originZ - 3, deco, true, true);
        editor.fillRectSolid(this.rand, this.originX - 5, this.originY, this.originZ + 3, this.originX - 5, this.originY, this.originZ + 4, deco, true, true);
        editor.fillRectSolid(this.rand, this.originX + 5, this.originY, this.originZ - 4, this.originX + 5, this.originY, this.originZ - 3, deco, true, true);
        editor.fillRectSolid(this.rand, this.originX + 5, this.originY, this.originZ + 3, this.originX + 5, this.originY, this.originZ + 4, deco, true, true);
        HashSet<Coord> chestSpace = new HashSet<Coord>();
        chestSpace.addAll(WorldEditor.getRectSolid(this.originX - 4, this.originY + 1, this.originZ - 5, this.originX - 3, this.originY + 1, this.originZ - 5));
        chestSpace.addAll(WorldEditor.getRectSolid(this.originX + 3, this.originY + 1, this.originZ - 5, this.originX + 4, this.originY + 1, this.originZ - 5));
        chestSpace.addAll(WorldEditor.getRectSolid(this.originX - 4, this.originY + 1, this.originZ + 5, this.originX - 3, this.originY + 1, this.originZ + 5));
        chestSpace.addAll(WorldEditor.getRectSolid(this.originX + 3, this.originY + 1, this.originZ + 5, this.originX + 4, this.originY + 1, this.originZ + 5));
        chestSpace.addAll(WorldEditor.getRectSolid(this.originX - 5, this.originY + 1, this.originZ - 4, this.originX - 5, this.originY + 1, this.originZ - 3));
        chestSpace.addAll(WorldEditor.getRectSolid(this.originX - 5, this.originY + 1, this.originZ + 3, this.originX - 5, this.originY + 1, this.originZ + 4));
        chestSpace.addAll(WorldEditor.getRectSolid(this.originX + 5, this.originY + 1, this.originZ - 4, this.originX + 5, this.originY + 1, this.originZ - 3));
        chestSpace.addAll(WorldEditor.getRectSolid(this.originX + 5, this.originY + 1, this.originZ + 3, this.originX + 5, this.originY + 1, this.originZ + 4));
        ArrayList<Coord> spaces = new ArrayList<Coord>();
        spaces.addAll(chestSpace);
        Treasure.generate(editor, this.rand, (Coord)spaces.remove(0), Treasure.MUSIC, settings.getDifficulty(origin), false);
        Treasure.generate(editor, this.rand, (Coord)spaces.remove(0), Treasure.SUPPLIES, settings.getDifficulty(origin), false);
        editor.fillRectSolid(this.rand, this.originX - 5, this.originY + 3, this.originZ - 5, this.originX - 5, this.originY + 3, this.originZ + 5, log, true, true);
        editor.fillRectSolid(this.rand, this.originX - 5, this.originY + 3, this.originZ - 5, this.originX + 5, this.originY + 3, this.originZ - 5, log, true, true);
        editor.fillRectSolid(this.rand, this.originX - 5, this.originY + 3, this.originZ + 5, this.originX + 5, this.originY + 3, this.originZ + 5, log, true, true);
        editor.fillRectSolid(this.rand, this.originX + 5, this.originY + 3, this.originZ - 5, this.originX + 5, this.originY + 3, this.originZ + 5, log, true, true);
        editor.fillRectSolid(this.rand, this.originX - 2, this.originY + 4, this.originZ - 5, this.originX - 2, this.originY + 4, this.originZ + 5, log, true, true);
        editor.fillRectSolid(this.rand, this.originX + 2, this.originY + 4, this.originZ - 5, this.originX + 2, this.originY + 4, this.originZ + 5, log, true, true);
        editor.fillRectSolid(this.rand, this.originX - 5, this.originY + 4, this.originZ - 2, this.originX + 5, this.originY + 4, this.originZ - 2, log, true, true);
        editor.fillRectSolid(this.rand, this.originX - 5, this.originY + 4, this.originZ + 2, this.originX + 5, this.originY + 4, this.originZ + 2, log, true, true);
        editor.setBlock(this.originX, this.originY + 4, this.originZ, BlockType.get(BlockType.REDSTONE_BLOCK));
        editor.setBlock(this.originX - 1, this.originY + 4, this.originZ, BlockType.get(BlockType.REDSTONE_LAMP_LIT));
        editor.setBlock(this.originX + 1, this.originY + 4, this.originZ, BlockType.get(BlockType.REDSTONE_LAMP_LIT));
        editor.setBlock(this.originX, this.originY + 4, this.originZ - 1, BlockType.get(BlockType.REDSTONE_LAMP_LIT));
        editor.setBlock(this.originX, this.originY + 4, this.originZ + 1, BlockType.get(BlockType.REDSTONE_LAMP_LIT));
        editor.fillRectSolid(this.rand, this.originX - 5, this.originY + 4, this.originZ - 5, this.originX + 5, this.originY + 4, this.originZ + 5, deco, true, false);
        editor.setBlock(this.originX, this.originY, this.originZ, BlockType.get(BlockType.JUKEBOX));
        return true;
    }

    public boolean isValidDungeonLocation(WorldEditor editor, int originX, int originY, int originZ) {
        return false;
    }

    @Override
    public int getSize() {
        return 7;
    }
}

