/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.rooms;

import greymerk.roguelike.dungeon.Dungeon;
import greymerk.roguelike.dungeon.base.DungeonBase;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.treasure.Treasure;
import greymerk.roguelike.worldgen.BlockJumble;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.Spawner;
import greymerk.roguelike.worldgen.WorldEditor;
import greymerk.roguelike.worldgen.blocks.BlockType;
import greymerk.roguelike.worldgen.blocks.Crops;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class DungeonsNetherBrickFortress
extends DungeonBase {
    WorldEditor editor;
    Random rand;
    int originX;
    int originY;
    int originZ;
    Spawner spawner;

    @Override
    public boolean generate(WorldEditor editor, Random inRandom, LevelSettings settings, Cardinal[] entrances, Coord origin) {
        this.editor = editor;
        this.rand = inRandom;
        this.originX = origin.getX();
        this.originY = origin.getY();
        this.originZ = origin.getZ();
        MetaBlock air = BlockType.get(BlockType.AIR);
        editor.fillRectSolid(this.rand, this.originX - 5, this.originY, this.originZ - 5, this.originX + 5, this.originY + 3, this.originZ + 5, air);
        this.buildWalls(settings);
        this.buildFloor();
        this.buildRoof();
        ArrayList<Treasure> types = new ArrayList<Treasure>(Arrays.asList(Treasure.WEAPONS));
        Treasure.createChests(editor, this.rand, 2, WorldEditor.getRectSolid(this.originX - 6, this.originY, this.originZ - 6, this.originX + 6, this.originY, this.originZ + 6), types, Dungeon.getLevel(this.originY));
        return true;
    }

    public boolean isValidDungeonLocation(WorldEditor editor, int originX, int originY, int originZ) {
        return false;
    }

    protected void buildRoof() {
        MetaBlock air = BlockType.get(BlockType.AIR);
        this.editor.fillRectSolid(this.rand, this.originX - 6, this.originY + 4, this.originZ - 6, this.originX + 6, this.originY + 6, this.originZ + 6, BlockType.get(BlockType.NETHERBRICK));
        List<Coord> lavaArea = WorldEditor.getRectSolid(this.originX - 3, this.originY + 6, this.originZ - 3, this.originX + 3, this.originY + 6, this.originZ + 3);
        for (Coord block : lavaArea) {
            int x = block.getX();
            int y = block.getY();
            int z = block.getZ();
            if (!this.rand.nextBoolean()) continue;
            this.editor.setBlock(x, y, z, BlockType.get(BlockType.LAVA_FLOWING));
        }
        this.editor.fillRectSolid(this.rand, this.originX - 3, this.originY + 4, this.originZ - 3, this.originX + 3, this.originY + 4, this.originZ + 3, air);
        BlockJumble fenceRandom = new BlockJumble();
        fenceRandom.addBlock(BlockType.get(BlockType.NETHERBRICK));
        fenceRandom.addBlock(BlockType.get(BlockType.FENCE_NETHER_BRICK));
        this.editor.fillRectSolid(this.rand, this.originX - 5, this.originY + 4, this.originZ - 3, this.originX - 4, this.originY + 4, this.originZ + 3, fenceRandom);
        this.editor.fillRectSolid(this.rand, this.originX + 4, this.originY + 4, this.originZ - 3, this.originX + 5, this.originY + 4, this.originZ + 3, fenceRandom);
        this.editor.fillRectSolid(this.rand, this.originX - 3, this.originY + 4, this.originZ - 5, this.originX + 3, this.originY + 4, this.originZ - 4, fenceRandom);
        this.editor.fillRectSolid(this.rand, this.originX - 3, this.originY + 4, this.originZ + 4, this.originX + 3, this.originY + 4, this.originZ + 5, fenceRandom);
    }

    protected void buildWalls(LevelSettings settings) {
        List<Coord> outerWall = this.editor.getRectHollow(this.originX - 6, this.originY - 1, this.originZ - 6, this.originX + 6, this.originY + 5, this.originZ + 6);
        for (Coord block : outerWall) {
            int x = block.getX();
            int y = block.getY();
            int z = block.getZ();
            if (y < this.originY || y > this.originY + 4) continue;
            this.editor.setBlock(this.rand, x, y, z, BlockType.get(BlockType.NETHERBRICK), false, true);
        }
        List<Coord> arch1 = WorldEditor.getRectSolid(this.originX - 5, this.originY, this.originZ - 5, this.originX - 4, this.originY + 4, this.originZ - 4);
        List<Coord> arch2 = WorldEditor.getRectSolid(this.originX - 5, this.originY, this.originZ + 4, this.originX - 4, this.originY + 4, this.originZ + 5);
        List<Coord> arch3 = WorldEditor.getRectSolid(this.originX + 4, this.originY, this.originZ - 5, this.originX + 5, this.originY + 4, this.originZ - 4);
        List<Coord> arch4 = WorldEditor.getRectSolid(this.originX + 4, this.originY, this.originZ + 4, this.originX + 5, this.originY + 4, this.originZ + 5);
        ArrayList<Coord> pillars = new ArrayList<Coord>();
        pillars.addAll(arch1);
        pillars.addAll(arch2);
        pillars.addAll(arch3);
        pillars.addAll(arch4);
        Collections.shuffle(pillars, this.rand);
        for (Coord block : pillars) {
            int x = block.getX();
            int y = block.getY();
            int z = block.getZ();
            this.editor.setBlock(x, y, z, BlockType.get(BlockType.NETHERBRICK));
        }
        for (int i = 0; i < this.rand.nextInt(5) + 5; ++i) {
            Spawner toSpawn = this.pickMobSpawner(this.rand);
            Spawner.generate(this.editor, this.rand, settings, (Coord)pillars.get(i), toSpawn);
        }
    }

    protected void buildFloor() {
        this.editor.fillRectSolid(this.rand, this.originX - 6, this.originY - 4, this.originZ - 6, this.originX + 6, this.originY - 1, this.originZ + 6, BlockType.get(BlockType.NETHERBRICK));
        List<Coord> soulSand = WorldEditor.getRectSolid(this.originX - 5, this.originY - 1, this.originZ - 5, this.originX + 5, this.originY - 1, this.originZ + 5);
        MetaBlock sand = BlockType.get(BlockType.SOUL_SAND);
        MetaBlock wart = Crops.get(Crops.NETHERWART);
        for (Coord block : soulSand) {
            int x = block.getX();
            int y = block.getY();
            int z = block.getZ();
            if (!this.rand.nextBoolean() || !this.editor.isAirBlock(new Coord(x, y + 1, z))) continue;
            this.editor.setBlock(x, y, z, sand);
            if (!this.rand.nextBoolean()) continue;
            this.editor.setBlock(x, y + 1, z, wart);
        }
    }

    protected Spawner pickMobSpawner(Random random) {
        if (this.rand.nextInt(10) == 0) {
            return Spawner.CAVESPIDER;
        }
        if (this.rand.nextInt(5) == 0) {
            return Spawner.CREEPER;
        }
        int choice = random.nextInt(3);
        switch (choice) {
            case 0: {
                return Spawner.SKELETON;
            }
            case 1: {
                return Spawner.BLAZE;
            }
            case 2: {
                return Spawner.ZOMBIE;
            }
        }
        return Spawner.ZOMBIE;
    }

    @Override
    public int getSize() {
        return 8;
    }
}

