/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.rooms;

import greymerk.roguelike.dungeon.Dungeon;
import greymerk.roguelike.dungeon.base.DungeonBase;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.theme.ITheme;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IBlockFactory;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.Spawner;
import greymerk.roguelike.worldgen.WorldEditor;
import greymerk.roguelike.worldgen.blocks.BlockType;
import java.util.Random;

public class DungeonsSlime
extends DungeonBase {
    WorldEditor editor;
    Random rand;
    int originX;
    int originY;
    int originZ;
    IBlockFactory fillBlocks;
    MetaBlock liquid;

    @Override
    public boolean generate(WorldEditor editor, Random inRandom, LevelSettings settings, Cardinal[] entrances, Coord origin) {
        ITheme theme = settings.getTheme();
        this.editor = editor;
        this.rand = inRandom;
        this.originX = origin.getX();
        this.originY = origin.getY();
        this.originZ = origin.getZ();
        this.liquid = Dungeon.getLevel(this.originY) == 4 ? BlockType.get(BlockType.LAVA_FLOWING) : BlockType.get(BlockType.WATER_FLOWING);
        this.fillBlocks = theme.getPrimaryWall();
        MetaBlock air = BlockType.get(BlockType.AIR);
        editor.fillRectSolid(this.rand, this.originX - 6, this.originY, this.originZ - 6, this.originX + 6, this.originY + 3, this.originZ + 6, air);
        editor.fillRectHollow(this.rand, this.originX - 7, this.originY - 2, this.originZ - 7, this.originX + 7, this.originY + 4, this.originZ + 7, this.fillBlocks, false, true);
        editor.fillRectSolid(this.rand, this.originX - 7, this.originY - 2, this.originZ - 7, this.originX + 7, this.originY - 1, this.originZ + 7, this.fillBlocks);
        this.pool(this.originX - 4, this.originZ - 4);
        this.pool(this.originX - 4, this.originZ + 4);
        this.pool(this.originX + 4, this.originZ - 4);
        this.pool(this.originX + 4, this.originZ + 4);
        editor.fillRectSolid(this.rand, this.originX - 1, this.originY + 3, this.originZ - 2, this.originX + 1, this.originY + 3, this.originZ - 2, this.fillBlocks);
        editor.fillRectSolid(this.rand, this.originX - 1, this.originY + 3, this.originZ + 2, this.originX + 1, this.originY + 3, this.originZ + 2, this.fillBlocks);
        editor.fillRectSolid(this.rand, this.originX - 2, this.originY + 3, this.originZ - 1, this.originX - 2, this.originY + 3, this.originZ + 1, this.fillBlocks);
        editor.fillRectSolid(this.rand, this.originX + 2, this.originY + 3, this.originZ - 1, this.originX + 2, this.originY + 3, this.originZ + 1, this.fillBlocks);
        if (Dungeon.getLevel(this.originY) == 4) {
            Spawner.generate(editor, this.rand, settings, new Coord(this.originX, this.originY + 5, this.originZ), Spawner.LAVASLIME);
        }
        return true;
    }

    private void pool(int inX, int inZ) {
        this.editor.fillRectSolid(this.rand, inX - 1, this.originY - 1, inZ - 1, inX + 1, this.originY - 1, inZ + 1, this.liquid);
        this.editor.fillRectSolid(this.rand, inX - 2, this.originY - 1, inZ - 2, inX - 2, this.originY + 3, inZ - 2, this.fillBlocks);
        this.editor.fillRectSolid(this.rand, inX - 2, this.originY - 1, inZ + 2, inX - 2, this.originY + 3, inZ + 2, this.fillBlocks);
        this.editor.fillRectSolid(this.rand, inX + 2, this.originY - 1, inZ - 2, inX + 2, this.originY + 3, inZ - 2, this.fillBlocks);
        this.editor.fillRectSolid(this.rand, inX + 2, this.originY - 1, inZ + 2, inX + 2, this.originY + 3, inZ + 2, this.fillBlocks);
        this.editor.fillRectSolid(this.rand, inX - 1, this.originY - 1, inZ - 2, inX + 1, this.originY - 1, inZ - 2, this.fillBlocks);
        this.editor.fillRectSolid(this.rand, inX - 1, this.originY - 1, inZ + 2, inX + 1, this.originY - 1, inZ + 2, this.fillBlocks);
        this.editor.fillRectSolid(this.rand, inX - 2, this.originY - 1, inZ - 1, inX - 2, this.originY - 1, inZ + 1, this.fillBlocks);
        this.editor.fillRectSolid(this.rand, inX + 2, this.originY - 1, inZ - 1, inX + 2, this.originY - 1, inZ + 1, this.fillBlocks);
        this.editor.fillRectSolid(this.rand, inX - 1, this.originY + 3, inZ - 2, inX + 1, this.originY + 3, inZ - 2, this.fillBlocks);
        this.editor.fillRectSolid(this.rand, inX - 1, this.originY + 3, inZ + 2, inX + 1, this.originY + 3, inZ + 2, this.fillBlocks);
        this.editor.fillRectSolid(this.rand, inX - 2, this.originY + 3, inZ - 1, inX - 2, this.originY + 3, inZ + 1, this.fillBlocks);
        this.editor.fillRectSolid(this.rand, inX + 2, this.originY + 3, inZ - 1, inX + 2, this.originY + 3, inZ + 1, this.fillBlocks);
        this.editor.fillRectSolid(this.rand, inX - 1, this.originY + 1, inZ - 1, inX + 1, this.originY + 6, inZ + 1, BlockType.get(BlockType.AIR));
        this.editor.fillRectSolid(this.rand, inX - 2, this.originY + 7, inZ - 2, inX + 2, this.originY + 8, inZ + 2, this.fillBlocks);
        this.editor.fillRectSolid(this.rand, inX - 1, this.originY + 8, inZ - 1, inX + 1, this.originY + 8, inZ + 1, this.liquid);
    }

    public boolean isValidDungeonLocation(WorldEditor editor, int originX, int originY, int originZ) {
        return false;
    }

    @Override
    public int getSize() {
        return 8;
    }
}

