/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.segment.part;

import greymerk.roguelike.dungeon.IDungeonLevel;
import greymerk.roguelike.dungeon.segment.ISegment;
import greymerk.roguelike.theme.ITheme;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.WorldEditor;
import java.util.Random;

public abstract class SegmentBase
implements ISegment {
    @Override
    public void generate(WorldEditor editor, Random rand, IDungeonLevel level, Cardinal dir, ITheme theme, int x, int y, int z) {
        if (level.hasNearbyNode(new Coord(x, y, z))) {
            return;
        }
        if (this.isValidWall(editor, dir, x, y, z)) {
            this.genWall(editor, rand, level, dir, theme, x, y, z);
        }
    }

    protected abstract void genWall(WorldEditor var1, Random var2, IDungeonLevel var3, Cardinal var4, ITheme var5, int var6, int var7, int var8);

    protected boolean isValidWall(WorldEditor editor, Cardinal wallDirection, int x, int y, int z) {
        switch (wallDirection) {
            case NORTH: {
                if (editor.isAirBlock(new Coord(x - 1, y + 1, z - 2))) {
                    return false;
                }
                if (!editor.isAirBlock(new Coord(x + 1, y + 1, z - 2))) break;
                return false;
            }
            case SOUTH: {
                if (editor.isAirBlock(new Coord(x - 1, y + 1, z + 2))) {
                    return false;
                }
                if (!editor.isAirBlock(new Coord(x + 1, y + 1, z + 2))) break;
                return false;
            }
            case EAST: {
                if (editor.isAirBlock(new Coord(x + 2, y + 1, z - 1))) {
                    return false;
                }
                if (!editor.isAirBlock(new Coord(x + 2, y + 1, z + 1))) break;
                return false;
            }
            case WEST: {
                if (editor.isAirBlock(new Coord(x - 2, y + 1, z - 1))) {
                    return false;
                }
                if (!editor.isAirBlock(new Coord(x - 2, y + 1, z + 1))) break;
                return false;
            }
            default: {
                return false;
            }
        }
        return true;
    }
}

