/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.segment.part;

import greymerk.roguelike.dungeon.IDungeonLevel;
import greymerk.roguelike.dungeon.base.IDungeonRoom;
import greymerk.roguelike.dungeon.base.SecretFactory;
import greymerk.roguelike.dungeon.segment.part.SegmentBase;
import greymerk.roguelike.theme.ITheme;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IStair;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.WorldEditor;
import greymerk.roguelike.worldgen.blocks.BlockType;
import greymerk.roguelike.worldgen.blocks.Door;
import java.util.Random;

public class SegmentDoor
extends SegmentBase {
    @Override
    protected void genWall(WorldEditor editor, Random rand, IDungeonLevel level, Cardinal dir, ITheme theme, int x, int y, int z) {
        MetaBlock air = BlockType.get(BlockType.AIR);
        IStair stair = theme.getSecondaryStair();
        Coord cursor = new Coord(x, y, z);
        Cardinal[] orth = Cardinal.getOrthogonal(dir);
        cursor.add(dir, 2);
        Coord start = new Coord(cursor);
        start.add(orth[0], 1);
        Coord end = new Coord(cursor);
        end.add(orth[1], 1);
        end.add(Cardinal.UP, 2);
        editor.fillRectSolid(rand, start, end, air, true, true);
        SecretFactory secrets = level.getSettings().getSecrets();
        IDungeonRoom room = secrets.genRoom(editor, rand, level.getSettings(), dir, new Coord(x, y, z));
        start.add(dir, 1);
        end.add(dir, 1);
        editor.fillRectSolid(rand, start, end, theme.getSecondaryWall(), false, true);
        cursor.add(Cardinal.UP, 2);
        for (Cardinal d : orth) {
            Coord c = new Coord(cursor);
            c.add(d, 1);
            stair.setOrientation(Cardinal.reverse(d), true);
            editor.setBlock(rand, c, stair, true, true);
        }
        if (room != null) {
            cursor = new Coord(x, y, z);
            cursor.add(dir, 3);
            Door.generate(editor, cursor, Cardinal.reverse(dir), Door.OAK);
        }
    }
}

