/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.segment.part;

import greymerk.roguelike.dungeon.IDungeonLevel;
import greymerk.roguelike.dungeon.segment.part.SegmentBase;
import greymerk.roguelike.theme.ITheme;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IStair;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.WorldEditor;
import greymerk.roguelike.worldgen.blocks.BlockType;
import java.util.Random;

public class SegmentSewer
extends SegmentBase {
    @Override
    protected void genWall(WorldEditor editor, Random rand, IDungeonLevel level, Cardinal dir, ITheme theme, int x, int y, int z) {
        MetaBlock air = BlockType.get(BlockType.AIR);
        MetaBlock water = BlockType.get(BlockType.WATER_FLOWING);
        IStair stair = theme.getSecondaryStair();
        Cardinal[] orth = Cardinal.getOrthogonal(dir);
        Coord start = new Coord(x, y, z);
        start.add(Cardinal.UP, 2);
        start.add(dir);
        Coord end = new Coord(start);
        start.add(orth[0]);
        end.add(orth[1]);
        stair.setOrientation(Cardinal.reverse(dir), true);
        editor.fillRectSolid(rand, start, end, stair, true, true);
        start = new Coord(x, y, z);
        start.add(Cardinal.DOWN);
        end = new Coord(start);
        start.add(orth[0]);
        end.add(orth[1]);
        editor.fillRectSolid(rand, start, end, air, true, true);
        start.add(Cardinal.DOWN);
        end.add(Cardinal.DOWN);
        editor.fillRectSolid(rand, start, end, water, true, true);
    }
}

