/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.segment.part;

import greymerk.roguelike.dungeon.IDungeonLevel;
import greymerk.roguelike.dungeon.segment.part.SegmentBase;
import greymerk.roguelike.theme.ITheme;
import greymerk.roguelike.worldgen.BlockJumble;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IStair;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.WorldEditor;
import greymerk.roguelike.worldgen.blocks.BlockType;
import greymerk.roguelike.worldgen.blocks.Crops;
import java.util.Random;

public class SegmentWheat
extends SegmentBase {
    @Override
    protected void genWall(WorldEditor editor, Random rand, IDungeonLevel level, Cardinal dir, ITheme theme, int x, int y, int z) {
        Coord cursor = new Coord(x, y, z);
        cursor.add(Cardinal.DOWN);
        cursor.add(dir, 3);
        editor.setBlock(cursor, BlockType.get(BlockType.WATER_FLOWING));
        Cardinal[] orth = Cardinal.getOrthogonal(dir);
        Coord start = new Coord(x, y, z);
        start.add(dir, 2);
        Coord end = new Coord(start);
        start.add(orth[0]);
        end.add(orth[1]);
        start.add(Cardinal.UP, 2);
        end.add(dir);
        editor.fillRectSolid(rand, start, end, theme.getSecondaryWall(), true, true);
        start = new Coord(x, y, z);
        start.add(dir, 2);
        end = new Coord(start);
        start.add(orth[0], 1);
        end.add(orth[1], 1);
        end.add(Cardinal.UP, 1);
        editor.fillRectSolid(rand, start, end, BlockType.get(BlockType.AIR), true, true);
        start.add(Cardinal.DOWN, 1);
        end.add(Cardinal.DOWN, 2);
        editor.fillRectSolid(rand, start, end, BlockType.get(BlockType.FARMLAND), true, true);
        start.add(Cardinal.UP, 1);
        end.add(Cardinal.UP, 1);
        BlockJumble crops = new BlockJumble();
        crops.addBlock(Crops.get(Crops.WHEAT));
        crops.addBlock(Crops.get(Crops.CARROTS));
        crops.addBlock(Crops.get(Crops.POTATOES));
        editor.fillRectSolid(rand, start, end, crops, true, true);
        cursor = new Coord(x, y, z);
        cursor.add(dir, 3);
        cursor.add(Cardinal.UP, 1);
        MetaBlock pumpkin = Crops.getPumpkin(Cardinal.reverse(dir), true);
        pumpkin.setBlock(editor, cursor);
        IStair stair = theme.getSecondaryStair();
        for (Cardinal d : orth) {
            cursor = new Coord(x, y, z);
            cursor.add(dir, 2);
            cursor.add(d, 1);
            cursor.add(Cardinal.UP, 1);
            stair.setOrientation(Cardinal.reverse(d), true);
            editor.setBlock(rand, cursor, stair, true, true);
        }
    }
}

