/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import greymerk.roguelike.worldgen.BlockBase;
import greymerk.roguelike.worldgen.BlockProvider;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IBlockFactory;
import greymerk.roguelike.worldgen.WorldEditor;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class BlockLayers
extends BlockBase {
    private List<IBlockFactory> blocks = new ArrayList<IBlockFactory>();

    public BlockLayers() {
    }

    public BlockLayers(JsonElement data) {
        this();
        for (JsonElement entry : (JsonArray)data) {
            this.addBlock(BlockProvider.create(entry.getAsJsonObject()));
        }
    }

    public void addBlock(IBlockFactory toAdd) {
        this.blocks.add(toAdd);
    }

    @Override
    public boolean setBlock(WorldEditor editor, Random rand, Coord pos, boolean fillAir, boolean replaceSolid) {
        IBlockFactory block = this.blocks.get(pos.getY() % this.blocks.size());
        return block.setBlock(editor, rand, pos, fillAir, replaceSolid);
    }
}

