/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen;

import greymerk.roguelike.config.RogueConfig;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.WorldEditor;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntityMobSpawner;

public enum Spawner {
    CREEPER,
    CAVESPIDER,
    SPIDER,
    SKELETON,
    ZOMBIE,
    SILVERFISH,
    ENDERMAN,
    WITCH,
    WITHERBOSS,
    BAT,
    LAVASLIME,
    BLAZE,
    SLIME,
    PRIMEDTNT,
    PIGZOMBIE;

    private static final Spawner[] common;

    public static void generate(WorldEditor editor, Random rand, LevelSettings settings, Coord pos) {
        Spawner type = common[rand.nextInt(common.length)];
        Spawner.generate(editor, rand, settings, pos, type);
    }

    public static void generate(WorldEditor editor, Random rand, LevelSettings settings, Coord pos, Spawner type) {
        if (settings.getSpawners() != null) {
            settings.getSpawners().generate(editor, rand, pos, type, settings.getDifficulty(pos));
            return;
        }
        Spawner.generate(editor, rand, settings.getDifficulty(pos), pos, type);
    }

    public static void generate(WorldEditor editor, Random rand, int level, Coord pos, Spawner type) {
        if (!editor.setBlock(pos, new MetaBlock(Blocks.field_150474_ac))) {
            return;
        }
        TileEntityMobSpawner spawner = (TileEntityMobSpawner)editor.getTileEntity(pos);
        if (spawner == null) {
            return;
        }
        String name = Spawner.getSpawnerName(type);
        MobSpawnerBaseLogic logic = spawner.func_145881_a();
        logic.func_98272_a(name);
        if (RogueConfig.getBoolean(RogueConfig.ROGUESPAWNERS)) {
            Spawner.setRoguelike(logic, level, name);
        }
    }

    public static String getSpawnerName(Spawner type) {
        switch (type) {
            case CREEPER: {
                return "Creeper";
            }
            case CAVESPIDER: {
                return "CaveSpider";
            }
            case SPIDER: {
                return "Spider";
            }
            case SKELETON: {
                return "Skeleton";
            }
            case ZOMBIE: {
                return "Zombie";
            }
            case SILVERFISH: {
                return "Silverfish";
            }
            case ENDERMAN: {
                return "Enderman";
            }
            case WITCH: {
                return "Witch";
            }
            case WITHERBOSS: {
                return "WitherBoss";
            }
            case BAT: {
                return "Bat";
            }
            case LAVASLIME: {
                return "LavaSlime";
            }
            case BLAZE: {
                return "Blaze";
            }
            case SLIME: {
                return "Slime";
            }
            case PRIMEDTNT: {
                return "PrimedTnt";
            }
            case PIGZOMBIE: {
                return "PigZombie";
            }
        }
        return "pig";
    }

    public static void setMeta(MobSpawnerBaseLogic logic, NBTTagCompound meta) {
        MobSpawnerBaseLogic mobSpawnerBaseLogic = logic;
        mobSpawnerBaseLogic.getClass();
        MobSpawnerBaseLogic.WeightedRandomMinecart cart = new MobSpawnerBaseLogic.WeightedRandomMinecart(mobSpawnerBaseLogic, meta);
        logic.func_98277_a(cart);
        logic.func_98278_g();
    }

    public static void setRoguelike(MobSpawnerBaseLogic logic, int level, String type) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("Type", type);
        nbt.func_74768_a("Weight", 1);
        NBTTagCompound properties = new NBTTagCompound();
        nbt.func_74782_a("Properties", (NBTBase)properties);
        NBTTagList activeEffects = new NBTTagList();
        properties.func_74782_a("ActiveEffects", (NBTBase)activeEffects);
        NBTTagCompound buff = new NBTTagCompound();
        activeEffects.func_74742_a((NBTBase)buff);
        buff.func_74774_a("Id", (byte)4);
        buff.func_74774_a("Amplifier", (byte)level);
        buff.func_74768_a("Duration", 10);
        buff.func_74774_a("Ambient", (byte)0);
        MobSpawnerBaseLogic mobSpawnerBaseLogic = logic;
        mobSpawnerBaseLogic.getClass();
        MobSpawnerBaseLogic.WeightedRandomMinecart cart = new MobSpawnerBaseLogic.WeightedRandomMinecart(mobSpawnerBaseLogic, nbt);
        logic.func_98277_a(cart);
        logic.func_98278_g();
    }

    static {
        common = new Spawner[]{SPIDER, SKELETON, ZOMBIE};
    }
}

