/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import greymerk.roguelike.util.IWeighted;
import greymerk.roguelike.util.WeightedChoice;
import greymerk.roguelike.util.WeightedRandomizer;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.Spawnable;
import greymerk.roguelike.worldgen.Spawner;
import greymerk.roguelike.worldgen.WorldEditor;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class SpawnerSettings {
    private Map<Spawner, IWeighted<Spawnable>> spawners = new HashMap<Spawner, IWeighted<Spawnable>>();

    public SpawnerSettings(JsonObject data) {
        for (Spawner type : Spawner.values()) {
            if (!data.has(type.name())) continue;
            JsonArray categoryData = data.get(type.name()).getAsJsonArray();
            WeightedRandomizer<Spawnable> spawns = new WeightedRandomizer<Spawnable>();
            this.spawners.put(type, spawns);
            for (JsonElement spawnData : categoryData) {
                JsonObject spawnObj = spawnData.getAsJsonObject();
                int weight = spawnObj.has("weight") ? spawnObj.get("weight").getAsInt() : 1;
                spawns.add(new WeightedChoice<Spawnable>(new Spawnable(spawnObj), weight));
            }
        }
    }

    public SpawnerSettings(SpawnerSettings toCopy) {
        this.spawners.putAll(toCopy.spawners);
    }

    public SpawnerSettings(SpawnerSettings base, SpawnerSettings override) {
        if (base != null) {
            this.spawners.putAll(base.spawners);
        }
        if (override != null) {
            this.spawners.putAll(override.spawners);
        }
    }

    public void generate(WorldEditor editor, Random rand, Coord cursor, Spawner type, int level) {
        if (!this.spawners.containsKey((Object)type)) {
            Spawner.generate(editor, rand, level, cursor, type);
            return;
        }
        Spawnable toSpawn = this.spawners.get((Object)type).get(rand);
        toSpawn.generate(editor, rand, cursor, level);
    }
}

