/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen;

import greymerk.roguelike.treasure.ITreasureChest;
import greymerk.roguelike.treasure.TreasureManager;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IBlockFactory;
import greymerk.roguelike.worldgen.IStair;
import greymerk.roguelike.worldgen.MetaBlock;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Facing;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class WorldEditor {
    World world;
    private Map<Block, Integer> stats;
    private TreasureManager chests;

    public WorldEditor(World world) {
        this.world = world;
        this.stats = new HashMap<Block, Integer>();
        this.chests = new TreasureManager();
    }

    public boolean setBlock(Coord pos, MetaBlock block, boolean fillAir, boolean replaceSolid) {
        MetaBlock currentBlock = this.getBlock(pos);
        if (currentBlock.getBlock() == Blocks.field_150486_ae) {
            return false;
        }
        if (currentBlock.getBlock() == Blocks.field_150447_bR) {
            return false;
        }
        if (currentBlock.getBlock() == Blocks.field_150474_ac) {
            return false;
        }
        boolean isAir = this.world.func_147437_c(pos.getX(), pos.getY(), pos.getZ());
        if (!fillAir && isAir) {
            return false;
        }
        if (!replaceSolid && !isAir) {
            return false;
        }
        try {
            this.world.func_147465_d(pos.getX(), pos.getY(), pos.getZ(), block.getBlock(), block.getMeta(), block.getFlag());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Block type = block.getBlock();
        Integer count = this.stats.get(type);
        if (count == null) {
            this.stats.put(type, 1);
        } else {
            this.stats.put(type, count + 1);
        }
        return true;
    }

    public boolean setBlock(Coord pos, MetaBlock block) {
        return block.setBlock(this, pos);
    }

    public boolean setBlock(Coord pos, Block block) {
        return this.setBlock(pos, new MetaBlock(block));
    }

    public boolean setBlock(Random rand, Coord coord, IBlockFactory blocks, boolean fillAir, boolean replaceSolid) {
        return blocks.setBlock(this, rand, coord, fillAir, replaceSolid);
    }

    public boolean isAirBlock(Coord pos) {
        return this.world.func_147437_c(pos.getX(), pos.getY(), pos.getZ());
    }

    public boolean isOpaque(Coord pos) {
        Block b = this.getBlock(pos).getBlock();
        Material m = b.func_149688_o();
        return m.func_76218_k();
    }

    public long getSeed() {
        return this.world.func_72905_C();
    }

    public BiomeGenBase getBiome(Coord pos) {
        return this.world.func_72807_a(pos.getX(), pos.getZ());
    }

    public int getDimension() {
        return this.world.field_73011_w.field_76574_g;
    }

    public Random setSeed(int a, int b, int c) {
        return this.world.func_72843_D(a, b, c);
    }

    public void fillRectSolid(Random rand, Coord start, Coord end, IBlockFactory blocks, boolean fillAir, boolean replaceSolid) {
        Coord c1 = new Coord(start);
        Coord c2 = new Coord(end);
        Coord.correct(c1, c2);
        for (int x = c1.getX(); x <= c2.getX(); ++x) {
            for (int y = c1.getY(); y <= c2.getY(); ++y) {
                for (int z = c1.getZ(); z <= c2.getZ(); ++z) {
                    this.setBlock(rand, new Coord(x, y, z), blocks, fillAir, replaceSolid);
                }
            }
        }
    }

    public void fillRectHollow(Random rand, Coord start, Coord end, IBlockFactory blocks, boolean fillAir, boolean replaceSolid) {
        Coord c1 = new Coord(start);
        Coord c2 = new Coord(end);
        Coord.correct(c1, c2);
        for (int x = c1.getX(); x <= c2.getX(); ++x) {
            for (int y = c1.getY(); y <= c2.getY(); ++y) {
                for (int z = c1.getZ(); z <= c2.getZ(); ++z) {
                    if (x == c1.getX() || x == c2.getX() || y == c1.getY() || y == c2.getY() || z == c1.getZ() || z == c2.getZ()) {
                        this.setBlock(rand, new Coord(x, y, z), blocks, fillAir, replaceSolid);
                        continue;
                    }
                    this.setBlock(new Coord(x, y, z), new MetaBlock(Blocks.field_150350_a));
                }
            }
        }
    }

    public static List<Coord> getRectSolid(Coord start, Coord end) {
        return WorldEditor.getRectSolid(start.getX(), start.getY(), start.getZ(), end.getX(), end.getY(), end.getZ());
    }

    public static List<Coord> getRectSolid(int x1, int y1, int z1, int x2, int y2, int z2) {
        Coord c1 = new Coord(x1, y1, z1);
        Coord c2 = new Coord(x2, y2, z2);
        Coord.correct(c1, c2);
        LinkedList<Coord> points = new LinkedList<Coord>();
        for (int x = c1.getX(); x <= c2.getX(); ++x) {
            for (int y = c1.getY(); y <= c2.getY(); ++y) {
                for (int z = c1.getZ(); z <= c2.getZ(); ++z) {
                    points.add(new Coord(x, y, z));
                }
            }
        }
        return points;
    }

    public List<Coord> getRectHollow(Coord start, Coord end) {
        return this.getRectHollow(start.getX(), start.getY(), start.getZ(), end.getX(), end.getY(), end.getZ());
    }

    public List<Coord> getRectHollow(int x1, int y1, int z1, int x2, int y2, int z2) {
        LinkedList<Coord> points = new LinkedList<Coord>();
        Coord c1 = new Coord(x1, y1, z1);
        Coord c2 = new Coord(x2, y2, z2);
        Coord.correct(c1, c2);
        for (int x = c1.getX(); x <= c2.getX(); ++x) {
            for (int y = c1.getY(); y <= c2.getY(); ++y) {
                for (int z = c1.getZ(); z <= c2.getZ(); ++z) {
                    if (x != x1 && x != x2 && y != y1 && y != y2 && z != z1 && z != z2) continue;
                    points.add(new Coord(x, y, z));
                }
            }
        }
        return points;
    }

    public void fillPyramidSolid(Random rand, Coord base, int height, IBlockFactory blocks, boolean fillAir, boolean replaceSolid) {
        if (height == 0) {
            this.setBlock(rand, base, blocks, fillAir, replaceSolid);
            return;
        }
        Coord start = new Coord(base);
        Coord end = new Coord(base);
        start.add(Cardinal.NORTH, height);
        start.add(Cardinal.WEST, height);
        end.add(Cardinal.SOUTH, height);
        end.add(Cardinal.EAST, height);
        this.fillRectSolid(rand, start, end, blocks, fillAir, replaceSolid);
        base.add(Cardinal.UP);
        this.fillPyramidSolid(rand, base, height - 1, blocks, fillAir, replaceSolid);
    }

    public void spiralStairStep(Random rand, Coord origin, IStair stair, IBlockFactory fill) {
        MetaBlock air = new MetaBlock(Blocks.field_150350_a);
        Coord start = new Coord(origin);
        start.add(new Coord(-1, 0, -1));
        Coord end = new Coord(origin);
        end.add(new Coord(1, 0, 1));
        this.fillRectSolid(rand, start, end, air, true, true);
        this.setBlock(rand, origin, fill, true, true);
        Cardinal dir = Cardinal.directions[origin.getY() % 4];
        Cardinal[] orth = Cardinal.getOrthogonal(dir);
        Coord cursor = new Coord(origin);
        cursor.add(dir);
        stair.setOrientation(orth[0], false).setBlock(this, cursor);
        cursor.add(orth[1]);
        stair.setOrientation(orth[1], true).setBlock(this, cursor);
        cursor.add(Cardinal.reverse(dir));
        stair.setOrientation(Cardinal.reverse(dir), true).setBlock(this, cursor);
    }

    public void randomVines(Random rand, int x1, int y1, int z1, int x2, int y2, int z2) {
        Coord c1 = new Coord(x1, y1, z1);
        Coord c2 = new Coord(x2, y2, z2);
        Coord.correct(c1, c2);
        for (int x = c1.getX(); x <= c2.getX(); ++x) {
            for (int y = c1.getY(); y <= c2.getY(); ++y) {
                block2: for (int z = c1.getZ(); z <= c2.getZ(); ++z) {
                    for (int dir = 2; dir <= 5; ++dir) {
                        if (!this.world.func_147437_c(x, y, z) || rand.nextBoolean() || !Blocks.field_150395_bd.func_149707_d(this.world, x, y, z, dir)) continue;
                        this.setBlock(new Coord(x, y, z), new MetaBlock(Blocks.field_150395_bd, 1 << Direction.field_71579_d[Facing.field_71588_a[dir]]), true, true);
                        continue block2;
                    }
                }
            }
        }
    }

    public void fillDown(Random rand, Coord origin, IBlockFactory blocks) {
        Coord cursor = new Coord(origin);
        while (!this.isOpaque(cursor) && cursor.getY() > 1) {
            blocks.setBlock(this, rand, cursor);
            cursor.add(Cardinal.DOWN);
        }
    }

    public MetaBlock getBlock(Coord pos) {
        Block b = this.world.func_147439_a(pos.getX(), pos.getY(), pos.getZ());
        int meta = this.world.func_72805_g(pos.getX(), pos.getY(), pos.getZ());
        return new MetaBlock(b, meta);
    }

    public TileEntity getTileEntity(Coord pos) {
        return this.world.func_147438_o(pos.getX(), pos.getY(), pos.getZ());
    }

    public void setBlock(int x, int y, int z, Block block) {
        new MetaBlock(block).setBlock(this, new Coord(x, y, z));
    }

    public void setBlock(int x, int y, int z, MetaBlock block) {
        block.setBlock(this, new Coord(x, y, z));
    }

    public void fillRectSolid(Random rand, int x, int y, int z, int x2, int y2, int z2, IBlockFactory blocks) {
        this.fillRectSolid(rand, new Coord(x, y, z), new Coord(x2, y2, z2), blocks, true, true);
    }

    public void fillRectSolid(Random rand, int x, int y, int z, int x2, int y2, int z2, IBlockFactory blocks, boolean fillAir, boolean replaceSolid) {
        this.fillRectSolid(rand, new Coord(x, y, z), new Coord(x2, y2, z2), blocks, fillAir, replaceSolid);
    }

    public void setBlock(Random rand, int x, int y, int z, IBlockFactory block, boolean fillAir, boolean replaceSolid) {
        this.setBlock(rand, new Coord(x, y, z), block, true, true);
    }

    public void fillRectHollow(Random rand, int x, int y, int z, int x2, int y2, int z2, IBlockFactory blocks, boolean fillAir, boolean replaceSolid) {
        this.fillRectHollow(rand, new Coord(x, y, z), new Coord(x2, y2, z2), blocks, fillAir, replaceSolid);
    }

    public boolean validGroundBlock(Coord pos) {
        if (this.isAirBlock(pos)) {
            return false;
        }
        Block block = this.getBlock(pos).getBlock();
        if (block.func_149688_o() == Material.field_151575_d) {
            return false;
        }
        if (block.func_149688_o() == Material.field_151586_h) {
            return false;
        }
        if (block.func_149688_o() == Material.field_151570_A) {
            return false;
        }
        if (block.func_149688_o() == Material.field_151597_y) {
            return false;
        }
        if (block.func_149688_o() == Material.field_151577_b) {
            return false;
        }
        if (block.func_149688_o() == Material.field_151572_C) {
            return false;
        }
        if (block.func_149688_o() == Material.field_151584_j) {
            return false;
        }
        return block.func_149688_o() != Material.field_151585_k;
    }

    public String toString() {
        String toReturn = "";
        for (Map.Entry<Block, Integer> pair : this.stats.entrySet()) {
            toReturn = toReturn + pair.getKey().func_149732_F() + ": " + pair.getValue() + "\n";
        }
        return toReturn;
    }

    public void blockUpdate(Coord pos, Block block, int flag) {
        this.world.func_147464_a(pos.getX(), pos.getY(), pos.getZ(), block, flag);
    }

    public void setBlockMetadata(Coord pos, int meta) {
        this.world.func_72921_c(pos.getX(), pos.getY(), pos.getZ(), meta, 2);
    }

    public int getStat(Block type) {
        if (!this.stats.containsKey(type)) {
            return 0;
        }
        return this.stats.get(type);
    }

    public void addChest(ITreasureChest toAdd) {
        this.chests.add(toAdd);
    }

    public TreasureManager getTreasure() {
        return this.chests;
    }

    public boolean canPlaceOnSide(Block block, Coord c, int dir) {
        return block.func_149707_d(this.world, c.getX(), c.getY(), c.getZ(), dir);
    }
}

