/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen.blocks;

import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.WorldEditor;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySkull;

public enum Skull {
    SKELETON,
    WITHER,
    ZOMBIE,
    STEVE,
    CREEPER;


    public static void set(WorldEditor editor, Random rand, Coord pos, Cardinal dir, Skull type) {
        MetaBlock skullBlock = new MetaBlock(Blocks.field_150465_bP, 1);
        if (!skullBlock.setBlock(editor, pos)) {
            return;
        }
        TileEntity skullEntity = editor.getTileEntity(pos);
        if (skullEntity == null) {
            return;
        }
        if (!(skullEntity instanceof TileEntitySkull)) {
            return;
        }
        TileEntitySkull skull = (TileEntitySkull)skullEntity;
        Skull.setType(skull, type);
        Skull.setRotation(rand, skull, dir);
    }

    public static void setType(TileEntitySkull skull, Skull type) {
        skull.func_152107_a(Skull.getSkullId(type));
    }

    public static void setRotation(Random rand, TileEntitySkull skull, Cardinal dir) {
        int directionValue = Skull.getDirectionValue(dir);
        directionValue += -1 + rand.nextInt(3);
        skull.func_145903_a(directionValue %= 16);
    }

    public static int getSkullId(Skull type) {
        switch (type) {
            case SKELETON: {
                return 0;
            }
            case WITHER: {
                return 1;
            }
            case ZOMBIE: {
                return 2;
            }
            case STEVE: {
                return 3;
            }
            case CREEPER: {
                return 4;
            }
        }
        return 0;
    }

    public static int getDirectionValue(Cardinal dir) {
        switch (dir) {
            case NORTH: {
                return 0;
            }
            case EAST: {
                return 4;
            }
            case SOUTH: {
                return 8;
            }
            case WEST: {
                return 12;
            }
        }
        return 0;
    }
}

