/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen.redstone;

import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.WorldEditor;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneRepeater;
import net.minecraft.init.Blocks;

public class Repeater {
    private static final int MAX_DELAY = 3;

    public static void generate(WorldEditor editor, Random rand, Cardinal dir, int delay, Coord pos) {
        Repeater.generate(editor, rand, dir, delay, false, pos);
    }

    public static void generate(WorldEditor editor, Random rand, Cardinal dir, int delay, boolean powered, Coord pos) {
        int meta = 0;
        switch (dir) {
            case NORTH: {
                break;
            }
            case EAST: {
                meta = 1;
                break;
            }
            case SOUTH: {
                meta = 2;
                break;
            }
            case WEST: {
                meta = 3;
                break;
            }
        }
        if (delay > 0) {
            meta += 3 + (delay > 3 ? 3 : delay);
        }
        BlockRedstoneRepeater b = powered ? Blocks.field_150416_aS : Blocks.field_150413_aR;
        MetaBlock repeater = new MetaBlock((Block)b, meta);
        repeater.setBlock(editor, pos);
        editor.blockUpdate(pos, (Block)b, 1);
    }
}

