/*
 * Decompiled with CFR 0.152.
 */
package com.gamerforea.witchery;

import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public final class ItemInventoryValidator {
    public static final String NBT_KEY_UID = "UID";
    private static final Random RANDOM = new Random();
    private final ItemStack stack;
    private final String nbtIdKey;
    private int slotIndex = -1;
    private int slotNumber = -1;

    public ItemInventoryValidator(ItemStack stack) {
        this(stack, NBT_KEY_UID, false, true);
    }

    public ItemInventoryValidator(ItemStack stack, String nbtIdKey, boolean generateIdIfAbsent, boolean useIntegerId) {
        this.stack = stack;
        this.nbtIdKey = nbtIdKey;
        if (generateIdIfAbsent && stack != null) {
            NBTTagCompound nbt = stack.func_77978_p();
            if (nbt == null) {
                nbt = new NBTTagCompound();
                stack.func_77982_d(nbt);
            }
            if (!nbt.func_74764_b(nbtIdKey)) {
                if (useIntegerId) {
                    nbt.func_74768_a(nbtIdKey, RANDOM.nextInt());
                } else {
                    nbt.func_74778_a(nbtIdKey, UUID.randomUUID().toString());
                }
            }
        }
    }

    public int getSlotIndex() {
        return this.slotIndex;
    }

    public void setSlotIndex(int slotIndex) {
        this.slotIndex = slotIndex;
    }

    public int getSlotNumber() {
        return this.slotNumber;
    }

    public void setSlotNumber(int slotNumber) {
        this.slotNumber = slotNumber;
    }

    public boolean canInteractWith(EntityPlayer player) {
        return this.slotIndex < 0 || this.slotIndex == player.field_71071_by.field_70461_c;
    }

    public boolean canSlotClick(int slot, int button, int buttonType, EntityPlayer player) {
        if (this.slotNumber >= 0 && slot == this.slotNumber) {
            return false;
        }
        if (buttonType == 2 && this.slotIndex >= 0 && button == this.slotIndex) {
            return false;
        }
        return this.canInteractWith(player);
    }
}

