/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.client.gui.startup;

import com.mumfrey.liteloader.common.LoadingProgress;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;

public class LoadingBar
extends LoadingProgress {
    private static LoadingBar instance;
    private final String LOADING_MESSAGE_1 = "Starting Game...";
    private final String LOADING_MESSAGE_2 = "Initialising...";
    private int minecraftProgress = 0;
    private int totalMinecraftProgress = 606;
    private int liteLoaderProgressScale = 3;
    private int liteLoaderProgress = 0;
    private int totalLiteLoaderProgress = 0;
    private bqx textureLocation = new bqx("textures/gui/title/mojang.png");
    private String minecraftMessage = this.LOADING_MESSAGE_1;
    private String message = "";
    private bao minecraft;
    private bqf textureManager;
    private bbu fontRenderer;
    private bmg fbo;
    private boolean enabled = true;
    private boolean errored;
    private boolean calculatedColour = false;
    private int barLuma = 0;
    private int r2 = 246;
    private int g2 = 136;
    private int b2 = 62;
    private int logIndex = 0;
    private List<String> logTail = new ArrayList<String>();

    public LoadingBar() {
        instance = this;
    }

    @Override
    protected void _setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    protected void _dispose() {
        this.minecraft = null;
        this.textureManager = null;
        this.fontRenderer = null;
        this.disposeFbo();
    }

    private void disposeFbo() {
        if (this.fbo != null) {
            this.fbo.a();
            this.fbo = null;
        }
    }

    public static void incrementProgress() {
        if (instance != null) {
            instance._incrementProgress();
        }
    }

    protected void _incrementProgress() {
        this.message = this.minecraftMessage;
        ++this.minecraftProgress;
        this.render();
    }

    public static void initTextures() {
        if (instance != null) {
            instance._initTextures();
        }
    }

    protected void _initTextures() {
        this.minecraftMessage = this.LOADING_MESSAGE_2;
    }

    @Override
    protected void _incLiteLoaderProgress() {
        this.liteLoaderProgress += this.liteLoaderProgressScale;
        this.render();
    }

    @Override
    protected void _setMessage(String message) {
        this.message = message;
        this.render();
    }

    @Override
    protected void _incLiteLoaderProgress(String message) {
        this.message = message;
        this.liteLoaderProgress += this.liteLoaderProgressScale;
        this.render();
    }

    @Override
    protected void _incTotalLiteLoaderProgress(int by) {
        this.totalLiteLoaderProgress += by * this.liteLoaderProgressScale;
        this.render();
    }

    private void render() {
        if (!this.enabled || this.errored) {
            return;
        }
        try {
            if (this.minecraft == null) {
                this.minecraft = bao.B();
            }
            if (this.textureManager == null) {
                this.textureManager = this.minecraft.P();
            }
            if (Display.isCreated() && this.textureManager != null) {
                if (this.fontRenderer == null) {
                    this.fontRenderer = new bbu(this.minecraft.u, new bqx("textures/font/ascii.png"), this.textureManager, false);
                    this.fontRenderer.a(this.minecraft.Q());
                }
                double totalProgress = this.totalMinecraftProgress + this.totalLiteLoaderProgress;
                double progress = (double)(this.minecraftProgress + this.liteLoaderProgress) / totalProgress;
                this.render(progress);
            }
        }
        catch (Exception ex) {
            this.errored = true;
        }
    }

    private void render(double progress) {
        if (this.totalMinecraftProgress == -1) {
            this.totalMinecraftProgress = 606 - this.minecraftProgress;
            this.minecraftProgress = 0;
        }
        if (!this.calculatedColour) {
            this.calculatedColour = true;
            bqh texture = this.textureManager.b(this.textureLocation);
            if (texture == null) {
                try {
                    bpq textureData = this.loadTexture(this.minecraft.Q(), this.textureLocation);
                    this.textureLocation = this.minecraft.P().a("loadingScreen", textureData);
                    this.findMostCommonColour(textureData.d());
                    textureData.a();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        bca scaledResolution = new bca(this.minecraft, this.minecraft.d, this.minecraft.e);
        int scaleFactor = scaledResolution.e();
        int scaledWidth = scaledResolution.a();
        int scaledHeight = scaledResolution.b();
        int fboWidth = scaledWidth * scaleFactor;
        int fboHeight = scaledHeight * scaleFactor;
        if (this.fbo == null) {
            this.fbo = new bmg(fboWidth, fboHeight, true);
        } else if (this.fbo.c != fboWidth || this.fbo.d != fboHeight) {
            this.fbo.a(fboWidth, fboHeight);
        }
        this.fbo.a(false);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)scaledWidth, (double)scaledHeight, (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        GL11.glClear((int)16640);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2912);
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3553);
        this.textureManager.a(this.textureLocation);
        bmh tessellator = bmh.a;
        tessellator.b();
        tessellator.c(-1);
        tessellator.a(0.0, (double)scaledHeight, 0.0, 0.0, 0.0);
        tessellator.a((double)scaledWidth, (double)scaledHeight, 0.0, 0.0, 0.0);
        tessellator.a((double)scaledWidth, 0.0, 0.0, 0.0, 0.0);
        tessellator.a(0.0, 0.0, 0.0, 0.0, 0.0);
        tessellator.a();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int left = (scaledWidth - 256) / 2;
        int top = (scaledHeight - 256) / 2;
        int u1 = 0;
        int v1 = 0;
        int u2 = 256;
        int v2 = 256;
        float texMapScale = 0.00390625f;
        tessellator.b();
        tessellator.c(-1);
        tessellator.a((double)(left + 0), (double)(top + v2), 0.0, (double)((float)(u1 + 0) * texMapScale), (double)((float)(v1 + v2) * texMapScale));
        tessellator.a((double)(left + u2), (double)(top + v2), 0.0, (double)((float)(u1 + u2) * texMapScale), (double)((float)(v1 + v2) * texMapScale));
        tessellator.a((double)(left + u2), (double)(top + 0), 0.0, (double)((float)(u1 + u2) * texMapScale), (double)((float)(v1 + 0) * texMapScale));
        tessellator.a((double)(left + 0), (double)(top + 0), 0.0, (double)((float)(u1 + 0) * texMapScale), (double)((float)(v1 + 0) * texMapScale));
        tessellator.a();
        GL11.glEnable((int)3058);
        GL11.glLogicOp((int)5387);
        this.fontRenderer.b(this.message, 1, scaledHeight - 19, -16777216);
        if (LiteLoaderLogger.DEBUG) {
            int logBottom = this.minecraft.e - 20 * scaleFactor - 2;
            GL11.glPushMatrix();
            GL11.glScalef((float)(1.0f / (float)scaleFactor), (float)(1.0f / (float)scaleFactor), (float)1.0f);
            this.renderLogTail(logBottom);
            GL11.glPopMatrix();
        }
        GL11.glDisable((int)3058);
        GL11.glEnable((int)3553);
        double barHeight = 10.0;
        double barWidth = scaledResolution.c() - 2.0;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glAlphaFunc((int)516, (float)0.0f);
        GL11.glBlendFunc((int)770, (int)771);
        tessellator.b();
        tessellator.a(this.barLuma, this.barLuma, this.barLuma, 128);
        tessellator.a(0.0, (double)scaledHeight, 0.0);
        tessellator.a(0.0 + (double)scaledWidth, (double)scaledHeight, 0.0);
        tessellator.a(0.0 + (double)scaledWidth, (double)scaledHeight - barHeight, 0.0);
        tessellator.a(0.0, (double)scaledHeight - barHeight, 0.0);
        tessellator.a();
        tessellator.b();
        tessellator.a(this.r2, this.g2, this.b2, 255);
        tessellator.a(1.0 + barWidth * progress, (double)(scaledHeight - 1), 1.0);
        tessellator.a(1.0 + barWidth * progress, (double)scaledHeight - (barHeight -= 1.0), 1.0);
        tessellator.a(0, 0, 0, 255);
        tessellator.a(1.0, (double)scaledHeight - barHeight, 1.0);
        tessellator.a(1.0, (double)(scaledHeight - 1), 1.0);
        tessellator.a();
        GL11.glAlphaFunc((int)516, (float)0.1f);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2912);
        this.fbo.e();
        this.fbo.c(fboWidth, fboHeight);
        GL11.glEnable((int)3008);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        GL11.glFlush();
        this.minecraft.g();
    }

    private void renderLogTail(int yPos) {
        if ((long)this.logIndex != LiteLoaderLogger.getLogIndex()) {
            this.logTail = LiteLoaderLogger.getLogTail();
        }
        for (int logIndex = this.logTail.size() - 1; yPos > 10 && logIndex >= 0; --logIndex) {
            this.fontRenderer.b(this.logTail.get(logIndex), 10, yPos -= 10, -16777216);
        }
    }

    private void findMostCommonColour(int[] textureData) {
        int paletteIndex;
        int[] freq = new int[512];
        for (int pos = 0; pos < textureData.length; ++pos) {
            int n = paletteIndex = ((textureData[pos] >> 21 & 7) << 6) + ((textureData[pos] >> 13 & 7) << 3) + (textureData[pos] >> 5 & 7);
            freq[n] = freq[n] + 1;
        }
        int peak = 0;
        for (paletteIndex = 2; paletteIndex < 511; ++paletteIndex) {
            if (freq[paletteIndex] <= peak) continue;
            peak = freq[paletteIndex];
            this.setBarColour(paletteIndex);
        }
    }

    private void setBarColour(int paletteIndex) {
        this.r2 = this.padComponent((paletteIndex & 0x1C0) >> 1);
        this.g2 = this.padComponent((paletteIndex & 0x38) << 2);
        this.b2 = this.padComponent((paletteIndex & 7) << 5);
        this.barLuma = Math.max(this.r2, Math.max(this.g2, this.b2)) < 64 ? 255 : 0;
    }

    private int padComponent(int component) {
        return component > 31 ? component | 0x1F : component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private bpq loadTexture(bqy resourceManager, bqx textureLocation) throws IOException {
        InputStream inputStream = null;
        try {
            bqw resource = resourceManager.a(textureLocation);
            inputStream = resource.b();
            BufferedImage image = ImageIO.read(inputStream);
            bpq bpq2 = new bpq(image);
            return bpq2;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }
}

