/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.core;

import com.mumfrey.liteloader.api.LiteAPI;
import com.mumfrey.liteloader.api.manager.APIAdapter;
import com.mumfrey.liteloader.api.manager.APIProvider;
import com.mumfrey.liteloader.api.manager.APIRegistry;
import com.mumfrey.liteloader.common.LoadingProgress;
import com.mumfrey.liteloader.core.EnabledModsList;
import com.mumfrey.liteloader.core.LiteLoader;
import com.mumfrey.liteloader.core.LiteLoaderEnumerator;
import com.mumfrey.liteloader.core.LiteLoaderVersion;
import com.mumfrey.liteloader.core.api.LiteLoaderCoreAPI;
import com.mumfrey.liteloader.interfaces.LoaderEnumerator;
import com.mumfrey.liteloader.launch.LoaderBootstrap;
import com.mumfrey.liteloader.launch.LoaderEnvironment;
import com.mumfrey.liteloader.launch.LoaderProperties;
import com.mumfrey.liteloader.launch.StartupEnvironment;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Properties;
import net.minecraft.launchwrapper.ITweaker;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.layout.PatternLayout;

class LiteLoaderBootstrap
implements LoaderBootstrap,
LoaderEnvironment,
LoaderProperties {
    private final File gameDirectory;
    private final File assetsDirectory;
    private final String profile;
    private final File modsFolder;
    private final File versionedModsFolder;
    private final File configBaseFolder;
    private final File commonConfigFolder;
    private final File versionConfigFolder;
    private File logFile;
    private File propertiesFile;
    private File enabledModsFile;
    private Properties internalProperties = new Properties();
    private Properties localProperties = new Properties();
    private String branding = null;
    private boolean loadTweaks = true;
    private LaunchClassLoader classLoader;
    private final ITweaker tweaker;
    private final APIRegistry apiRegistry;
    private final APIProvider apiProvider;
    private final APIAdapter apiAdapter;
    private final LoaderEnvironment.EnvironmentType environmentType;
    private LiteLoaderEnumerator enumerator;
    private EnabledModsList enabledModsList;

    public LiteLoaderBootstrap(StartupEnvironment env, ITweaker tweaker) {
        this.environmentType = LoaderEnvironment.EnvironmentType.values()[env.getEnvironmentTypeId()];
        this.tweaker = tweaker;
        this.apiRegistry = new APIRegistry(this.getEnvironment(), this.getProperties());
        this.gameDirectory = env.getGameDirectory();
        this.assetsDirectory = env.getAssetsDirectory();
        this.profile = env.getProfile();
        this.modsFolder = env.getModsFolder();
        this.versionedModsFolder = new File(this.modsFolder, LiteLoaderVersion.CURRENT.getMinecraftVersion());
        this.configBaseFolder = new File(this.gameDirectory, "liteconfig");
        this.logFile = new File(this.configBaseFolder, "liteloader.log");
        this.propertiesFile = new File(this.configBaseFolder, "liteloader.properties");
        this.enabledModsFile = new File(this.configBaseFolder, "liteloader.profiles.json");
        this.commonConfigFolder = new File(this.configBaseFolder, "common");
        this.versionConfigFolder = this.inflectVersionedConfigPath(LiteLoaderVersion.CURRENT);
        if (!this.modsFolder.exists()) {
            this.modsFolder.mkdirs();
        }
        if (!this.versionedModsFolder.exists()) {
            this.versionedModsFolder.mkdirs();
        }
        if (!this.configBaseFolder.exists()) {
            this.configBaseFolder.mkdirs();
        }
        if (!this.commonConfigFolder.exists()) {
            this.commonConfigFolder.mkdirs();
        }
        if (!this.versionConfigFolder.exists()) {
            this.versionConfigFolder.mkdirs();
        }
        this.initAPIs(env.getAPIsToLoad());
        this.apiProvider = this.apiRegistry.getProvider();
        this.apiAdapter = this.apiRegistry.getAdapter();
    }

    @Override
    public File inflectVersionedConfigPath(LiteLoaderVersion version) {
        if (version.equals((Object)LiteLoaderVersion.LEGACY)) {
            return this.modsFolder;
        }
        return new File(this.configBaseFolder, String.format("config.%s", version.getMinecraftVersion()));
    }

    private void initAPIs(List<String> apisToLoad) {
        if (apisToLoad != null) {
            for (String apiClassName : apisToLoad) {
                this.registerAPI(apiClassName);
            }
        }
        this.apiRegistry.bake();
    }

    public void registerAPI(String apiClassName) {
        this.apiRegistry.registerAPI(apiClassName);
    }

    @Override
    public APIProvider getAPIProvider() {
        return this.apiProvider;
    }

    @Override
    public APIAdapter getAPIAdapter() {
        return this.apiAdapter;
    }

    @Override
    public EnabledModsList getEnabledModsList() {
        return this.enabledModsList;
    }

    @Override
    public LoaderEnumerator getEnumerator() {
        return this.enumerator;
    }

    @Override
    public LoaderEnvironment.EnvironmentType getType() {
        return this.environmentType;
    }

    @Override
    public LoaderEnvironment getEnvironment() {
        return this;
    }

    @Override
    public LoaderProperties getProperties() {
        return this;
    }

    @Override
    public ITweaker getTweaker() {
        return this.tweaker;
    }

    @Override
    public void preInit(LaunchClassLoader classLoader, boolean loadTweaks, List<String> modsToLoad) {
        this.classLoader = classLoader;
        this.loadTweaks = loadTweaks;
        LiteLoaderLogger.info("LiteLoader begin PREINIT...", new Object[0]);
        if (!this.prepare()) {
            return;
        }
        LiteLoaderLogger.info("LiteLoader %s starting up...", LiteLoaderVersion.CURRENT.getLoaderVersion());
        if (this.branding != null) {
            LiteLoaderLogger.info("Active Pack: %s", this.branding);
        }
        LiteLoaderLogger.info("Java reports OS=\"%s\"", System.getProperty("os.name").toLowerCase());
        this.enabledModsList = EnabledModsList.createFrom(this.enabledModsFile);
        this.enabledModsList.processModsList(this.profile, modsToLoad);
        this.enumerator = this.spawnEnumerator(classLoader);
        this.enumerator.onPreInit();
        LiteLoaderLogger.info("LiteLoader PREINIT complete", new Object[0]);
    }

    protected LiteLoaderEnumerator spawnEnumerator(LaunchClassLoader classLoader) {
        return new LiteLoaderEnumerator(this, this, classLoader);
    }

    @Override
    public void preBeginGame() {
        LoadingProgress.setEnabled(this.getAndStoreBooleanProperty("loadingbar", true));
        LiteAPI api = this.getAPIProvider().getAPI("liteloader");
        if (api instanceof LiteLoaderCoreAPI) {
            ((LiteLoaderCoreAPI)api).getObjectFactory().preBeginGame();
        }
    }

    @Override
    public void init() {
        if (this.enumerator == null) {
            return;
        }
        LiteLoader.createInstance(this.getEnvironment(), this.getProperties(), this.classLoader);
        LiteLoader.invokeInit();
    }

    @Override
    public void postInit() {
        if (this.enumerator == null) {
            return;
        }
        LiteLoader.invokePostInit();
    }

    private boolean prepare() {
        try {
            this.prepareProperties();
            this.prepareLogger();
            this.prepareBranding();
        }
        catch (Throwable th) {
            LiteLoaderLogger.severe(th, "Error initialising LiteLoader Bootstrap", new Object[0]);
            return false;
        }
        return true;
    }

    private void prepareLogger() throws SecurityException, IOException {
        LiteLoaderLogger.info("Setting up logger...", new Object[0]);
        Logger logger = LiteLoaderLogger.getLogger();
        PatternLayout.Builder layoutBilder = PatternLayout.newBuilder();
        PatternLayout layout = layoutBilder.withPattern("[%d{HH:mm:ss}] [%t/%level]: %msg%n").withConfiguration(logger.getContext().getConfiguration()).build();
        FileAppender.Builder fileBuilder = FileAppender.newBuilder();
        fileBuilder.withFileName(this.logFile.getAbsolutePath()).withAppend(false).setName("LiteLoader").setIgnoreExceptions(true).setConfiguration(logger.getContext().getConfiguration()).setLayout((Layout)layout);
        FileAppender fileAppender = fileBuilder.build();
        fileAppender.start();
        logger.addAppender((Appender)fileAppender);
    }

    private void prepareProperties() {
        LiteLoaderLogger.info("Initialising Loader properties...", new Object[0]);
        try {
            InputStream propertiesStream = LiteLoaderBootstrap.class.getResourceAsStream("/liteloader.properties");
            if (propertiesStream != null) {
                this.internalProperties.load(propertiesStream);
                propertiesStream.close();
            }
        }
        catch (Throwable th) {
            this.internalProperties = new Properties();
        }
        try {
            this.localProperties = new Properties(this.internalProperties);
            InputStream localPropertiesStream = this.getLocalPropertiesStream();
            if (localPropertiesStream != null) {
                this.localProperties.load(localPropertiesStream);
                localPropertiesStream.close();
            }
        }
        catch (Throwable th) {
            this.localProperties = new Properties(this.internalProperties);
        }
    }

    private InputStream getLocalPropertiesStream() throws FileNotFoundException {
        if (this.propertiesFile.exists()) {
            return new FileInputStream(this.propertiesFile);
        }
        return LiteLoaderBootstrap.class.getResourceAsStream("/liteloader.properties");
    }

    @Override
    public void writeProperties() {
        try {
            this.localProperties.store(new FileWriter(this.propertiesFile), String.format("Properties for LiteLoader %s", new Object[]{LiteLoaderVersion.CURRENT}));
        }
        catch (Throwable th) {
            LiteLoaderLogger.warning(th, "Error writing liteloader properties", new Object[0]);
        }
    }

    private void prepareBranding() {
        this.branding = this.internalProperties.getProperty("brand", null);
        if (this.branding != null && this.branding.length() < 1) {
            this.branding = null;
        }
        if (this.branding != null) {
            this.localProperties.setProperty("brand", this.branding);
        } else {
            this.localProperties.remove("brand");
        }
    }

    @Override
    public File getGameDirectory() {
        return this.gameDirectory;
    }

    @Override
    public File getAssetsDirectory() {
        return this.assetsDirectory;
    }

    @Override
    public String getProfile() {
        return this.profile;
    }

    @Override
    public File getModsFolder() {
        return this.modsFolder;
    }

    @Override
    public File getVersionedModsFolder() {
        return this.versionedModsFolder;
    }

    @Override
    public File getConfigBaseFolder() {
        return this.configBaseFolder;
    }

    @Override
    public File getCommonConfigFolder() {
        return this.commonConfigFolder;
    }

    @Override
    public File getVersionedConfigFolder() {
        return this.versionConfigFolder;
    }

    @Override
    public boolean getAndStoreBooleanProperty(String propertyName, boolean defaultValue) {
        boolean result = this.localProperties.getProperty(propertyName, String.valueOf(defaultValue)).equalsIgnoreCase("true");
        this.localProperties.setProperty(propertyName, String.valueOf(result));
        return result;
    }

    @Override
    public boolean getBooleanProperty(String propertyName) {
        return this.localProperties.getProperty(propertyName, "false").equalsIgnoreCase("true");
    }

    @Override
    public void setBooleanProperty(String propertyName, boolean value) {
        this.localProperties.setProperty(propertyName, String.valueOf(value));
    }

    @Override
    public int getAndStoreIntegerProperty(String propertyName, int defaultValue) {
        int result = LiteLoaderBootstrap.tryParseInt(this.localProperties.getProperty(propertyName, String.valueOf(defaultValue)), defaultValue);
        this.localProperties.setProperty(propertyName, String.valueOf(result));
        return result;
    }

    @Override
    public int getIntegerProperty(String propertyName) {
        return LiteLoaderBootstrap.tryParseInt(this.localProperties.getProperty(propertyName, "0"), 0);
    }

    @Override
    public void setIntegerProperty(String propertyName, int value) {
        this.localProperties.setProperty(propertyName, String.valueOf(value));
    }

    @Override
    public void storeLastKnownModRevision(String modKey) {
        if (this.localProperties != null) {
            this.localProperties.setProperty(modKey, String.valueOf(LiteLoaderVersion.CURRENT.getLoaderRevision()));
            this.writeProperties();
        }
    }

    @Override
    public int getLastKnownModRevision(String modKey) {
        if (this.localProperties != null) {
            String storedRevision = this.localProperties.getProperty(modKey, "0");
            return Integer.parseInt(storedRevision);
        }
        return 0;
    }

    @Override
    public boolean loadTweaksEnabled() {
        return this.loadTweaks;
    }

    @Override
    public String getBranding() {
        return this.branding;
    }

    static void setBranding(String brand) {
        try {
            Method mGetClientModName;
            try {
                Class<?> cbrClass = Class.forName("net.minecraft.client.ClientBrandRetriever", false, (ClassLoader)Launch.classLoader);
                mGetClientModName = cbrClass.getDeclaredMethod("getClientModName", new Class[0]);
            }
            catch (ClassNotFoundException ex) {
                return;
            }
            String oldBrand = (String)mGetClientModName.invoke(null, new Object[0]);
            if (oldBrand.equals("vanilla")) {
                char[] newValue = brand.toCharArray();
                Field stringValue = String.class.getDeclaredField("value");
                stringValue.setAccessible(true);
                stringValue.set(oldBrand, newValue);
                try {
                    Field stringCount = String.class.getDeclaredField("count");
                    stringCount.setAccessible(true);
                    stringCount.set(oldBrand, newValue.length);
                }
                catch (NoSuchFieldException noSuchFieldException) {}
            }
        }
        catch (Throwable th) {
            LiteLoaderLogger.warning(th, "Setting branding failed", new Object[0]);
        }
    }

    @Override
    public List<String> getRequiredTransformers() {
        return this.apiAdapter.getRequiredTransformers();
    }

    @Override
    public List<String> getRequiredDownstreamTransformers() {
        return this.apiAdapter.getRequiredDownstreamTransformers();
    }

    @Override
    public List<String> getPacketTransformers() {
        return this.apiAdapter.getPacketTransformers();
    }

    private static int tryParseInt(String string, int defaultValue) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }
}

