/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.core;

import com.mumfrey.liteloader.ServerPluginChannelListener;
import com.mumfrey.liteloader.api.Listener;
import com.mumfrey.liteloader.core.InterfaceRegistrationDelegate;
import com.mumfrey.liteloader.core.LiteLoader;
import com.mumfrey.liteloader.core.PluginChannels;
import com.mumfrey.liteloader.core.event.HandlerList;
import com.mumfrey.liteloader.core.exceptions.UnregisteredChannelException;
import com.mumfrey.liteloader.interfaces.FastIterableDeque;
import com.mumfrey.liteloader.permissions.PermissionsManagerServer;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import java.util.LinkedList;

public class ServerPluginChannels
extends PluginChannels<ServerPluginChannelListener> {
    private static ServerPluginChannels instance;

    public ServerPluginChannels() {
        if (instance != null) {
            throw new RuntimeException("Plugin Channels Startup Error", new InstantiationException("Only a single instance of ServerPluginChannels is allowed"));
        }
        instance = this;
    }

    @Override
    protected FastIterableDeque<ServerPluginChannelListener> createHandlerList() {
        return new HandlerList<ServerPluginChannelListener>(ServerPluginChannelListener.class);
    }

    public static ServerPluginChannels getInstance() {
        return instance;
    }

    @Override
    public void initProvider() {
    }

    @Override
    public Class<? extends Listener> getListenerBaseType() {
        return Listener.class;
    }

    @Override
    public void registerInterfaces(InterfaceRegistrationDelegate delegate) {
        delegate.registerInterface(ServerPluginChannelListener.class);
    }

    void addServerPluginChannelListener(ServerPluginChannelListener pluginChannelListener) {
        super.addPluginChannelListener(pluginChannelListener);
    }

    void onServerStartup() {
        this.clearPluginChannels(null);
        for (ServerPluginChannelListener pluginChannelListener : this.pluginChannelListeners) {
            this.addPluginChannelsFor(pluginChannelListener);
        }
    }

    void onPlayerJoined(mw player) {
        this.sendRegisteredPluginChannels(player);
    }

    public void onPluginChannelMessage(fb netHandler, iz customPayload) {
        if (customPayload != null && customPayload.c() != null) {
            String channel = customPayload.c();
            byte[] data = customPayload.e();
            mw sender = ((nh)netHandler).b;
            this.onPluginChannelMessage(sender, channel, data);
        }
    }

    private final void onPluginChannelMessage(mw sender, String channel, byte[] data) {
        if ("REGISTER".equals(channel)) {
            this.onRegisterPacketReceived(data);
        } else if (this.pluginChannels.containsKey(channel)) {
            try {
                PermissionsManagerServer permissionsManager = LiteLoader.getServerPermissionsManager();
                if (permissionsManager != null) {
                    permissionsManager.onCustomPayload(sender, channel, data.length, data);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.onModPacketReceived(sender, channel, data, data.length);
        }
    }

    protected void onModPacketReceived(mw sender, String channel, byte[] data, int length) {
        for (ServerPluginChannelListener pluginChannelListener : (LinkedList)this.pluginChannels.get(channel)) {
            try {
                pluginChannelListener.onCustomPayload(sender, channel, length, data);
                throw new RuntimeException();
            }
            catch (Exception ex) {
                int failCount = 1;
                if (this.faultingPluginChannelListeners.containsKey(pluginChannelListener)) {
                    failCount = (Integer)this.faultingPluginChannelListeners.get(pluginChannelListener) + 1;
                }
                if (failCount >= 1000) {
                    LiteLoaderLogger.warning("Plugin channel listener %s exceeded fault threshold on channel %s with %s", pluginChannelListener.getName(), channel, ex.getClass().getSimpleName());
                    this.faultingPluginChannelListeners.remove(pluginChannelListener);
                    continue;
                }
                this.faultingPluginChannelListeners.put(pluginChannelListener, failCount);
            }
        }
    }

    protected void sendRegisteredPluginChannels(mw player) {
        try {
            byte[] registrationData = this.getRegistrationData();
            if (registrationData != null) {
                this.sendRegistrationData(player, registrationData);
            }
        }
        catch (Exception ex) {
            LiteLoaderLogger.warning(ex, "Error dispatching REGISTER packet to client %s", player.b_());
        }
    }

    private void sendRegistrationData(mw recipient, byte[] registrationData) {
        ServerPluginChannels.dispatch(recipient, new gr("REGISTER", registrationData));
    }

    public static boolean sendMessage(mw recipient, String channel, byte[] data, PluginChannels.ChannelPolicy policy) {
        if (instance != null) {
            return instance.send(recipient, channel, data, policy);
        }
        return false;
    }

    private boolean send(mw recipient, String channel, byte[] data, PluginChannels.ChannelPolicy policy) {
        if (recipient == null) {
            return false;
        }
        if (channel == null || channel.length() > 16 || "REGISTER".equals(channel) || "UNREGISTER".equals(channel)) {
            throw new RuntimeException("Invalid channel name specified");
        }
        if (!policy.allows(this, channel)) {
            if (policy.isSilent()) {
                return false;
            }
            throw new UnregisteredChannelException(channel);
        }
        gr payload = new gr(channel, data);
        return ServerPluginChannels.dispatch(recipient, payload);
    }

    static boolean dispatch(mw recipient, gr payload) {
        try {
            if (recipient != null && recipient.a != null) {
                recipient.a.a((ft)payload);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

