/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.versioning;

import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.ComparableVersion;
import cpw.mods.fml.common.versioning.VersionRange;

public class DefaultArtifactVersion
implements ArtifactVersion {
    private ComparableVersion comparableVersion;
    private String label;
    private boolean unbounded;
    private VersionRange range;

    public DefaultArtifactVersion(String versionNumber) {
        this.comparableVersion = new ComparableVersion(versionNumber);
        this.range = VersionRange.createFromVersion(versionNumber, this);
    }

    public DefaultArtifactVersion(String label, VersionRange range) {
        this.label = label;
        this.range = range;
    }

    public DefaultArtifactVersion(String label, String version) {
        this(version);
        this.label = label;
    }

    public DefaultArtifactVersion(String string, boolean unbounded) {
        this.label = string;
        this.unbounded = true;
    }

    public boolean equals(Object obj) {
        return ((DefaultArtifactVersion)obj).containsVersion(this);
    }

    @Override
    public int compareTo(ArtifactVersion o) {
        return this.unbounded ? 0 : this.comparableVersion.compareTo(((DefaultArtifactVersion)o).comparableVersion);
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public boolean containsVersion(ArtifactVersion source) {
        if (!source.getLabel().equals(this.getLabel())) {
            return false;
        }
        if (this.unbounded) {
            return true;
        }
        if (this.range != null) {
            return this.range.containsVersion(source);
        }
        return false;
    }

    @Override
    public String getVersionString() {
        return this.comparableVersion == null ? brp.a((String)"adv.fml.format.version.unknown", (Object[])new Object[0]) : this.comparableVersion.toString();
    }

    @Override
    public String getRangeString() {
        return this.range == null ? brp.a((String)"adv.fml.format.version.any", (Object[])new Object[0]) : this.range.toString();
    }

    public String toString() {
        return this.label == null ? this.comparableVersion.toString() : this.label + (this.unbounded ? "" : "@" + this.range);
    }

    public VersionRange getRange() {
        return this.range;
    }
}

