/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.core.api;

import com.mumfrey.liteloader.api.EnumeratorModule;
import com.mumfrey.liteloader.common.LoadingProgress;
import com.mumfrey.liteloader.core.LiteLoaderVersion;
import com.mumfrey.liteloader.core.api.LiteLoaderCoreAPI;
import com.mumfrey.liteloader.core.api.LoadableModFile;
import com.mumfrey.liteloader.interfaces.LoadableFile;
import com.mumfrey.liteloader.interfaces.LoadableMod;
import com.mumfrey.liteloader.interfaces.ModularEnumerator;
import com.mumfrey.liteloader.interfaces.TweakContainer;
import com.mumfrey.liteloader.launch.LoaderEnvironment;
import com.mumfrey.liteloader.launch.LoaderProperties;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.launchwrapper.LaunchClassLoader;

public class EnumeratorModuleFolder
implements FilenameFilter,
EnumeratorModule {
    protected final Map<String, TreeSet<LoadableMod<File>>> versionOrderingSets = new HashMap<String, TreeSet<LoadableMod<File>>>();
    protected final List<LoadableMod<File>> loadableMods = new ArrayList<LoadableMod<File>>();
    protected LiteLoaderCoreAPI coreAPI;
    protected File directory;
    protected boolean readZipFiles;
    protected boolean readJarFiles;
    protected boolean loadTweaks;
    private final boolean requireMetaData;

    public EnumeratorModuleFolder(LiteLoaderCoreAPI coreAPI, File directory, boolean requireMetaData) {
        this.coreAPI = coreAPI;
        this.directory = directory;
        this.requireMetaData = requireMetaData;
    }

    @Override
    public void init(LoaderEnvironment environment, LoaderProperties properties) {
        this.loadTweaks = properties.loadTweaksEnabled();
        this.readZipFiles = properties.getAndStoreBooleanProperty("search.zipfiles", false);
        this.readJarFiles = properties.getAndStoreBooleanProperty("search.jarfiles", true);
        this.coreAPI.writeDiscoverySettings();
    }

    @Override
    public void writeSettings(LoaderEnvironment environment, LoaderProperties properties) {
        properties.setBooleanProperty("search.zipfiles", this.readZipFiles);
        properties.setBooleanProperty("search.jarfiles", this.readJarFiles);
    }

    public String toString() {
        return this.directory.getAbsolutePath();
    }

    public File getDirectory() {
        return this.directory;
    }

    public List<LoadableMod<File>> getLoadableMods() {
        return this.loadableMods;
    }

    @Override
    public boolean accept(File dir, String fileName) {
        if ((fileName = fileName.toLowerCase()).endsWith(".litemod.zip") && !this.readZipFiles) {
            LiteLoaderLogger.warning("Found %s with unsupported extension .litemod.zip. Please change file extension to .litemod to allow this file to be loaded!", fileName);
        }
        return fileName.endsWith(".litemod") || this.readZipFiles && fileName.endsWith(".zip") || this.readJarFiles && fileName.endsWith(".jar");
    }

    @Override
    public void enumerate(ModularEnumerator enumerator, String profile) {
        if (this.directory.exists() && this.directory.isDirectory()) {
            LiteLoaderLogger.info("Discovering valid mod files in folder %s", this.directory.getPath());
            this.findValidFiles(enumerator);
            this.sortAndAllocateFiles(enumerator);
            this.versionOrderingSets.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findValidFiles(ModularEnumerator enumerator) {
        for (File candidateFile : this.directory.listFiles(this.getFilenameFilter())) {
            ZipFile candidateZip = null;
            try {
                candidateZip = new ZipFile(candidateFile);
                ZipEntry versionEntry = candidateZip.getEntry("litemod.json");
                ZipEntry legacyVersionEntry = candidateZip.getEntry("version.txt");
                if (versionEntry != null) {
                    String strVersion = null;
                    try {
                        strVersion = LoadableModFile.zipEntryToString(candidateZip, versionEntry);
                    }
                    catch (IOException ex) {
                        LiteLoaderLogger.warning("Error reading version data from %s", candidateZip.getName());
                    }
                    if (strVersion == null) continue;
                    this.addModFile(candidateFile, strVersion);
                    continue;
                }
                if (legacyVersionEntry != null) {
                    LiteLoaderLogger.warning("%s is no longer supported, ignoring outdated mod file: %s", "version.txt", candidateFile.getAbsolutePath());
                    continue;
                }
                if (this.requireMetaData || !this.loadTweaks || !this.readJarFiles || !candidateFile.getName().toLowerCase().endsWith(".jar")) continue;
                LoadableFile container = new LoadableFile(candidateFile);
                enumerator.registerTweakContainer(container);
            }
            catch (Exception ex) {
                LiteLoaderLogger.info("Error enumerating '%s': Invalid zip file or error reading file", candidateFile.getAbsolutePath());
            }
            finally {
                if (candidateZip != null) {
                    try {
                        candidateZip.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    protected FilenameFilter getFilenameFilter() {
        return this;
    }

    protected boolean isFileSupported(LoadableModFile modFile) {
        return LiteLoaderVersion.CURRENT.isVersionSupported(modFile.getTargetVersion());
    }

    private void addModFile(File candidateFile, String strVersion) {
        LoadableModFile modFile = new LoadableModFile(candidateFile, strVersion);
        if (modFile.hasValidMetaData()) {
            if (this.isFileSupported(modFile)) {
                if (!this.versionOrderingSets.containsKey(modFile.getName())) {
                    this.versionOrderingSets.put(modFile.getModName(), new TreeSet());
                }
                LiteLoaderLogger.info("Considering valid mod file: %s", modFile.getAbsolutePath());
                this.versionOrderingSets.get(modFile.getModName()).add(modFile);
            } else {
                LiteLoaderLogger.info("Not adding invalid or outdated mod file: %s", candidateFile.getAbsolutePath());
            }
        }
    }

    private void sortAndAllocateFiles(ModularEnumerator enumerator) {
        for (Map.Entry<String, TreeSet<LoadableMod<File>>> modFileEntry : this.versionOrderingSets.entrySet()) {
            LoadableMod<File> newestVersion = modFileEntry.getValue().iterator().next();
            if (enumerator.registerModContainer(newestVersion)) {
                LiteLoaderLogger.info("Adding newest valid mod file '%s' at revision %.4f", newestVersion.getLocation(), Float.valueOf(newestVersion.getRevision()));
                this.loadableMods.add(newestVersion);
            } else {
                LiteLoaderLogger.info("Not adding valid mod file '%s', the specified mod is disabled or missing a required dependency", newestVersion.getLocation());
            }
            if (!this.loadTweaks) continue;
            try {
                if (!(newestVersion instanceof TweakContainer)) continue;
                enumerator.registerTweakContainer((TweakContainer)((Object)newestVersion));
            }
            catch (Throwable th) {
                LiteLoaderLogger.warning("Error adding tweaks from '%s'", newestVersion.getLocation());
            }
        }
    }

    @Override
    public void injectIntoClassLoader(ModularEnumerator enumerator, LaunchClassLoader classLoader) {
        LiteLoaderLogger.info("Injecting external mods into class path...", new Object[0]);
        for (LoadableMod<File> loadableMod : this.loadableMods) {
            try {
                if (!loadableMod.injectIntoClassPath(classLoader, false)) continue;
                LiteLoaderLogger.info("Successfully injected mod file '%s' into classpath", loadableMod.getLocation());
            }
            catch (MalformedURLException ex) {
                LiteLoaderLogger.warning("Error injecting '%s' into classPath. The mod will not be loaded", loadableMod.getLocation());
            }
        }
    }

    @Override
    public void registerMods(ModularEnumerator enumerator, LaunchClassLoader classLoader) {
        LiteLoaderLogger.info("Discovering mods in valid mod files...", new Object[0]);
        LoadingProgress.incTotalLiteLoaderProgress(this.loadableMods.size());
        for (LoadableMod<File> modFile : this.loadableMods) {
            LoadingProgress.incLiteLoaderProgress("Searching for mods in " + modFile.getModName() + "...");
            LiteLoaderLogger.info("Searching %s...", modFile.getLocation());
            try {
                enumerator.registerModsFrom(modFile, true);
            }
            catch (Exception ex) {
                LiteLoaderLogger.warning("Error encountered whilst searching in %s...", modFile.getLocation());
            }
        }
    }
}

