/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.core.event;

import com.mumfrey.liteloader.core.runtime.Obf;
import com.mumfrey.liteloader.interfaces.FastIterableDeque;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class HandlerList<T>
extends LinkedList<T>
implements FastIterableDeque<T> {
    private static final long serialVersionUID = 1L;
    private static final int MAX_UNCOLLECTED_CLASSES = 5000;
    private static int uncollectedHandlerLists = 0;
    private final Class<T> type;
    private final ReturnLogicOp logicOp;
    private BakedHandlerList<T> bakedHandler;

    public HandlerList(Class<T> type) {
        this(type, ReturnLogicOp.AND_BREAK_ON_FALSE);
    }

    public HandlerList(Class<T> type, ReturnLogicOp logicOp) {
        if (!type.isInterface()) {
            throw new IllegalArgumentException("HandlerList type argument must be an interface");
        }
        this.type = type;
        this.logicOp = logicOp;
    }

    @Override
    public T all() {
        if (this.bakedHandler == null) {
            this.bake();
        }
        return this.bakedHandler.get();
    }

    protected void bake() {
        HandlerListClassLoader<T> classLoader = new HandlerListClassLoader<T>(this.type, this.logicOp);
        this.bakedHandler = classLoader.newHandler(this);
        if (classLoader instanceof Closeable) {
            try {
                classLoader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void invalidate() {
        if (this.bakedHandler == null) {
            return;
        }
        this.bakedHandler = null;
        if (++uncollectedHandlerLists > 5000) {
            System.gc();
            uncollectedHandlerLists = 0;
        }
    }

    @Override
    public boolean add(T listener) {
        if (!this.contains(listener)) {
            super.add(listener);
            this.invalidate();
        }
        return true;
    }

    @Override
    public boolean offer(T listener) {
        return this.add(listener);
    }

    @Override
    public boolean offerFirst(T listener) {
        this.addFirst(listener);
        return true;
    }

    @Override
    public boolean offerLast(T listener) {
        this.addLast(listener);
        return true;
    }

    @Override
    public void add(int index, T listener) {
        if (!this.contains(listener)) {
            super.add(index, listener);
            this.invalidate();
        }
    }

    @Override
    public void addFirst(T listener) {
        if (!this.contains(listener)) {
            super.addFirst(listener);
            this.invalidate();
        }
    }

    @Override
    public void addLast(T listener) {
        if (!this.contains(listener)) {
            super.addLast(listener);
            this.invalidate();
        }
    }

    @Override
    public boolean addAll(Collection<? extends T> listeners) {
        for (T listener : listeners) {
            if (this.contains(listener)) continue;
            super.add(listener);
        }
        this.invalidate();
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> listeners) {
        throw new UnsupportedOperationException("'addAll' is not supported for HandlerList");
    }

    @Override
    public T remove() {
        return this.removeFirst();
    }

    @Override
    public T remove(int index) {
        Object removed = super.remove(index);
        this.invalidate();
        return (T)removed;
    }

    @Override
    public boolean remove(Object listener) {
        boolean removed = super.remove(listener);
        this.invalidate();
        return removed;
    }

    @Override
    public T removeFirst() {
        Object removed = super.removeFirst();
        this.invalidate();
        return (T)removed;
    }

    @Override
    public boolean removeFirstOccurrence(Object listener) {
        return this.remove(listener);
    }

    @Override
    public T removeLast() {
        Object removed = super.removeLast();
        this.invalidate();
        return (T)removed;
    }

    @Override
    public boolean removeLastOccurrence(Object listener) {
        boolean removed = super.removeLastOccurrence(listener);
        this.invalidate();
        return removed;
    }

    @Override
    public boolean removeAll(Collection<?> listeners) {
        boolean removed = super.removeAll(listeners);
        this.invalidate();
        return removed;
    }

    @Override
    public T poll() {
        Object polled = super.poll();
        this.invalidate();
        return (T)polled;
    }

    @Override
    public T pollFirst() {
        Object polled = super.pollFirst();
        this.invalidate();
        return (T)polled;
    }

    @Override
    public T pollLast() {
        Object polled = super.pollLast();
        this.invalidate();
        return (T)polled;
    }

    @Override
    public void push(T listener) {
        this.addFirst(listener);
    }

    @Override
    public T pop() {
        return this.removeFirst();
    }

    @Override
    public T set(int index, T listener) {
        T oldValue = null;
        if (!this.contains(listener)) {
            oldValue = super.set(index, listener);
            this.invalidate();
        }
        return oldValue;
    }

    static class HandlerListClassLoader<T>
    extends URLClassLoader {
        private static final String HANDLER_VAR_PREFIX = "handler$";
        private static int handlerIndex;
        private final Class<T> type;
        private final String typeRef;
        private final ReturnLogicOp logicOp;
        private int size;

        HandlerListClassLoader(Class<T> type, ReturnLogicOp logicOp) {
            super(new URL[0], (ClassLoader)Launch.classLoader);
            this.type = type;
            this.typeRef = type.getName().replace('.', '/');
            this.logicOp = logicOp;
        }

        public BakedHandlerList<T> newHandler(HandlerList<T> list) {
            this.size = list.size();
            Class<BakedHandlerList<T>> handlerClass = null;
            try {
                String className = HandlerListClassLoader.getNextClassName(Obf.HandlerList.name, this.type.getSimpleName());
                handlerClass = this.loadClass(className);
            }
            catch (ClassNotFoundException ex) {
                throw new BakingFailedException(ex);
            }
            try {
                BakedHandlerList<T> handlerList = this.createInstance(handlerClass);
                return handlerList.populate(list);
            }
            catch (InstantiationException ex) {
                throw new BakingFailedException(ex);
            }
        }

        private BakedHandlerList<T> createInstance(Class<BakedHandlerList<T>> handlerClass) throws InstantiationException {
            try {
                Constructor<BakedHandlerList<T>> ctor = handlerClass.getDeclaredConstructor(new Class[0]);
                ctor.setAccessible(true);
                return ctor.newInstance(new Object[0]);
            }
            catch (Exception ex) {
                InstantiationException ie = new InstantiationException("Error instantiating class " + handlerClass);
                ie.setStackTrace(ex.getStackTrace());
                throw ie;
            }
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            try {
                byte[] bytes = Launch.classLoader.getClassBytes(Obf.BakedHandlerList.name);
                ClassReader classReader = new ClassReader(bytes);
                ClassNode classNode = new ClassNode();
                classReader.accept((ClassVisitor)classNode, 8);
                this.transform(name, classNode);
                ClassWriter classWriter = new ClassWriter(classReader, 3);
                classNode.accept((ClassVisitor)classWriter);
                bytes = classWriter.toByteArray();
                return this.defineClass(name, bytes, 0, bytes.length);
            }
            catch (Throwable th) {
                th.printStackTrace();
                return null;
            }
        }

        private void transform(String name, ClassNode classNode) throws IOException {
            LiteLoaderLogger.info("Baking listener list for %s with %d listeners", this.type.getSimpleName(), this.size);
            LiteLoaderLogger.debug("Generating: %s", name);
            this.populateClass(name, classNode);
            this.transformMethods(name, classNode);
            this.injectInterfaceMethods(classNode, this.type.getName());
        }

        private void populateClass(String name, ClassNode classNode) {
            classNode.access &= 0xFFFFFBFF;
            classNode.name = name.replace('.', '/');
            classNode.superName = Obf.BakedHandlerList.ref;
            classNode.interfaces.add(this.typeRef);
            classNode.sourceFile = name.substring(name.lastIndexOf(46) + 1) + ".java";
            for (int handlerIndex = 0; handlerIndex < this.size; ++handlerIndex) {
                classNode.fields.add(new FieldNode(2, HANDLER_VAR_PREFIX + handlerIndex, "L" + this.typeRef + ";", null, null));
            }
        }

        private void transformMethods(String name, ClassNode classNode) {
            for (MethodNode method : classNode.methods) {
                if (Obf.constructor.name.equals(method.name)) {
                    this.processCtor(classNode, method);
                    continue;
                }
                if ("get".equals(method.name)) {
                    this.processGet(classNode, method);
                    continue;
                }
                if (!"populate".equals(method.name)) continue;
                this.processPopulate(classNode, method);
            }
        }

        private void processCtor(ClassNode classNode, MethodNode method) {
            for (AbstractInsnNode insn : method.instructions) {
                if (!(insn instanceof MethodInsnNode)) continue;
                MethodInsnNode methodInsn = (MethodInsnNode)insn;
                if (!methodInsn.owner.equals("java/lang/Object")) continue;
                methodInsn.owner = Obf.BakedHandlerList.ref;
            }
        }

        private void processGet(ClassNode classNode, MethodNode method) {
            method.access &= 0xFFFFFBFF;
            method.instructions.clear();
            method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            method.instructions.add((AbstractInsnNode)new InsnNode(176));
            method.maxStack = 1;
            method.maxLocals = 1;
        }

        private void processPopulate(ClassNode classNode, MethodNode method) {
            method.access &= 0xFFFFFBFF;
            method.instructions.clear();
            for (int handlerIndex = 0; handlerIndex < this.size; ++handlerIndex) {
                method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
                method.instructions.add((AbstractInsnNode)(handlerIndex > Short.MAX_VALUE ? new LdcInsnNode((Object)new Integer(handlerIndex)) : new IntInsnNode(17, handlerIndex)));
                method.instructions.add((AbstractInsnNode)new MethodInsnNode(185, "java/util/List", "get", "(I)Ljava/lang/Object;", true));
                method.instructions.add((AbstractInsnNode)new TypeInsnNode(192, this.typeRef));
                method.instructions.add((AbstractInsnNode)new FieldInsnNode(181, classNode.name, HANDLER_VAR_PREFIX + handlerIndex, "L" + this.typeRef + ";"));
            }
            method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            method.instructions.add((AbstractInsnNode)new InsnNode(176));
            method.maxStack = 3;
            method.maxLocals = 2;
        }

        private void injectInterfaceMethods(ClassNode classNode, String interfaceName) throws IOException {
            ClassReader interfaceReader = new ClassReader(HandlerListClassLoader.getInterfaceBytes(interfaceName));
            ClassNode interfaceNode = new ClassNode();
            interfaceReader.accept((ClassVisitor)interfaceNode, 0);
            for (MethodNode interfaceMethod : interfaceNode.methods) {
                classNode.methods.add(interfaceMethod);
                this.populateInterfaceMethod(classNode, interfaceMethod);
            }
            for (String parentInterface : interfaceNode.interfaces) {
                this.injectInterfaceMethods(classNode, parentInterface.replace('/', '.'));
            }
        }

        private void populateInterfaceMethod(ClassNode classNode, MethodNode method) {
            Type returnType = Type.getReturnType((String)method.desc);
            Type[] args = Type.getArgumentTypes((String)method.desc);
            if (returnType.equals((Object)Type.BOOLEAN_TYPE)) {
                method.access = 1;
                this.populateBooleanInvokationChain(classNode, method, args);
            } else {
                method.access = 1;
                this.populateVoidInvokationChain(classNode, method, args, returnType);
            }
        }

        private void populateVoidInvokationChain(ClassNode classNode, MethodNode method, Type[] args, Type returnType) {
            int returnSize = returnType.getSize();
            for (int handlerIndex = 0; handlerIndex < this.size; ++handlerIndex) {
                this.invokeHandler(handlerIndex, classNode, method, args);
                if (returnSize <= 0) continue;
                method.instructions.add((AbstractInsnNode)new InsnNode(returnSize == 1 ? 87 : 88));
            }
            if (returnSize > 0) {
                if (returnType.getSort() == 10) {
                    method.instructions.add((AbstractInsnNode)new InsnNode(1));
                } else if (returnSize == 1) {
                    method.instructions.add((AbstractInsnNode)new InsnNode(3));
                } else if (returnSize == 2) {
                    method.instructions.add((AbstractInsnNode)new InsnNode(14));
                }
            }
            method.instructions.add((AbstractInsnNode)new InsnNode(returnType.getOpcode(172)));
            method.maxLocals = args.length + 1;
            method.maxStack = args.length + 1;
        }

        private void populateBooleanInvokationChain(ClassNode classNode, MethodNode method, Type[] args) {
            boolean isOrOperation = this.logicOp.isOr();
            boolean breakOnMatch = this.logicOp.breakOnMatch();
            int initialValue = isOrOperation && (!this.logicOp.assumeTrue() || this.size > 0) ? 3 : 4;
            int localIndex = this.getFirstLocalIndex(args);
            method.instructions.add((AbstractInsnNode)new InsnNode(initialValue));
            method.instructions.add((AbstractInsnNode)new VarInsnNode(54, localIndex));
            for (int handlerIndex = 0; handlerIndex < this.size; ++handlerIndex) {
                this.invokeHandler(handlerIndex, classNode, method, args);
                int jumpCondition = isOrOperation ? 153 : 154;
                int semaphore = isOrOperation ? 4 : 3;
                LabelNode lbl = new LabelNode();
                method.instructions.add((AbstractInsnNode)new JumpInsnNode(jumpCondition, lbl));
                method.instructions.add((AbstractInsnNode)new InsnNode(semaphore));
                method.instructions.add((AbstractInsnNode)(breakOnMatch ? new InsnNode(172) : new VarInsnNode(54, localIndex)));
                method.instructions.add((AbstractInsnNode)lbl);
            }
            method.instructions.add((AbstractInsnNode)new VarInsnNode(21, localIndex));
            method.instructions.add((AbstractInsnNode)new InsnNode(172));
            method.maxLocals = args.length + 2;
            method.maxStack = args.length + 1;
        }

        private int invokeHandler(int handlerIndex, ClassNode classNode, MethodNode method, Type[] args) {
            LabelNode lineNumberLabel = new LabelNode(new Label());
            method.instructions.add((AbstractInsnNode)lineNumberLabel);
            method.instructions.add((AbstractInsnNode)new LineNumberNode(100 + handlerIndex, lineNumberLabel));
            method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            method.instructions.add((AbstractInsnNode)new FieldInsnNode(180, classNode.name, HANDLER_VAR_PREFIX + handlerIndex, "L" + this.typeRef + ";"));
            return this.invokeInterfaceMethod(method, args);
        }

        private int invokeInterfaceMethod(MethodNode method, Type[] args) {
            int argNumber = 1;
            for (Type type : args) {
                method.instructions.add((AbstractInsnNode)new VarInsnNode(type.getOpcode(21), argNumber));
                argNumber += type.getSize();
            }
            method.instructions.add((AbstractInsnNode)new MethodInsnNode(185, this.typeRef, method.name, method.desc, true));
            return argNumber;
        }

        private int getFirstLocalIndex(Type[] args) {
            int argNumber = 1;
            for (Type type : args) {
                argNumber += type.getSize();
            }
            return argNumber;
        }

        private static String getNextClassName(String baseName, String typeName) {
            return String.format("%s$%s%d", baseName, typeName, handlerIndex++);
        }

        private static byte[] getInterfaceBytes(String name) throws IOException {
            byte[] bytes = Launch.classLoader.getClassBytes(name);
            for (IClassTransformer transformer : Launch.classLoader.getTransformers()) {
                bytes = transformer.transform(name, name, bytes);
            }
            return bytes;
        }
    }

    static class BakingFailedException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public BakingFailedException(Throwable cause) {
            super("An unexpected error occurred while baking the handler list", cause);
        }
    }

    public static abstract class BakedHandlerList<T> {
        public abstract T get();

        public abstract BakedHandlerList<T> populate(List<T> var1);
    }

    public static enum ReturnLogicOp {
        OR(true, false),
        OR_BREAK_ON_TRUE(true, true),
        OR_ASSUME_TRUE(true, false, true),
        AND(false, false),
        AND_BREAK_ON_FALSE(false, true);

        private final boolean isOr;
        private final boolean breakOnMatch;
        private final boolean assumeTrue;

        private ReturnLogicOp(boolean isOr, boolean breakOnMatch) {
            this(isOr, breakOnMatch, false);
        }

        private ReturnLogicOp(boolean isOr, boolean breakOnMatch, boolean assumeTrue) {
            this.isOr = isOr;
            this.breakOnMatch = breakOnMatch;
            this.assumeTrue = assumeTrue;
        }

        boolean isOr() {
            return this.isOr;
        }

        public boolean breakOnMatch() {
            return this.breakOnMatch;
        }

        boolean assumeTrue() {
            return this.assumeTrue;
        }
    }
}

