/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia;

import committee.nova.mods.avaritia.Const;
import committee.nova.mods.avaritia.common.crafting.recipe.CompressorRecipe;
import committee.nova.mods.avaritia.common.crafting.recipe.ShapelessTableCraftingRecipe;
import committee.nova.mods.avaritia.core.singularity.Singularity;
import committee.nova.mods.avaritia.core.singularity.SingularityBuilder;
import committee.nova.mods.avaritia.core.singularity.SingularityDataManager;
import committee.nova.mods.avaritia.util.SingularityUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class ModApi {
    @ApiStatus.AvailableSince(value="1.3.9.0")
    public static ShapelessTableCraftingRecipe addModShapelessRecipe(ItemStack result, List<ItemStack> ingredients, int tier) {
        UUID uuid = UUID.randomUUID();
        ArrayList<ItemStack> arraylist = new ArrayList<ItemStack>();
        for (ItemStack stack : ingredients) {
            if (stack != null) {
                arraylist.add(stack.m_41777_());
                continue;
            }
            throw new RuntimeException("Invalid shapeless recipes!");
        }
        return new ShapelessTableCraftingRecipe(Const.rl(uuid.toString()), ModApi.getList(arraylist), result, tier);
    }

    private static NonNullList<Ingredient> getList(List<ItemStack> arrayList) {
        NonNullList ingredients = NonNullList.m_122779_();
        for (ItemStack stack : arrayList) {
            ingredients.add((Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack}));
        }
        return ingredients;
    }

    @ApiStatus.AvailableSince(value="1.3.9.2")
    public static CompressorRecipe addSingularityRecipe(Singularity singularity) {
        Ingredient ingredient = singularity.getIngredient();
        if (ingredient == Ingredient.f_43901_) {
            return null;
        }
        ResourceLocation id = singularity.getId();
        ResourceLocation recipeId = new ResourceLocation(id.m_135827_(), id.m_135815_() + "_singularity");
        ItemStack output = SingularityUtils.getItemForSingularity(singularity);
        int ingredientCount = singularity.getIngredientCount();
        int timeRequired = singularity.getTimeRequired();
        return new CompressorRecipe(recipeId, ingredient, output, ingredientCount, timeRequired);
    }

    @ApiStatus.AvailableSince(value="1.3.9.3")
    public static Singularity registerSingularity(@NotNull String modId, @NotNull String name, @NotNull Consumer<SingularityBuilder> builder) {
        SingularityBuilder singularityBuilder = new SingularityBuilder(modId, name);
        builder.accept(singularityBuilder);
        Singularity singularity = singularityBuilder.build();
        SingularityDataManager manager = SingularityDataManager.getInstance();
        if (manager.isInitialized()) {
            manager.registerRuntimeSingularity(singularity);
        }
        return singularity;
    }
}

