/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.api.client.model;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import committee.nova.mods.avaritia.api.client.model.CachedFormat;
import committee.nova.mods.avaritia.api.client.model.IVertexConsumer;
import committee.nova.mods.avaritia.api.client.model.IVertexProducer;
import committee.nova.mods.avaritia.api.client.util.VertexUtils;
import committee.nova.mods.avaritia.api.util.math.InterpHelper;
import committee.nova.mods.avaritia.api.util.math.MathUtils;
import committee.nova.mods.avaritia.api.util.vec.Cuboid6;
import committee.nova.mods.avaritia.api.util.vec.Vector3;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;

public class Quad
implements IVertexProducer,
IVertexConsumer {
    private final Vector3 v1 = new Vector3();
    private final Vector3 v2 = new Vector3();
    private final Vector3 t = new Vector3();
    private final Cuboid6 c = new Cuboid6();
    public CachedFormat format;
    public int tintIndex = -1;
    public Direction orientation;
    public boolean diffuseLighting = true;
    public TextureAtlasSprite sprite;
    public Vertex[] vertices = new Vertex[4];
    public boolean full;
    private int vertexIndex = 0;

    public Quad() {
    }

    public Quad(CachedFormat format) {
        this.format = format;
    }

    @Override
    public VertexFormat getVertexFormat() {
        return this.format.format;
    }

    @Override
    public void setQuadTint(int tint) {
        this.tintIndex = tint;
    }

    @Override
    public void setQuadOrientation(Direction orientation) {
        this.orientation = orientation;
    }

    @Override
    public void setApplyDiffuseLighting(boolean diffuse) {
        this.diffuseLighting = diffuse;
    }

    @Override
    public void setTexture(TextureAtlasSprite texture) {
        this.sprite = texture;
    }

    @Override
    public void put(int element, float ... data) {
        if (this.full) {
            throw new RuntimeException("Unable to add data when full.");
        }
        Vertex v = this.vertices[this.vertexIndex];
        if (v == null) {
            this.vertices[this.vertexIndex] = v = new Vertex(this.format);
        }
        System.arraycopy(data, 0, v.raw[element], 0, data.length);
        if (element == this.format.elementCount - 1) {
            ++this.vertexIndex;
            if (this.vertexIndex == 4) {
                this.vertexIndex = 0;
                this.full = true;
                if (this.orientation == null) {
                    this.calculateOrientation(false);
                }
            }
        }
    }

    @Override
    public void put(Quad quad) {
        this.copyFrom(quad);
    }

    @Override
    public void pipe(IVertexConsumer consumer) {
        if (consumer instanceof IVertexConsumer) {
            consumer.put(this);
        } else {
            consumer.setQuadTint(this.tintIndex);
            consumer.setQuadOrientation(this.orientation);
            consumer.setApplyDiffuseLighting(this.diffuseLighting);
            consumer.setTexture(this.sprite);
            for (Vertex v : this.vertices) {
                for (int e = 0; e < this.format.elementCount; ++e) {
                    consumer.put(e, v.raw[e]);
                }
            }
        }
    }

    public InterpHelper resetInterp(InterpHelper helper, int s) {
        helper.reset(this.vertices[0].dx(s), this.vertices[0].dy(s), this.vertices[1].dx(s), this.vertices[1].dy(s), this.vertices[2].dx(s), this.vertices[2].dy(s), this.vertices[3].dx(s), this.vertices[3].dy(s));
        return helper;
    }

    public void clamp(AABB bb) {
        this.clamp(this.c.set(bb));
    }

    public void clamp(Cuboid6 cuboid) {
        for (Vertex vertex : this.vertices) {
            float[] vec = vertex.vec;
            vec[0] = (float)MathUtils.clip((double)vec[0], cuboid.min.x, cuboid.max.x);
            vec[1] = (float)MathUtils.clip((double)vec[1], cuboid.min.y, cuboid.max.y);
            vec[2] = (float)MathUtils.clip((double)vec[2], cuboid.min.z, cuboid.max.z);
        }
        this.calculateOrientation(true);
    }

    public void calculateOrientation(boolean setNormal) {
        this.v1.set(this.vertices[3].vec).subtract(this.t.set(this.vertices[1].vec));
        this.v2.set(this.vertices[2].vec).subtract(this.t.set(this.vertices[0].vec));
        Vector3 normal = this.v2.crossProduct(this.v1).normalize();
        if (this.format.hasNormal && setNormal) {
            for (Vertex vertex : this.vertices) {
                vertex.normal[0] = (float)normal.x;
                vertex.normal[1] = (float)normal.y;
                vertex.normal[2] = (float)normal.z;
                vertex.normal[3] = 0.0f;
            }
        }
        this.orientation = Direction.m_122366_((double)normal.x, (double)normal.y, (double)normal.z);
    }

    public Quad copy() {
        if (!this.full) {
            throw new RuntimeException("Only copying full quads is supported.");
        }
        Quad quad = new Quad(this.format);
        quad.tintIndex = this.tintIndex;
        quad.orientation = this.orientation;
        quad.diffuseLighting = this.diffuseLighting;
        quad.sprite = this.sprite;
        quad.full = true;
        for (int i = 0; i < 4; ++i) {
            quad.vertices[i] = this.vertices[i].copy();
        }
        return quad;
    }

    public Quad copyFrom(Quad quad) {
        this.tintIndex = quad.tintIndex;
        this.orientation = quad.orientation;
        this.diffuseLighting = quad.diffuseLighting;
        this.sprite = quad.sprite;
        this.full = quad.full;
        for (int v = 0; v < 4; ++v) {
            for (int e = 0; e < this.format.elementCount; ++e) {
                System.arraycopy(quad.vertices[v].raw[e], 0, this.vertices[v].raw[e], 0, 4);
            }
        }
        return this;
    }

    public void reset(CachedFormat format) {
        this.format = format;
        this.tintIndex = -1;
        this.orientation = null;
        this.diffuseLighting = true;
        this.sprite = null;
        for (int i = 0; i < this.vertices.length; ++i) {
            Vertex v = this.vertices[i];
            if (v == null) {
                this.vertices[i] = v = new Vertex(format);
            }
            v.reset(format);
        }
        this.vertexIndex = 0;
        this.full = false;
    }

    public void rewind() {
        this.vertexIndex = 0;
        this.full = false;
    }

    public BakedQuad bake() {
        int[] packedData = new int[this.format.format.m_86020_()];
        for (int v = 0; v < 4; ++v) {
            for (int e = 0; e < this.format.elementCount; ++e) {
                VertexUtils.pack(this.vertices[v].raw[e], packedData, this.format.format, v, e);
            }
        }
        return this.makeQuad(packedData);
    }

    private BakedQuad makeQuad(int[] packedData) {
        if (this.format.format != DefaultVertexFormat.f_85811_) {
            throw new IllegalStateException("Unable to bake this quad to the specified format. " + this.format.format);
        }
        return new BakedQuad(packedData, this.tintIndex, this.orientation, this.sprite, this.diffuseLighting);
    }

    public static class Vertex {
        public CachedFormat format;
        public float[][] raw;
        public float[] vec;
        public float[] normal;
        public float[] color;
        public float[] uv;
        public float[] overlay;
        public float[] lightmap;

        public Vertex(CachedFormat format) {
            this.format = format;
            this.raw = new float[format.elementCount][4];
            this.preProcess();
        }

        public Vertex(Vertex other) {
            this.format = other.format;
            this.raw = (float[][])other.raw.clone();
            for (int v = 0; v < this.format.elementCount; ++v) {
                this.raw[v] = (float[])other.raw[v].clone();
            }
            this.preProcess();
        }

        public void preProcess() {
            if (this.format.hasPosition) {
                this.vec = this.raw[this.format.positionIndex];
            }
            if (this.format.hasNormal) {
                this.normal = this.raw[this.format.normalIndex];
            }
            if (this.format.hasColor) {
                this.color = this.raw[this.format.colorIndex];
            }
            if (this.format.hasUV) {
                this.uv = this.raw[this.format.uvIndex];
            }
            if (this.format.hasOverlay) {
                this.overlay = this.raw[this.format.overlayIndex];
            }
            if (this.format.hasLightMap) {
                this.lightmap = this.raw[this.format.lightMapIndex];
            }
        }

        public float dx(int s) {
            if (s <= 1) {
                return this.vec[0];
            }
            return this.vec[2];
        }

        public float dy(int s) {
            if (s > 0) {
                return this.vec[1];
            }
            return this.vec[2];
        }

        public Vertex interpColorFrom(InterpHelper interpHelper, Vertex[] others) {
            for (int e = 0; e < 4; ++e) {
                float p1 = others[0].color[e];
                float p2 = others[1].color[e];
                float p3 = others[2].color[e];
                float p4 = others[3].color[e];
                if (p1 == p2 && p2 == p3 && p3 == p4) continue;
                this.color[e] = interpHelper.interpolate(p1, p2, p3, p4);
            }
            return this;
        }

        public Vertex interpUVFrom(InterpHelper interpHelper, Vertex[] others) {
            for (int e = 0; e < 2; ++e) {
                float p1 = others[0].uv[e];
                float p2 = others[1].uv[e];
                float p3 = others[2].uv[e];
                float p4 = others[3].uv[e];
                if (p1 == p2 && p2 == p3 && p3 == p4) continue;
                this.uv[e] = interpHelper.interpolate(p1, p2, p3, p4);
            }
            return this;
        }

        public Vertex interpLightMapFrom(InterpHelper interpHelper, Vertex[] others) {
            for (int e = 0; e < 2; ++e) {
                float p1 = others[0].lightmap[e];
                float p2 = others[1].lightmap[e];
                float p3 = others[2].lightmap[e];
                float p4 = others[3].lightmap[e];
                if (p1 == p2 && p2 == p3 && p3 == p4) continue;
                this.lightmap[e] = interpHelper.interpolate(p1, p2, p3, p4);
            }
            return this;
        }

        public Vertex copy() {
            return new Vertex(this);
        }

        public void reset(CachedFormat format) {
            if (!this.format.equals(format) && format.elementCount > this.raw.length) {
                this.raw = new float[format.elementCount][4];
            }
            this.format = format;
            this.vec = null;
            this.normal = null;
            this.color = null;
            this.uv = null;
            this.lightmap = null;
            this.preProcess();
        }
    }
}

