/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.api.common.container;

import committee.nova.mods.avaritia.api.common.wrapper.OffsetItemStackWrapper;
import committee.nova.mods.avaritia.common.wrappers.StorageItem;
import committee.nova.mods.avaritia.init.config.ModConfig;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public interface OffsetContainer
extends Container {
    public static OffsetContainer dummy(int length) {
        final OffsetItemStackWrapper itemHandler = OffsetItemStackWrapper.dummy(length);
        return new OffsetContainer(){

            @Override
            public OffsetItemStackWrapper getItemHandler() {
                return itemHandler;
            }

            public void m_6596_() {
            }

            @Override
            public boolean m_6542_(@NotNull Player pPlayer) {
                return OffsetContainer.super.m_6542_(pPlayer);
            }
        };
    }

    public static OffsetContainer create(Int2ObjectMap<StorageItem> containers, int offset, int length) {
        final OffsetItemStackWrapper itemHandler = OffsetItemStackWrapper.create(containers, offset, length);
        return new OffsetContainer(){

            @Override
            public OffsetItemStackWrapper getItemHandler() {
                return itemHandler;
            }

            public void m_6596_() {
            }

            @Override
            public boolean m_6542_(@NotNull Player pPlayer) {
                return OffsetContainer.super.m_6542_(pPlayer);
            }
        };
    }

    public OffsetItemStackWrapper getItemHandler();

    default public StorageItem getItemInSlot(int index) {
        return this.getItemHandler().getContainerInSlot(index);
    }

    default public ContainerData getItemCount() {
        return new ContainerData(){

            public int m_6413_(int index) {
                return index >= 0 && index < OffsetContainer.this.m_6643_() ? (int)OffsetContainer.this.getItemInSlot(index).getCount() : 0;
            }

            public void m_8050_(int index, int value) {
                if (index >= 0 && index < OffsetContainer.this.m_6643_()) {
                    OffsetContainer.this.getItemInSlot(index).setCount(Integer.toUnsignedLong(value));
                }
            }

            public int m_6499_() {
                return OffsetContainer.this.m_6643_();
            }
        };
    }

    default public int m_6643_() {
        return this.getItemHandler().getSlots();
    }

    default public boolean m_7983_() {
        for (int i = 0; i < this.m_6643_(); ++i) {
            if (this.getItemInSlot(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    default public ItemStack m_8020_(int index) {
        return this.getItemInSlot(index).getStack().m_41777_();
    }

    @NotNull
    default public ItemStack m_7407_(int index, int count) {
        return this.getItemHandler().extractItem(index, count, false);
    }

    @NotNull
    default public ItemStack m_8016_(int index) {
        StorageItem container = this.getItemHandler().removeContainerInSlot(index);
        if (container.isEmpty()) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = container.getStack();
        return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)((int)container.getCount()));
    }

    default public void m_6836_(int index, @NotNull ItemStack stack) {
        this.getItemHandler().setStackInSlot(index, stack);
    }

    default public int m_6893_() {
        return (int)Math.min(Integer.MAX_VALUE, (Long)ModConfig.slotStackLimit.get());
    }

    default public void m_6211_() {
        for (int i = 0; i < this.m_6643_(); ++i) {
            this.getItemHandler().removeContainerInSlot(i);
        }
    }

    default public boolean m_6542_(@NotNull Player pPlayer) {
        return true;
    }
}

