/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.api.init.data;

import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.WoolCarpetBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class IBlockStateProvider
extends BlockStateProvider {
    public IBlockStateProvider(PackOutput output, ExistingFileHelper helper) {
        super(output, "avaritia", helper);
    }

    protected ResourceLocation texture(String name) {
        return this.modLoc("block/" + name);
    }

    protected String name(Supplier<? extends Block> block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block.get()).m_135815_();
    }

    public void block(Supplier<? extends Block> block) {
        this.simpleBlock(block.get());
    }

    public void blockTranslucent(Supplier<? extends Block> block) {
        this.simpleBlock(block.get(), (ModelFile)((BlockModelBuilder)this.models().cubeAll(this.name(block), this.blockTexture(block.get()))).renderType("translucent"));
    }

    public void log(Supplier<? extends RotatedPillarBlock> block, String name) {
        this.axisBlock(block.get(), this.texture(name));
    }

    private void crossBlock(Supplier<? extends Block> block, ModelFile model) {
        this.getVariantBuilder(block.get()).forAllStates(state -> ConfiguredModel.builder().modelFile(model).build());
    }

    public void torchBlock(Supplier<? extends Block> block, Supplier<? extends Block> wall) {
        ModelBuilder torch = ((BlockModelBuilder)this.models().torch(this.name(block), this.texture(this.name(block)))).renderType("cutout");
        ModelBuilder torchwall = ((BlockModelBuilder)this.models().torchWall(this.name(wall), this.texture(this.name(block)))).renderType("cutout");
        this.simpleBlock(block.get(), (ModelFile)torch);
        this.getVariantBuilder(wall.get()).forAllStates(arg_0 -> IBlockStateProvider.lambda$torchBlock$1((ModelFile)torchwall, arg_0));
    }

    public void crossBlock(Supplier<? extends Block> block) {
        this.crossBlock(block, (ModelFile)((BlockModelBuilder)this.models().cross(this.name(block), this.texture(this.name(block)))).renderType("cutout"));
    }

    public void tintedCrossBlock(Supplier<? extends Block> block) {
        this.crossBlock(block, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), this.mcLoc("block/tinted_cross"))).texture("cross", this.texture(this.name(block)))).renderType("cutout"));
    }

    public void stairs(Supplier<? extends StairBlock> block, Supplier<? extends Block> fullBlock) {
        this.stairsBlock(block.get(), this.texture(this.name(fullBlock)));
    }

    public void slab(Supplier<? extends SlabBlock> block, Supplier<? extends Block> fullBlock) {
        this.slabBlock(block.get(), this.texture(this.name(fullBlock)), this.texture(this.name(fullBlock)));
    }

    public void wall(Supplier<? extends WallBlock> wall, Supplier<? extends Block> fullBlock) {
        this.wallBlock(wall.get(), this.texture(this.name(fullBlock)));
    }

    public void fence(Supplier<? extends FenceBlock> block, Supplier<? extends Block> fullBlock) {
        this.fenceBlock(block.get(), this.texture(this.name(fullBlock)));
        this.fenceColumn(block, this.name(fullBlock));
    }

    private void fenceColumn(Supplier<? extends FenceBlock> block, String name) {
        String baseName = this.name(block);
        this.fourWayBlock((CrossCollisionBlock)block.get(), (ModelFile)this.models().fencePost(baseName + "_post", this.texture(name)), (ModelFile)this.models().fenceSide(baseName + "_side", this.texture(name)));
    }

    public void fenceGate(Supplier<? extends FenceGateBlock> block, Supplier<? extends Block> fullBlock) {
        this.fenceGateBlock(block.get(), this.texture(this.name(fullBlock)));
    }

    public void door(Supplier<? extends DoorBlock> block, String name) {
        this.doorBlockWithRenderType(block.get(), this.name(block), this.texture(name + "_door_bottom"), this.texture(name + "_door_top"), "cutout");
    }

    public void trapdoor(Supplier<? extends TrapDoorBlock> block, String name) {
        this.trapdoorBlockWithRenderType(block.get(), this.texture(name + "_trapdoor"), true, "cutout");
    }

    public void carpet(Supplier<? extends WoolCarpetBlock> block) {
        this.simpleBlock((Block)block.get(), (ModelFile)this.models().carpet(this.name(block), this.texture(this.name(block))));
    }

    public void button(Supplier<? extends ButtonBlock> block, Supplier<? extends Block> fullBlock) {
        this.buttonBlock(block.get(), this.texture(this.name(fullBlock)));
    }

    public void pressurePlate(Supplier<? extends PressurePlateBlock> block, Supplier<? extends Block> fullBlock) {
        this.pressurePlateBlock(block.get(), this.texture(this.name(fullBlock)));
    }

    public void sign(Supplier<? extends StandingSignBlock> standingBlock, Supplier<? extends WallSignBlock> wallBlock, String name) {
        this.signBlock(standingBlock.get(), wallBlock.get(), this.modLoc("block/" + name));
    }

    private static /* synthetic */ ConfiguredModel[] lambda$torchBlock$1(ModelFile torchwall, BlockState state) {
        return ConfiguredModel.builder().modelFile(torchwall).rotationY(((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() + 90) % 360).build();
    }
}

