/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.api.util;

import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class EntityUtils {
    public static Stream<EntityHitResult> findHitEntities(Level world, Projectile projectile, Vec3 startPos, Vec3 endPos, Predicate<Entity> filter) {
        Vec3 padding = new Vec3((double)projectile.m_20205_() * 0.5, (double)projectile.m_20206_() * 0.5, (double)projectile.m_20205_() * 0.5);
        return EntityUtils.findHitEntities(world, (Entity)projectile, startPos, endPos, projectile.m_20191_().m_82369_(projectile.m_20184_()).m_82400_(1.5), padding, filter);
    }

    public static Stream<EntityHitResult> findHitEntities(Level world, Entity exclude, Vec3 startPos, Vec3 endPos, double padding, Predicate<Entity> filter) {
        return EntityUtils.findHitEntities(world, exclude, startPos, endPos, new Vec3(padding, padding, padding), filter);
    }

    public static Stream<EntityHitResult> findHitEntities(Level world, Entity exclude, Vec3 startPos, Vec3 endPos, Vec3 padding, Predicate<Entity> filter) {
        return EntityUtils.findHitEntities(world, exclude, startPos, endPos, new AABB(startPos, endPos).m_82377_(padding.f_82479_, padding.f_82480_, padding.f_82481_), padding, filter);
    }

    public static Stream<EntityHitResult> findHitEntities(Level world, Entity exclude, Vec3 startPos, Vec3 endPos, AABB searchArea, Vec3 padding, Predicate<Entity> filter) {
        return EntityUtils.findHitEntities(world.m_6249_(exclude, searchArea, filter).stream(), startPos, endPos, padding);
    }

    public static Stream<EntityHitResult> findHitEntities(Stream<Entity> entities, Vec3 startPos, Vec3 endPos, Vec3 padding) {
        return entities.map(entity -> entity.m_20191_().m_82377_(padding.m_7096_(), padding.m_7098_(), padding.m_7094_()).m_82371_(startPos, endPos).map(hitPos -> new EntityHitResult(entity, hitPos)).orElse(null)).filter(Objects::nonNull);
    }
}

