/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.client;

import committee.nova.mods.avaritia.api.client.screen.ItemFilterScreen;
import committee.nova.mods.avaritia.api.iface.IFilterItem;
import committee.nova.mods.avaritia.client.screen.AvaritiaConfigScreen;
import committee.nova.mods.avaritia.common.entity.GapingVoidEntity;
import committee.nova.mods.avaritia.common.item.singularity.SingularityItem;
import committee.nova.mods.avaritia.init.config.ModConfig;
import committee.nova.mods.avaritia.init.registry.ModItems;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLLoader;

@Mod.EventBusSubscriber(modid="avaritia", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class AvaritiaForgeClient {
    private static final String CATEGORIES = "key.avaritia.categories";
    public static long lastTime = System.currentTimeMillis();
    public static int renderTime = 0;
    public static float renderFrame = 0.0f;
    public static boolean inventoryRender = false;
    private static float darknessIntensity = 0.0f;
    private static boolean keepFlying = false;
    public static final KeyMapping FILTER_KEY = new KeyMapping("key.avaritia.filter", 72, "key.avaritia.categories");
    public static final KeyMapping RING_KEY = new KeyMapping("key.avaritia.neutron_ring", 78, "key.avaritia.categories");
    public static final KeyMapping CONFIG_KEY = new KeyMapping("key.avaritia.config", 79, "key.avaritia.categories");
    private static Component[] tooltipExt = new Component[0];
    public static final IGuiOverlay DARKNESS_OVERLAY = (gui, guiGraphics, partialTick, screenWidth, screenHeight) -> {
        if (darknessIntensity > 0.01f) {
            AvaritiaForgeClient.renderDarknessOverlay(guiGraphics, screenWidth, screenHeight, darknessIntensity);
        }
    };

    @SubscribeEvent
    public static void onClientTickEnd(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        ClientLevel level = mc.f_91073_;
        if (player == null || level == null) {
            return;
        }
        if (CONFIG_KEY.m_90859_()) {
            mc.m_91152_((Screen)new AvaritiaConfigScreen(mc.f_91080_));
        }
        while (FILTER_KEY.m_90859_()) {
            if (player.m_21205_().m_41619_() || !(player.m_21205_().m_41720_() instanceof IFilterItem)) continue;
            Minecraft.m_91087_().m_91152_((Screen)new ItemFilterScreen());
        }
        if (!Minecraft.m_91087_().m_91104_()) {
            ++renderTime;
        }
        AvaritiaForgeClient.handleInfinityElytraFallFlying(mc, (Player)player);
        AvaritiaForgeClient.calculateDarknessIntensity((Player)player, (Level)level);
        AvaritiaForgeClient.singularityIconTimer();
    }

    public static void handleInfinityElytraFallFlying(Minecraft mc, Player player) {
        if (player.m_6844_(EquipmentSlot.CHEST).m_41720_() != ModItems.infinity_elytra.get()) {
            keepFlying = false;
            return;
        }
        boolean isFlying = player.m_21255_();
        if (mc.f_91066_.f_92089_.m_90857_()) {
            keepFlying = false;
            return;
        }
        if (isFlying && !keepFlying) {
            keepFlying = true;
        }
        if (keepFlying && player.m_20096_()) {
            keepFlying = false;
            double radius = 2.5;
            List nearby = player.m_9236_().m_6443_(LivingEntity.class, player.m_20191_().m_82400_(radius), e -> e != player);
            for (LivingEntity target : nearby) {
                target.m_6469_(player.m_269291_().m_269341_(), 6.0f);
            }
            return;
        }
        if (keepFlying) {
            if (!player.m_21255_()) {
                player.m_36320_();
            }
            Vec3 look = player.m_20154_().m_82541_();
            double FLY_SPEED = (Double)ModConfig.infinityElytraFlyingSpeed.get();
            player.m_20334_(look.f_82479_ * FLY_SPEED, look.f_82480_ * FLY_SPEED, look.f_82481_ * FLY_SPEED);
        }
    }

    public static void setTooltip(Component ... string) {
        tooltipExt = string;
    }

    @SubscribeEvent
    public static void getTooltip(ItemTooltipEvent evt) {
        Collections.addAll(evt.getToolTip(), tooltipExt);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onItemTooltip(ItemTooltipEvent e) {
        if (!FMLLoader.isProduction() || ((Boolean)ModConfig.useAdvanceTooltips.get()).booleanValue()) {
            CompoundTag tag;
            ItemStack stack = e.getItemStack();
            List tooltips = e.getToolTip();
            if (Screen.m_96639_() && (tag = stack.m_41783_()) != null) {
                AvaritiaForgeClient.addTagCompound("  ", tooltips, tag);
            }
        }
    }

    private static void addTagCompound(String prefix, List<Component> list, CompoundTag tag) {
        TreeSet sortedKeys = new TreeSet(tag.m_128431_());
        for (String key : sortedKeys) {
            AvaritiaForgeClient.addTag(prefix, key, list, tag.m_128423_(key));
        }
    }

    private static void addTag(String prefix, String key, List<Component> list, Tag tag) {
        switch (tag.m_7060_()) {
            case 2: {
                list.add((Component)Component.m_237113_((String)(prefix + key + ": \u00a72" + ((NumericTag)tag).m_7053_())));
                break;
            }
            case 3: {
                list.add((Component)Component.m_237113_((String)(prefix + key + ": \u00a73" + ((NumericTag)tag).m_7047_())));
                break;
            }
            case 6: {
                list.add((Component)Component.m_237113_((String)(prefix + key + ": \u00a76" + ((NumericTag)tag).m_7061_())));
                break;
            }
            case 1: {
                list.add((Component)Component.m_237113_((String)(prefix + key + ": \u00a79" + ((NumericTag)tag).m_7063_())));
                break;
            }
            case 8: {
                list.add((Component)Component.m_237113_((String)(prefix + key + ": \u00a78" + tag.m_7916_())));
                break;
            }
            case 9: {
                list.add((Component)Component.m_237113_((String)(prefix + key + ": \u00a79List, " + ((ListTag)tag).size() + " items")));
                if (!Screen.m_96638_()) break;
                for (Tag key1 : (ListTag)tag) {
                    AvaritiaForgeClient.addTag(prefix, "    ", list, key1);
                }
                break;
            }
            case 10: {
                list.add((Component)Component.m_237113_((String)(prefix + key + ": \u00a7aCompound")));
                if (!Screen.m_96638_()) break;
                AvaritiaForgeClient.addTagCompound(prefix + "    ", list, (CompoundTag)tag);
                break;
            }
            default: {
                list.add((Component)Component.m_237113_((String)(prefix + key + ": Type " + tag.m_6458_())));
            }
        }
    }

    private static void renderDarknessOverlay(GuiGraphics guiGraphics, int width, int height, float intensity) {
        int alpha = (int)(intensity * 255.0f);
        if (alpha > 255) {
            alpha = 255;
        }
        guiGraphics.m_280509_(0, 0, width, height, alpha << 24 | 0);
    }

    private static void calculateDarknessIntensity(Player player, Level level) {
        Vec3 playerPos = player.m_20182_();
        double maxDistance = 10.0;
        float maxIntensity = 0.0f;
        for (GapingVoidEntity pearl : level.m_45976_(GapingVoidEntity.class, player.m_20191_().m_82400_(maxDistance))) {
            float intensity;
            double distance = playerPos.m_82554_(pearl.m_20182_());
            if (!(distance < maxDistance) || !((intensity = (float)Math.max(0.0, 1.0 - Math.max(0.0, (distance - 4.0) / 6.0))) > maxIntensity)) continue;
            maxIntensity = intensity;
        }
        if (maxIntensity > darknessIntensity) {
            darknessIntensity = Math.min(maxIntensity, darknessIntensity + 0.05f);
        } else if (maxIntensity < darknessIntensity) {
            darknessIntensity = Math.max(maxIntensity, darknessIntensity - 0.05f);
        }
    }

    private static void singularityIconTimer() {
        if (renderTime % 20 != 0) {
            return;
        }
        if (SingularityItem.enabledSingularities != null && !SingularityItem.enabledSingularities.isEmpty()) {
            SingularityItem.currentSingularityIndex.set((SingularityItem.currentSingularityIndex.get() + 1) % SingularityItem.enabledSingularities.size());
        }
    }

    @SubscribeEvent
    public static void onRenderTickStart(TickEvent.RenderTickEvent event) {
        if (!Minecraft.m_91087_().m_91104_() && event.phase == TickEvent.Phase.START) {
            renderFrame = event.renderTickTime;
        }
    }

    @SubscribeEvent
    public static void drawScreenPre(ScreenEvent.Render.Pre e) {
        inventoryRender = true;
    }

    @SubscribeEvent
    public static void drawScreenPost(ScreenEvent.Render.Post e) {
        inventoryRender = false;
    }
}

