/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import committee.nova.mods.avaritia.Res;
import committee.nova.mods.avaritia.client.model.entity.InfinityArmorModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class InfinityArmorRender<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private final InfinityArmorModel model;

    public InfinityArmorRender(RenderLayerParent<T, M> renderer, EntityModelSet modelSet, boolean isSilm) {
        super(renderer);
        this.model = new InfinityArmorModel(modelSet.m_171103_(ModelLayers.f_171162_), isSilm);
    }

    private HumanoidModel.ArmPose getArmPose(LivingEntity livingEntity, InteractionHand hand) {
        HumanoidModel.ArmPose forgeArmPose;
        ItemStack itemStack = livingEntity.m_21120_(hand);
        if (itemStack.m_41619_()) {
            return HumanoidModel.ArmPose.EMPTY;
        }
        if (livingEntity.m_7655_() == hand && livingEntity.m_21212_() > 0) {
            UseAnim useAnim = itemStack.m_41780_();
            if (useAnim == UseAnim.BLOCK) {
                return HumanoidModel.ArmPose.BLOCK;
            }
            if (useAnim == UseAnim.BOW) {
                return HumanoidModel.ArmPose.BOW_AND_ARROW;
            }
            if (useAnim == UseAnim.SPEAR) {
                return HumanoidModel.ArmPose.THROW_SPEAR;
            }
            if (useAnim == UseAnim.CROSSBOW && hand == livingEntity.m_7655_()) {
                return HumanoidModel.ArmPose.CROSSBOW_CHARGE;
            }
            if (useAnim == UseAnim.SPYGLASS) {
                return HumanoidModel.ArmPose.SPYGLASS;
            }
            if (useAnim == UseAnim.TOOT_HORN) {
                return HumanoidModel.ArmPose.TOOT_HORN;
            }
            if (useAnim == UseAnim.BRUSH) {
                return HumanoidModel.ArmPose.BRUSH;
            }
        } else if (!livingEntity.f_20911_ && itemStack.m_41720_() instanceof CrossbowItem && CrossbowItem.m_40932_((ItemStack)itemStack)) {
            return HumanoidModel.ArmPose.CROSSBOW_HOLD;
        }
        if ((forgeArmPose = IClientItemExtensions.of((ItemStack)itemStack).getArmPose(livingEntity, hand, itemStack)) != null) {
            return forgeArmPose;
        }
        return HumanoidModel.ArmPose.ITEM;
    }

    private void setModelProperties(LivingEntity livingEntity, float ageInTicks) {
        this.model.f_102817_ = livingEntity.m_6144_();
        this.model.f_102610_ = livingEntity.m_6162_();
        this.model.f_102609_ = livingEntity.m_20159_();
        HumanoidModel.ArmPose mainArmPose = this.getArmPose(livingEntity, InteractionHand.MAIN_HAND);
        HumanoidModel.ArmPose offArmPose = this.getArmPose(livingEntity, InteractionHand.OFF_HAND);
        if (mainArmPose.m_102897_()) {
            HumanoidModel.ArmPose armPose = offArmPose = livingEntity.m_21206_().m_41619_() ? HumanoidModel.ArmPose.EMPTY : HumanoidModel.ArmPose.ITEM;
        }
        if (livingEntity.m_5737_() == HumanoidArm.RIGHT) {
            this.model.f_102815_ = offArmPose;
            this.model.f_102816_ = mainArmPose;
        } else {
            this.model.f_102815_ = mainArmPose;
            this.model.f_102816_ = offArmPose;
        }
    }

    public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, @NotNull T livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_117386_().m_102624_((EntityModel)this.model);
        this.setModelProperties((LivingEntity)livingEntity, ageInTicks);
        this.model.m_6973_((LivingEntity)livingEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        poseStack.m_85836_();
        VertexConsumer vertexconsumer = multiBufferSource.m_6299_(RenderType.m_110431_((ResourceLocation)Res.WING_TEX));
        this.model.render((LivingEntity)livingEntity, poseStack, multiBufferSource, vertexconsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
    }
}

