/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.client.screen;

import committee.nova.mods.avaritia.Res;
import committee.nova.mods.avaritia.api.client.screen.BaseContainerScreen;
import committee.nova.mods.avaritia.common.menu.CompressorMenu;
import committee.nova.mods.avaritia.common.tile.NeutronCompressorTile;
import committee.nova.mods.avaritia.init.registry.ModTooltips;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class NeutronCompressorScreen
extends BaseContainerScreen<CompressorMenu> {
    public NeutronCompressorScreen(CompressorMenu container, Inventory inventory, Component title) {
        super(container, inventory, title, Res.NEUTRON_COMPRESSOR_TEX);
    }

    @Override
    protected void renderFg(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        if (pMouseX > x + 63 && pMouseX < x + 79 && pMouseY > y + 35 && pMouseY < y + 51) {
            ArrayList<Object> tooltip = new ArrayList<Object>();
            if (this.getMaterialCount() < 1) {
                tooltip.add(ModTooltips.EMPTY.color(ChatFormatting.WHITE).build());
            } else {
                if (this.hasMaterialStack()) {
                    tooltip.add(this.getMaterialStackDisplayName());
                }
                MutableComponent text = Component.m_237113_((String)(NeutronCompressorScreen.number(this.getMaterialCount()) + " / " + NeutronCompressorScreen.number(this.getMaterialsRequired())));
                tooltip.add(text);
            }
            pGuiGraphics.m_280666_(this.f_96547_, tooltip, pMouseX, pMouseY);
        }
    }

    protected void m_280003_(@NotNull GuiGraphics stack, int mouseX, int mouseY) {
        String title = this.m_96636_().getString();
        stack.m_280056_(this.f_96547_, title, this.f_97726_ / 2 - this.f_96547_.m_92895_(title) / 2, 6, 0x404040, false);
        stack.m_280614_(this.f_96547_, this.f_169604_, 8, this.f_97727_ - 94, 0x404040, false);
    }

    @Override
    protected void renderBgs(GuiGraphics pGuiGraphics, float pPartialTick, int pX, int pY) {
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        if (this.hasRecipe()) {
            int i2;
            if (this.getMaterialCount() > 0 && this.getMaterialsRequired() > 0) {
                i2 = this.getMaterialBarScaled(16);
                pGuiGraphics.m_280218_(Res.NEUTRON_COMPRESSOR_TEX, x + 63, y + 35, 176, 18, i2 + 1, 16);
            }
            if (this.getProgress() > 0 && this.getMaterialCount() >= this.getMaterialsRequired()) {
                i2 = this.getProgressBarScaled(22);
                pGuiGraphics.m_280218_(Res.NEUTRON_COMPRESSOR_TEX, x + 89, y + 35, 176, 0, i2 + 1, 16);
            }
        }
    }

    private Component getMaterialStackDisplayName() {
        CompressorMenu container;
        BlockEntity tile;
        ClientLevel level = this.getMinecraft().f_91073_;
        if (level != null && (tile = level.m_7702_((container = (CompressorMenu)this.m_6262_()).getBlockPos())) instanceof NeutronCompressorTile) {
            NeutronCompressorTile compressor = (NeutronCompressorTile)tile;
            ItemStack materialStack = compressor.getMaterialStack();
            return materialStack.m_41786_();
        }
        return Component.m_237113_((String)"");
    }

    public boolean isEjecting() {
        if (((CompressorMenu)this.f_97732_).getTileEntity() == null) {
            return false;
        }
        return ((NeutronCompressorTile)((Object)((CompressorMenu)this.f_97732_).getTileEntity())).isEjecting();
    }

    public boolean hasRecipe() {
        if (((CompressorMenu)this.f_97732_).getTileEntity() == null) {
            return false;
        }
        return ((NeutronCompressorTile)((Object)((CompressorMenu)this.f_97732_).getTileEntity())).hasRecipe();
    }

    public boolean hasMaterialStack() {
        if (((CompressorMenu)this.f_97732_).getTileEntity() == null) {
            return false;
        }
        return ((NeutronCompressorTile)((Object)((CompressorMenu)this.f_97732_).getTileEntity())).hasMaterialStack();
    }

    public int getProgress() {
        if (((CompressorMenu)this.f_97732_).getTileEntity() == null) {
            return 0;
        }
        return ((CompressorMenu)this.f_97732_).getProgress();
    }

    public int getMaterialCount() {
        if (((CompressorMenu)this.f_97732_).getTileEntity() == null) {
            return 0;
        }
        return ((NeutronCompressorTile)((Object)((CompressorMenu)this.f_97732_).getTileEntity())).getMaterialCount();
    }

    public int getMaterialsRequired() {
        if (((CompressorMenu)this.f_97732_).getTileEntity() == null) {
            return 0;
        }
        return ((NeutronCompressorTile)((Object)((CompressorMenu)this.f_97732_).getTileEntity())).getMaterialsRequired();
    }

    public int getTimeRequired() {
        if (((CompressorMenu)this.f_97732_).getTileEntity() == null) {
            return 0;
        }
        return ((NeutronCompressorTile)((Object)((CompressorMenu)this.f_97732_).getTileEntity())).getTimeRequired();
    }

    public int getMaterialBarScaled(int pixels) {
        int i = Mth.m_14045_((int)this.getMaterialCount(), (int)0, (int)this.getMaterialsRequired());
        int j = this.getMaterialsRequired();
        return j != 0 && i != 0 ? i * pixels / j : 0;
    }

    public int getProgressBarScaled(int pixels) {
        int i = Mth.m_14045_((int)this.getProgress(), (int)0, (int)this.getTimeRequired());
        int j = this.getTimeRequired();
        return j != 0 && i != 0 ? i * pixels / j : 0;
    }
}

