/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.block.chest;

import com.google.common.collect.ImmutableMap;
import committee.nova.mods.avaritia.api.common.block.BaseTileEntityBlock;
import committee.nova.mods.avaritia.common.menu.provider.ChannelMenuProvider;
import committee.nova.mods.avaritia.common.tile.TesseractTile;
import committee.nova.mods.avaritia.core.channel.ClientChannelManager;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TesseractBlock
extends BaseTileEntityBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty NORTH = BlockStateProperties.f_61368_;
    public static final BooleanProperty SOUTH = BlockStateProperties.f_61370_;
    public static final BooleanProperty WEST = BlockStateProperties.f_61371_;
    public static final BooleanProperty EAST = BlockStateProperties.f_61369_;
    public static final BooleanProperty UP = BlockStateProperties.f_61366_;
    public static final BooleanProperty DOWN = BlockStateProperties.f_61367_;
    private final ImmutableMap<BlockState, VoxelShape> shapesCache;

    public TesseractBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283757_).m_280658_(NoteBlockInstrument.BASS).m_60913_(30.0f, 1200.0f).m_60918_(SoundType.f_56744_).m_60953_(TesseractBlock::getLightLevel).m_60922_((state, getter, pos, entityType) -> false).m_60960_((state, getter, pos) -> false).m_278183_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)NORTH, (Comparable)Boolean.TRUE)).m_61124_((Property)SOUTH, (Comparable)Boolean.TRUE)).m_61124_((Property)WEST, (Comparable)Boolean.TRUE)).m_61124_((Property)EAST, (Comparable)Boolean.TRUE)).m_61124_((Property)UP, (Comparable)Boolean.TRUE)).m_61124_((Property)DOWN, (Comparable)Boolean.TRUE)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
        this.shapesCache = this.m_152458_(TesseractBlock::calculateShape);
    }

    private static VoxelShape calculateShape(BlockState state) {
        VoxelShape voxelshape = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)3.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)3.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)3.0, (double)3.0, (double)3.0, (double)13.0), Block.m_49796_((double)13.0, (double)0.0, (double)3.0, (double)16.0, (double)3.0, (double)13.0), Block.m_49796_((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0), Block.m_49796_((double)0.0, (double)13.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)13.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0), Block.m_49796_((double)13.0, (double)13.0, (double)3.0, (double)16.0, (double)16.0, (double)13.0), Block.m_49796_((double)0.0, (double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)3.0), Block.m_49796_((double)13.0, (double)3.0, (double)0.0, (double)16.0, (double)13.0, (double)3.0), Block.m_49796_((double)13.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0, (double)16.0), Block.m_49796_((double)0.0, (double)3.0, (double)13.0, (double)3.0, (double)13.0, (double)16.0)});
        if (!((Boolean)state.m_61143_((Property)NORTH)).booleanValue()) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)Block.m_49796_((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)1.0));
        }
        if (!((Boolean)state.m_61143_((Property)SOUTH)).booleanValue()) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)Block.m_49796_((double)3.0, (double)3.0, (double)14.0, (double)13.0, (double)13.0, (double)16.0));
        }
        if (!((Boolean)state.m_61143_((Property)WEST)).booleanValue()) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)Block.m_49796_((double)0.0, (double)3.0, (double)3.0, (double)1.0, (double)13.0, (double)13.0));
        }
        if (!((Boolean)state.m_61143_((Property)EAST)).booleanValue()) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)Block.m_49796_((double)14.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0));
        }
        if (!((Boolean)state.m_61143_((Property)DOWN)).booleanValue()) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0));
        }
        if (!((Boolean)state.m_61143_((Property)UP)).booleanValue()) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)Block.m_49796_((double)3.0, (double)14.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0));
        }
        return voxelshape;
    }

    private static int getLightLevel(BlockState value) {
        if (((Boolean)value.m_61143_((Property)NORTH)).booleanValue() || ((Boolean)value.m_61143_((Property)SOUTH)).booleanValue() || ((Boolean)value.m_61143_((Property)WEST)).booleanValue() || ((Boolean)value.m_61143_((Property)EAST)).booleanValue() || ((Boolean)value.m_61143_((Property)DOWN)).booleanValue() || ((Boolean)value.m_61143_((Property)UP)).booleanValue()) {
            return 15;
        }
        return 0;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{NORTH, SOUTH, WEST, EAST, UP, DOWN, WATERLOGGED});
    }

    public void m_5871_(ItemStack pStack, @Nullable BlockGetter pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        CompoundTag nbt;
        if (Minecraft.m_91087_().f_91074_ == null) {
            return;
        }
        if (!pStack.m_41782_()) {
            return;
        }
        if (pStack.m_41783_().m_128441_("BlockEntityTag") && (nbt = pStack.m_41783_().m_128469_("BlockEntityTag")).m_128441_("owner")) {
            UUID selfUUID = Minecraft.m_91087_().f_91074_.m_20148_();
            UUID ownerUUID = nbt.m_128342_("owner");
            String ownerName = ClientChannelManager.getInstance().getUserName(nbt.m_128342_("owner"));
            boolean lock = nbt.m_128471_("locked");
            if (selfUUID.equals(ownerUUID)) {
                pTooltip.add((Component)Component.m_237110_((String)"gui.avaritia.owner", (Object[])new Object[]{"\u00a7a" + ownerName}));
            } else if (lock) {
                pTooltip.add((Component)Component.m_237110_((String)"gui.avaritia.owner", (Object[])new Object[]{"\u00a7c" + ownerName}));
            } else {
                pTooltip.add((Component)Component.m_237110_((String)"gui.avaritia.owner", (Object[])new Object[]{ownerName}));
            }
        }
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult trace) {
        BlockEntity tile;
        if (!level.m_5776_() && !player.m_5833_() && (tile = level.m_7702_(pos)) instanceof TesseractTile) {
            TesseractTile chestTile = (TesseractTile)tile;
            if (chestTile.getOwner() == null) {
                chestTile.setOwner(player.m_20148_());
                chestTile.setLocked(false);
            }
            if (chestTile.getChannelOwner() == null || chestTile.getChannelID() < 0) {
                chestTile.setChannelOwner(player.m_20148_());
                chestTile.setChannelId(0);
            }
            if (chestTile.getChannelInfo() == null) {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new ChannelMenuProvider(chestTile), buf -> {});
            } else {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new ChannelMenuProvider(chestTile), buf -> {
                    buf.m_130064_(pos);
                    buf.writeInt(-2);
                    buf.m_130077_(chestTile.getOwner());
                    buf.writeBoolean(chestTile.isLocked());
                    buf.writeBoolean(chestTile.isCraftingMode());
                    buf.m_130072_(chestTile.getFilter(), 64);
                    buf.writeByte((int)chestTile.getSortType());
                    buf.writeByte((int)chestTile.getViewType());
                    buf.m_130077_(chestTile.getChannelOwner());
                    buf.writeInt(chestTile.getChannelID());
                });
            }
        }
        return InteractionResult.SUCCESS;
    }

    public BlockState m_5573_(BlockPlaceContext placeContext) {
        BlockPos blockpos = placeContext.m_8083_();
        FluidState fluidstate = placeContext.m_43725_().m_6425_(blockpos);
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }

    @NotNull
    public BlockEntity m_142194_(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        return new TesseractTile(pPos, pState);
    }

    public void m_6402_(@NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState, @Nullable LivingEntity pPlacer, @NotNull ItemStack pStack) {
        if (pPlacer instanceof ServerPlayer) {
            TesseractTile blockEntity;
            ServerPlayer player = (ServerPlayer)pPlacer;
            if (!pStack.m_41784_().m_128441_("BlockEntityTag") && (blockEntity = (TesseractTile)pLevel.m_7702_(pPos)) != null) {
                blockEntity.setOwner(pPlacer.m_20148_());
            }
        }
    }

    public void m_7892_(@NotNull BlockState pState, Level pLevel, @NotNull BlockPos pPos, @NotNull Entity pEntity) {
        if (pLevel.f_46443_) {
            return;
        }
        BlockEntity blockentity = pLevel.m_7702_(pPos);
        if (blockentity instanceof TesseractTile) {
            TesseractTile tesseractTile = (TesseractTile)blockentity;
            if (pEntity instanceof ItemEntity) {
                ItemEntity itemEntity = (ItemEntity)pEntity;
                tesseractTile.inhaleItem(itemEntity);
            }
        }
    }

    @NotNull
    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return Shapes.m_83144_();
    }

    @NotNull
    public VoxelShape m_5939_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        VoxelShape shape = (VoxelShape)this.shapesCache.get((Object)pState);
        if (shape != null) {
            return shape;
        }
        return Shapes.m_83144_();
    }

    @NotNull
    public VoxelShape m_7952_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        VoxelShape shape = (VoxelShape)this.shapesCache.get((Object)pState);
        if (shape != null) {
            return shape;
        }
        return Shapes.m_83144_();
    }

    public boolean m_7923_(@NotNull BlockState pState) {
        return true;
    }

    public boolean m_7420_(BlockState state, BlockGetter getter, BlockPos pos) {
        return state.m_60819_().m_76178_();
    }

    @NotNull
    public BlockState m_7417_(BlockState pState, @NotNull Direction pFacing, @NotNull BlockState pFacingState, @NotNull LevelAccessor pLevel, @NotNull BlockPos pCurrentPos, @NotNull BlockPos pFacingPos) {
        if (((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            pLevel.m_186469_(pCurrentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        return super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    public boolean m_7278_(@NotNull BlockState pState) {
        return true;
    }

    public int m_6782_(@NotNull BlockState state, Level level, @NotNull BlockPos pos) {
        return AbstractContainerMenu.m_38918_((BlockEntity)level.m_7702_(pos));
    }

    public void onBlockStateChange(LevelReader level, BlockPos pos, BlockState oldState, BlockState newState) {
        TesseractTile blockEntity = (TesseractTile)level.m_7702_(pos);
        if (blockEntity != null) {
            blockEntity.onBlockStateChange();
        }
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState pState) {
        return RenderShape.MODEL;
    }

    public boolean m_7357_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull PathComputationType pType) {
        return false;
    }
}

