/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.block.misc;

import committee.nova.mods.avaritia.api.common.block.BaseBlock;
import committee.nova.mods.avaritia.init.config.ModConfig;
import committee.nova.mods.avaritia.init.registry.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.TallFlowerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SoulFarmLandBlock
extends BaseBlock {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);

    public SoulFarmLandBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283748_).m_60978_(0.6f).m_60977_().m_60918_(SoundType.f_56717_));
    }

    @NotNull
    public BlockState m_7417_(@NotNull BlockState pState, @NotNull Direction pFacing, @NotNull BlockState pFacingState, @NotNull LevelAccessor pLevel, @NotNull BlockPos pCurrentPos, @NotNull BlockPos pFacingPos) {
        if (pFacing == Direction.UP && !pState.m_60710_((LevelReader)pLevel, pCurrentPos)) {
            pLevel.m_186460_(pCurrentPos, (Block)this, 1);
        }
        return super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public boolean m_7923_(@NotNull BlockState pState) {
        return true;
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return SHAPE;
    }

    @Nullable
    public BlockState getToolModifiedState(BlockState state, UseOnContext context, ToolAction toolAction, boolean simulate) {
        if (toolAction.equals(ToolActions.HOE_TILL) && context.m_43725_().m_8055_(context.m_8083_().m_7494_()).m_60795_()) {
            return ((Block)ModBlocks.soul_farmland.get()).m_49966_();
        }
        return null;
    }

    public boolean canSustainPlant(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull Direction facing, @NotNull IPlantable plantable) {
        PlantType type = plantable.getPlantType(world, pos);
        return type == PlantType.CROP || type == PlantType.NETHER || type == PlantType.BEACH || type == PlantType.DESERT || type == PlantType.PLAINS;
    }

    public void m_213898_(@NotNull BlockState state, ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource rand) {
        if (!level.f_46443_) {
            BlockPos abovePos = pos.m_7494_();
            BlockState aboveState = level.m_8055_(abovePos);
            Block aboveBlock = aboveState.m_60734_();
            if (aboveBlock instanceof TallFlowerBlock) {
                return;
            }
            if ((Double)ModConfig.growthSoulFarmland.get() == 0.0) {
                return;
            }
            if ((aboveBlock instanceof SugarCaneBlock || level.m_8055_(pos.m_6630_(2)).m_60734_() instanceof SugarCaneBlock && (double)level.f_46441_.m_188501_() <= (Double)ModConfig.growthSoulFarmland.get()) && (Integer)aboveState.m_61143_((Property)SugarCaneBlock.f_57164_) < 11) {
                level.m_7731_(abovePos, (BlockState)aboveState.m_61124_((Property)SugarCaneBlock.f_57164_, (Comparable)Integer.valueOf((Integer)aboveState.m_61143_((Property)SugarCaneBlock.f_57164_) + 5)), 4);
            }
            if (aboveBlock instanceof BonemealableBlock) {
                BonemealableBlock growable = (BonemealableBlock)aboveBlock;
                if ((double)level.f_46441_.m_188501_() <= (Double)ModConfig.growthSoulFarmland.get() && growable.m_7370_((LevelReader)level, pos.m_7494_(), aboveState, false) && ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos.m_7494_(), (BlockState)aboveState, (boolean)true)) {
                    growable.m_214148_(level, level.f_46441_, pos.m_7494_(), aboveState);
                    level.m_46796_(2005, pos.m_7494_(), 0);
                    ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos.m_7494_(), (BlockState)aboveState);
                }
            }
        }
    }
}

