/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.container;

import committee.nova.mods.avaritia.common.menu.TesseractMenu;
import committee.nova.mods.avaritia.util.SortUtils;
import committee.nova.mods.avaritia.util.StorageUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;

public class DummyChannelContainer
extends SimpleContainer {
    public final ArrayList<String[]> sortedObject = new ArrayList();
    public final ArrayList<String[]> viewingObject = new ArrayList();
    public final HashMap<Integer, FluidStack> fluidStacks = new HashMap();
    public final ArrayList<String> formatCount = new ArrayList();
    private final TesseractMenu menu;
    protected ArrayList<String> sortedItems = new ArrayList();
    protected ArrayList<String> sortedFluids = new ArrayList();
    protected ArrayList<String> sortedEnergies = new ArrayList();
    private double scrollTo = 0.0;

    public DummyChannelContainer(TesseractMenu menu) {
        super(99);
        this.menu = menu;
    }

    public void onChangeViewType() {
        this.sortedObject.clear();
        switch (this.menu.viewType) {
            case 0: {
                this.sortedItems.forEach(s -> this.sortedObject.add(new String[]{"item", s}));
                this.sortedFluids.forEach(s -> this.sortedObject.add(new String[]{"fluid", s}));
                this.sortedEnergies.forEach(s -> this.sortedObject.add(new String[]{"energy", s}));
                break;
            }
            case 1: {
                this.sortedItems.forEach(s -> this.sortedObject.add(new String[]{"item", s}));
                break;
            }
            case 2: {
                this.sortedFluids.forEach(s -> this.sortedObject.add(new String[]{"fluid", s}));
                this.sortedEnergies.forEach(s -> this.sortedObject.add(new String[]{"energy", s}));
            }
        }
        this.scrollOffset(0);
    }

    public void onScrollTo(double scrollTo) {
        this.scrollTo = scrollTo;
        this.scrollOffset(0);
    }

    public double getScrollOn() {
        return this.scrollTo;
    }

    public void scrollOffset(int offset) {
        if (this.sortedObject.size() <= (this.menu.craftingMode ? 77 : 99)) {
            this.viewingObject.clear();
            this.viewingObject.addAll(this.sortedObject);
        } else {
            int i = (int)Math.ceil((double)this.sortedObject.size() / 11.0);
            int j = Math.round((float)(i -= this.menu.craftingMode ? 7 : 9) * (float)this.scrollTo);
            if (offset != 0) {
                j += offset;
                j = Math.max(0, Math.min(i, j));
                this.scrollTo = (double)j / (double)i;
            }
            this.viewingObject.clear();
            this.viewingObject.addAll(this.sortedObject.subList(j * 11, Math.min(this.sortedObject.size(), j * 11 + (this.menu.craftingMode ? 77 : 99))));
        }
        this.updateDummySlots(true);
    }

    public double onMouseScrolled(boolean isUp) {
        if (isUp) {
            this.scrollOffset(-1);
        } else {
            this.scrollOffset(1);
        }
        return this.scrollTo;
    }

    public void refreshContainer(boolean fullUpdate) {
        if (!this.menu.level.f_46443_) {
            return;
        }
        if ((fullUpdate || this.menu.sortType >= 6) && !this.menu.LShifting) {
            this.sortedItems = new ArrayList<String>(this.menu.channel.storageItems.keySet());
            this.sortedFluids = new ArrayList<String>(this.menu.channel.storageFluids.keySet());
            this.sortedEnergies = new ArrayList<String>(this.menu.channel.storageEnergies.keySet());
            if (!this.menu.filter.isEmpty()) {
                ArrayList<String> temp = new ArrayList<String>();
                ArrayList<String> temp1 = new ArrayList<String>();
                ArrayList<String> temp2 = new ArrayList<String>();
                char head = this.menu.filter.charAt(0);
                if (head == '*') {
                    String s = this.menu.filter.substring(1);
                    for (String itemName : this.sortedItems) {
                        if (!itemName.contains(s)) continue;
                        temp.add(itemName);
                    }
                    for (String fluidName : this.sortedFluids) {
                        if (!fluidName.contains(s)) continue;
                        temp1.add(fluidName);
                    }
                    for (String energyName : this.sortedEnergies) {
                        if (!energyName.contains(s)) continue;
                        temp2.add(energyName);
                    }
                } else if (head == '$') {
                    String s = this.menu.filter.substring(1);
                    block13: for (String itemName : this.sortedItems) {
                        ItemStack itemStack = new ItemStack((ItemLike)StorageUtils.getItem(itemName));
                        ArrayList tags = new ArrayList();
                        itemStack.m_204131_().forEach(itemTagKey -> tags.add(itemTagKey.f_203868_().m_135815_()));
                        for (String tag : tags) {
                            if (!tag.contains(s)) continue;
                            temp.add(itemName);
                            continue block13;
                        }
                    }
                } else {
                    ItemStack itemStack;
                    for (String itemName : this.sortedItems) {
                        if (itemName.contains(this.menu.filter)) {
                            temp.add(itemName);
                            continue;
                        }
                        itemStack = new ItemStack((ItemLike)StorageUtils.getItem(itemName));
                        if (!itemStack.m_41611_().getString().toLowerCase().contains(this.menu.filter)) continue;
                        temp.add(itemName);
                    }
                    for (String fluidName : this.sortedFluids) {
                        if (fluidName.contains(this.menu.filter)) {
                            temp1.add(fluidName);
                            continue;
                        }
                        FluidStack fluidStack = new FluidStack(StorageUtils.getFluid(fluidName), 1);
                        if (!fluidStack.getDisplayName().getString().toLowerCase().contains(this.menu.filter)) continue;
                        temp1.add(fluidName);
                    }
                    for (String energyName : this.sortedEnergies) {
                        if (energyName.contains(this.menu.filter)) {
                            temp2.add(energyName);
                            continue;
                        }
                        itemStack = new ItemStack((ItemLike)StorageUtils.getItem(energyName));
                        if (!itemStack.m_41611_().getString().toLowerCase().contains(this.menu.filter)) continue;
                        temp2.add(energyName);
                    }
                }
                this.sortedItems = temp;
                this.sortedFluids = temp1;
                this.sortedEnergies = temp2;
            }
            switch (this.menu.sortType) {
                case 0: {
                    this.sortedItems.sort(SortUtils::sortFromRightID);
                    this.sortedFluids.sort(SortUtils::sortFromRightID);
                    this.sortedEnergies.sort(SortUtils::sortFromRightID);
                    break;
                }
                case 1: {
                    this.sortedItems.sort(Collections.reverseOrder(SortUtils::sortFromRightID));
                    this.sortedFluids.sort(Collections.reverseOrder(SortUtils::sortFromRightID));
                    this.sortedEnergies.sort(Collections.reverseOrder(SortUtils::sortFromRightID));
                    break;
                }
                case 2: {
                    this.sortedItems.sort(String::compareTo);
                    this.sortedFluids.sort(String::compareTo);
                    this.sortedEnergies.sort(String::compareTo);
                    break;
                }
                case 3: {
                    this.sortedItems.sort(Collections.reverseOrder(String::compareTo));
                    this.sortedFluids.sort(Collections.reverseOrder(String::compareTo));
                    this.sortedEnergies.sort(Collections.reverseOrder(String::compareTo));
                    break;
                }
                case 4: {
                    this.sortedItems.sort(SortUtils::sortFromMirrorID);
                    this.sortedFluids.sort(SortUtils::sortFromMirrorID);
                    this.sortedEnergies.sort(SortUtils::sortFromMirrorID);
                    break;
                }
                case 5: {
                    this.sortedItems.sort(Collections.reverseOrder(SortUtils::sortFromMirrorID));
                    this.sortedFluids.sort(Collections.reverseOrder(SortUtils::sortFromMirrorID));
                    this.sortedEnergies.sort(Collections.reverseOrder(SortUtils::sortFromMirrorID));
                    break;
                }
                case 6: {
                    this.sortedItems.sort((s1, s2) -> SortUtils.sortFromCount(s1, s2, this.menu.channel.storageItems, false));
                    this.sortedFluids.sort((s1, s2) -> SortUtils.sortFromCount(s1, s2, this.menu.channel.storageFluids, false));
                    this.sortedEnergies.sort((s1, s2) -> SortUtils.sortFromCount(s1, s2, this.menu.channel.storageEnergies, false));
                    break;
                }
                case 7: {
                    this.sortedItems.sort((s1, s2) -> SortUtils.sortFromCount(s1, s2, this.menu.channel.storageItems, true));
                    this.sortedFluids.sort((s1, s2) -> SortUtils.sortFromCount(s1, s2, this.menu.channel.storageFluids, true));
                    this.sortedEnergies.sort((s1, s2) -> SortUtils.sortFromCount(s1, s2, this.menu.channel.storageEnergies, true));
                }
            }
            this.onChangeViewType();
            return;
        }
        this.updateDummySlots(fullUpdate);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void updateDummySlots(boolean fullUpdate) {
        this.formatCount.clear();
        if (fullUpdate) {
            this.fluidStacks.clear();
        }
        int j = 0;
        while (true) {
            block15: {
                block16: {
                    Object stringCount;
                    long count;
                    block21: {
                        String id;
                        block22: {
                            block19: {
                                block20: {
                                    block17: {
                                        block18: {
                                            if (j >= (this.menu.craftingMode ? 77 : 99)) {
                                                return;
                                            }
                                            if (j >= this.viewingObject.size() || this.viewingObject.get(j) == null) break block16;
                                            id = this.viewingObject.get(j)[1];
                                            if (!this.viewingObject.get(j)[0].equals("fluid")) break block17;
                                            if (fullUpdate) {
                                                this.m_6836_(j, new ItemStack((ItemLike)StorageUtils.getFluid(id).m_6859_()));
                                                this.fluidStacks.put(j, new FluidStack(StorageUtils.getFluid(id), 1));
                                            }
                                            if (this.menu.channel.storageFluids.containsKey(id)) break block18;
                                            this.formatCount.add(j, "\u00a7c0");
                                            break block15;
                                        }
                                        count = this.menu.channel.storageFluids.get(id);
                                        if (count < 1000L) {
                                            this.formatCount.add(j, count + "mB");
                                            break block15;
                                        } else if (count < Long.MAX_VALUE) {
                                            stringCount = StorageUtils.DECIMAL_FORMAT.format(count);
                                            if (((String)(stringCount = ((String)stringCount).substring(0, 4))).endsWith(",")) {
                                                stringCount = ((String)stringCount).substring(0, 3);
                                            }
                                            stringCount = ((String)stringCount).replace(",", ".");
                                            stringCount = count < 1000000L ? (String)stringCount : (count < 1000000000L ? (String)stringCount + "K" : (count < 1000000000000L ? (String)stringCount + "M" : (count < 1000000000000000L ? (String)stringCount + "G" : (count < 1000000000000000000L ? (String)stringCount + "T" : (String)stringCount + "P"))));
                                            this.formatCount.add(j, (String)stringCount);
                                            break block15;
                                        } else {
                                            this.formatCount.add(j, "MAX");
                                        }
                                        break block15;
                                    }
                                    if (fullUpdate) {
                                        this.m_6836_(j, new ItemStack((ItemLike)StorageUtils.getItem(id)));
                                    }
                                    if (!this.viewingObject.get(j)[0].equals("item")) break block19;
                                    if (!this.menu.channel.storageItems.containsKey(id)) break block20;
                                    count = this.menu.channel.storageItems.get(id);
                                    break block21;
                                }
                                this.formatCount.add(j, "\u00a7c0");
                                break block15;
                            }
                            if (this.menu.channel.storageEnergies.containsKey(id)) break block22;
                            this.formatCount.add(j, "\u00a7c0");
                            break block15;
                        }
                        count = this.menu.channel.storageEnergies.get(id);
                    }
                    if (count < 1000L) {
                        this.formatCount.add(j, String.valueOf(count));
                        break block15;
                    } else if (count < Long.MAX_VALUE) {
                        stringCount = StorageUtils.DECIMAL_FORMAT.format(count);
                        if (((String)(stringCount = ((String)stringCount).substring(0, 4))).endsWith(",")) {
                            stringCount = ((String)stringCount).substring(0, 3);
                        }
                        stringCount = ((String)stringCount).replace(",", ".");
                        stringCount = count < 1000000L ? (String)stringCount + "K" : (count < 1000000000L ? (String)stringCount + "M" : (count < 1000000000000L ? (String)stringCount + "G" : (count < 1000000000000000L ? (String)stringCount + "T" : (count < 1000000000000000000L ? (String)stringCount + "P" : (String)stringCount + "E"))));
                        this.formatCount.add(j, (String)stringCount);
                        break block15;
                    } else {
                        this.formatCount.add(j, "MAX");
                    }
                    break block15;
                }
                this.m_6836_(j, ItemStack.f_41583_);
            }
            ++j;
        }
    }

    public void m_6596_() {
    }

    public int m_6893_() {
        return Integer.MAX_VALUE;
    }
}

