/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.crafting.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import committee.nova.mods.avaritia.common.crafting.recipe.ShapelessTableCraftingRecipe;
import committee.nova.mods.avaritia.core.singularity.Singularity;
import committee.nova.mods.avaritia.core.singularity.SingularityDataManager;
import committee.nova.mods.avaritia.init.registry.ModItems;
import committee.nova.mods.avaritia.init.registry.ModRecipeSerializers;
import committee.nova.mods.avaritia.util.SingularityUtils;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class EternalSingularityCraftRecipe
extends ShapelessTableCraftingRecipe {
    private static final Object2BooleanOpenHashMap<EternalSingularityCraftRecipe> INGREDIENTS_LOADED = new Object2BooleanOpenHashMap();
    public final NonNullList<Ingredient> inputs;
    public final boolean custom;

    public EternalSingularityCraftRecipe(ResourceLocation recipeId, NonNullList<Ingredient> inputs, boolean custom) {
        super(recipeId, (NonNullList<Ingredient>)NonNullList.m_122779_(), new ItemStack((ItemLike)ModItems.eternal_singularity.get()), 4);
        this.inputs = inputs;
        this.custom = custom;
    }

    public static void invalidate() {
        INGREDIENTS_LOADED.clear();
    }

    @Override
    public boolean m_5818_(@NotNull Container input, @NotNull Level level) {
        NonNullList<Ingredient> ingredients = this.m_7527_();
        if (ingredients.isEmpty()) {
            return false;
        }
        int singularityCount = SingularityDataManager.getInstance().getSingularities().stream().filter(singularity -> singularity.getIngredient() != Ingredient.f_43901_).mapToInt(singularity -> 1).sum();
        boolean[] found = new boolean[singularityCount];
        int validItems = 0;
        for (int i = 0; i < input.m_6643_(); ++i) {
            ItemStack stack = input.m_8020_(i);
            if (stack.m_41619_()) continue;
            ++validItems;
            boolean matched = false;
            int index = 0;
            for (Singularity singularity2 : SingularityDataManager.getInstance().getSingularities()) {
                if (singularity2.getIngredient() == Ingredient.f_43901_) continue;
                ItemStack singularityStack = SingularityUtils.getItemForSingularity(singularity2);
                if (ItemStack.m_150942_((ItemStack)stack, (ItemStack)singularityStack) && !found[index]) {
                    found[index] = true;
                    matched = true;
                    break;
                }
                ++index;
            }
            if (matched) continue;
            return false;
        }
        for (boolean b : found) {
            if (b) continue;
            return false;
        }
        return validItems == singularityCount;
    }

    @Override
    @NotNull
    public NonNullList<Ingredient> m_7527_() {
        if (!INGREDIENTS_LOADED.getOrDefault((Object)this, false)) {
            super.m_7527_().clear();
            if (this.custom) {
                super.m_7527_().addAll(this.inputs);
            } else {
                SingularityDataManager.getInstance().getSingularities().stream().filter(singularity -> singularity.getIngredient() != Ingredient.f_43901_).map(SingularityUtils::getItemForSingularity).map(xva$0 -> Ingredient.m_43927_((ItemStack[])new ItemStack[]{xva$0})).forEach(arg_0 -> super.m_7527_().add(arg_0));
            }
            INGREDIENTS_LOADED.put((Object)this, true);
        }
        return super.m_7527_();
    }

    @Override
    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.ETERNAL_SINGULARITY_CRAFT_SERIALIZER.get();
    }

    public static class Serializer
    implements RecipeSerializer<EternalSingularityCraftRecipe> {
        @NotNull
        public EternalSingularityCraftRecipe fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
            NonNullList inputs = NonNullList.m_122779_();
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
            for (int i = 0; i < ingredients.size(); ++i) {
                inputs.add((Object)Ingredient.m_43917_((JsonElement)ingredients.get(i)));
            }
            boolean custom = GsonHelper.m_13855_((JsonObject)json, (String)"custom", (boolean)false);
            return new EternalSingularityCraftRecipe(recipeId, (NonNullList<Ingredient>)inputs, custom);
        }

        public EternalSingularityCraftRecipe fromNetwork(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buffer) {
            int size = buffer.m_130242_();
            NonNullList inputs = NonNullList.m_122780_((int)size, (Object)Ingredient.f_43901_);
            for (int i = 0; i < size; ++i) {
                inputs.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            boolean custom = buffer.readBoolean();
            return new EternalSingularityCraftRecipe(recipeId, (NonNullList<Ingredient>)inputs, custom);
        }

        public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull EternalSingularityCraftRecipe recipe) {
            buffer.m_130130_(recipe.inputs.size());
            for (Ingredient ingredient : recipe.inputs) {
                ingredient.m_43923_(buffer);
            }
            buffer.writeBoolean(recipe.custom);
        }
    }
}

