/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.entity;

import committee.nova.mods.avaritia.common.item.misc.InfinityClockItem;
import committee.nova.mods.avaritia.init.registry.ModEntities;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;

public class AcceleratorDisplayEntity
extends Entity {
    private static final EntityDataAccessor<Integer> SPEED_MULTIPLIER = SynchedEntityData.m_135353_(AcceleratorDisplayEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> FACE = SynchedEntityData.m_135353_(AcceleratorDisplayEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private BlockPos targetPos;
    private int particleTimer = 0;

    public AcceleratorDisplayEntity(EntityType<?> type, Level level) {
        super(type, level);
        this.f_19794_ = true;
        this.m_6842_(true);
    }

    public AcceleratorDisplayEntity(Level level, BlockPos targetPos, int speed, Direction face) {
        this((EntityType)ModEntities.acceleratorDisplayEntity.get(), level);
        this.targetPos = targetPos;
        this.f_19804_.m_135381_(SPEED_MULTIPLIER, (Object)speed);
        this.f_19804_.m_135381_(FACE, (Object)face.m_122411_());
        this.setPositionByFace(targetPos, face);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(SPEED_MULTIPLIER, (Object)1);
        this.f_19804_.m_135372_(FACE, (Object)Direction.NORTH.m_122411_());
    }

    public int getSpeedMultiplier() {
        return (Integer)this.f_19804_.m_135370_(SPEED_MULTIPLIER);
    }

    public void setSpeedMultiplier(int speed) {
        this.f_19804_.m_135381_(SPEED_MULTIPLIER, (Object)speed);
    }

    public Direction getFace() {
        return Direction.m_122376_((int)((Integer)this.f_19804_.m_135370_(FACE)));
    }

    public void setFace(Direction face) {
        this.f_19804_.m_135381_(FACE, (Object)face.m_122411_());
    }

    private void setPositionByFace(BlockPos pos, Direction face) {
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 0.5;
        double z = (double)pos.m_123343_() + 0.5;
        double offset = 0.51;
        switch (face) {
            case UP: {
                y = (double)pos.m_123342_() + offset;
                break;
            }
            case DOWN: {
                y = (double)pos.m_123342_() - offset + 1.0;
                break;
            }
            case NORTH: {
                z = (double)pos.m_123343_() - offset + 1.0;
                break;
            }
            case SOUTH: {
                z = (double)pos.m_123343_() + offset;
                break;
            }
            case WEST: {
                x = (double)pos.m_123341_() - offset + 1.0;
                break;
            }
            case EAST: {
                x = (double)pos.m_123341_() + offset;
            }
        }
        this.m_6034_(x, y, z);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!(this.m_9236_().f_46443_ || this.targetPos != null && ((Map)InfinityClockItem.acceleratedBlocks.getOrDefault(this.m_9236_().m_46472_(), new HashMap())).containsKey(this.targetPos))) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        if (this.m_9236_().f_46443_ && this.targetPos != null) {
            this.renderEffects();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void renderEffects() {
        if (this.targetPos == null) {
            return;
        }
        ++this.particleTimer;
        Level level = this.m_9236_();
        long gameTime = level.m_46467_();
        if (this.particleTimer % 2 == 0) {
            for (int i = 0; i < 10; ++i) {
                double hAngle = ((double)gameTime * 0.5 + (double)(i * 40)) % 360.0;
                double hRadius = 0.6;
                double hX = (double)this.targetPos.m_123341_() + 0.5 + Math.cos(Math.toRadians(hAngle)) * hRadius;
                double hZ = (double)this.targetPos.m_123343_() + 0.5 + Math.sin(Math.toRadians(hAngle)) * hRadius;
                double hY = (double)this.targetPos.m_123342_() + 0.5 + (double)(i % 3 - 1) * 0.2;
                level.m_7106_((ParticleOptions)ParticleTypes.f_123809_, hX, hY, hZ, 0.0, 0.0, 0.0);
                double vAngle = ((double)gameTime * 0.7 + (double)(i * 60)) % 360.0;
                double vRadius = 0.6;
                double vX = (double)this.targetPos.m_123341_() + 0.5 + Math.cos(Math.toRadians(vAngle)) * vRadius;
                double vY = (double)this.targetPos.m_123342_() + 0.5 + Math.sin(Math.toRadians(vAngle)) * vRadius;
                double vZ = (double)this.targetPos.m_123343_() + 0.5 + ((double)(i % 2) - 0.5) * 0.2;
                level.m_7106_((ParticleOptions)ParticleTypes.f_123809_, vX, vY, vZ, 0.0, 0.0, 0.0);
            }
        }
    }

    protected void m_7378_(CompoundTag nbt) {
        this.targetPos = BlockPos.m_122022_((long)nbt.m_128454_("TargetPos"));
        this.f_19804_.m_135381_(SPEED_MULTIPLIER, (Object)nbt.m_128451_("Speed"));
        this.f_19804_.m_135381_(FACE, (Object)nbt.m_128451_("Face"));
    }

    protected void m_7380_(CompoundTag nbt) {
        nbt.m_128356_("TargetPos", this.targetPos.m_121878_());
        nbt.m_128405_("Speed", this.getSpeedMultiplier());
        nbt.m_128405_("Face", this.getFace().m_122411_());
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

