/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.entity.arrow;

import committee.nova.mods.avaritia.init.registry.ModEntities;
import committee.nova.mods.avaritia.util.ToolUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class TraceArrowEntity
extends Arrow {
    private static final EntityDataAccessor<Integer> SPECTRAL_TIME = SynchedEntityData.m_135353_(TraceArrowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> JUMP_COUNT = SynchedEntityData.m_135353_(TraceArrowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final Entity owner = this.m_19749_() == null ? this : this.m_19749_();
    private LivingEntity homingTarget = null;
    private Vec3 seekOrigin = null;
    private int homingTime = 0;

    public TraceArrowEntity(EntityType<? extends Arrow> entityType, Level world) {
        super(entityType, world);
    }

    public TraceArrowEntity(Level world, Entity pShooter, double xPos, double yPos, double zPos) {
        this((EntityType<? extends Arrow>)((EntityType)ModEntities.TRACE_ARROW.get()), world);
        this.m_5602_(pShooter);
        this.m_6034_(xPos, yPos, zPos);
    }

    public TraceArrowEntity(Level world, Entity pShooter) {
        this(world, pShooter, pShooter.m_20185_(), pShooter.m_20188_() - (double)0.1f, pShooter.m_20189_());
        if (pShooter instanceof Player) {
            this.f_36705_ = AbstractArrow.Pickup.ALLOWED;
        }
    }

    public TraceArrowEntity(Entity pShooter) {
        this(pShooter.m_9236_(), pShooter);
    }

    public void setSpectral(int spectralTime) {
        this.f_19804_.m_135381_(SPECTRAL_TIME, (Object)spectralTime);
    }

    public int getSpectralTime() {
        return (Integer)this.f_19804_.m_135370_(SPECTRAL_TIME);
    }

    public int getJumpCount() {
        return (Integer)this.f_19804_.m_135370_(JUMP_COUNT);
    }

    public void setJumpCount(int jumpCount) {
        this.f_19804_.m_135381_(JUMP_COUNT, (Object)jumpCount);
    }

    public void m_8119_() {
        this.updateHoming();
        this.superTick();
        super.m_8119_();
    }

    private void superTick() {
        Vec3 vector3d3;
        VoxelShape voxelshape;
        if (!this.f_37246_) {
            this.f_37246_ = this.m_37276_();
        }
        if (!this.m_9236_().f_46443_) {
            this.m_20115_(6, this.m_142038_());
        }
        this.m_6075_();
        boolean flag = this.m_36797_();
        Vec3 vector3d = this.m_20184_();
        if (this.f_19860_ == 0.0f && this.f_19859_ == 0.0f) {
            double f = vector3d.m_165924_();
            this.m_146922_((float)(Mth.m_14136_((double)vector3d.f_82479_, (double)vector3d.f_82481_) * 57.2957763671875));
            this.m_146926_((float)(Mth.m_14136_((double)vector3d.f_82480_, (double)f) * 57.2957763671875));
            this.f_19859_ = this.m_146908_();
            this.f_19860_ = this.m_146909_();
        }
        BlockPos blockpos = this.m_20183_();
        BlockState blockstate = this.m_9236_().m_8055_(blockpos);
        if (!(blockstate.m_60795_() || flag || (voxelshape = blockstate.m_60812_((BlockGetter)this.m_9236_(), blockpos)).m_83281_())) {
            vector3d3 = this.m_20182_();
            for (AABB axisalignedbb : voxelshape.m_83299_()) {
                if (!axisalignedbb.m_82338_(blockpos).m_82390_(vector3d3)) continue;
                this.f_36703_ = true;
                break;
            }
        }
        if (this.f_36706_ > 0) {
            --this.f_36706_;
        }
        if (this.m_20070_()) {
            this.m_20095_();
        }
        if (this.f_36703_ && !flag) {
            if (this.f_36696_ != blockstate && this.m_36798_()) {
                this.m_36799_();
            } else if (!this.m_9236_().f_46443_) {
                this.m_6901_();
            }
            ++this.f_36704_;
        } else {
            this.f_36704_ = 0;
            Vec3 vector3d2 = this.m_20182_();
            vector3d3 = vector3d2.m_82549_(vector3d);
            BlockHitResult raytraceresult = this.m_9236_().m_45547_(new ClipContext(vector3d2, vector3d3, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            if (raytraceresult.m_6662_() != HitResult.Type.MISS) {
                vector3d3 = raytraceresult.m_82450_();
            }
            while (!this.m_213877_()) {
                EntityHitResult entityraytraceresult = this.m_6351_(vector3d2, vector3d3);
                if (entityraytraceresult != null) {
                    raytraceresult = entityraytraceresult;
                }
                if (raytraceresult != null && raytraceresult.m_6662_() == HitResult.Type.ENTITY) {
                    Entity entity = ((EntityHitResult)raytraceresult).m_82443_();
                    Entity entity1 = this.m_19749_();
                    if (entity instanceof Player && entity1 instanceof Player && !((Player)entity1).m_7099_((Player)entity)) {
                        raytraceresult = null;
                        entityraytraceresult = null;
                    }
                }
                if (raytraceresult != null && raytraceresult.m_6662_() != HitResult.Type.MISS && !flag && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)raytraceresult)) {
                    this.m_6532_((HitResult)raytraceresult);
                    this.f_19812_ = true;
                }
                if (entityraytraceresult == null || this.m_36796_() <= 0) break;
                raytraceresult = null;
            }
            vector3d = this.m_20184_();
            double d3 = vector3d.f_82479_;
            double d4 = vector3d.f_82480_;
            double d0 = vector3d.f_82481_;
            if (this.m_36792_()) {
                for (int i = 0; i < 4; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123797_, this.m_20185_() + d3 * (double)i / 4.0, this.m_20186_() + d4 * (double)i / 4.0, this.m_20189_() + d0 * (double)i / 4.0, -d3, -d4 + 0.2, -d0);
                }
            }
            double d5 = this.m_20185_() + d3;
            double d1 = this.m_20186_() + d4;
            double d2 = this.m_20189_() + d0;
            double f1 = vector3d.m_165924_();
            if (flag) {
                this.m_146922_((float)(Mth.m_14136_((double)(-d3), (double)(-d0)) * 57.2957763671875));
            } else {
                this.m_146922_((float)(Mth.m_14136_((double)d3, (double)d0) * 57.2957763671875));
            }
            this.m_146926_((float)(Mth.m_14136_((double)d4, (double)f1) * 57.2957763671875));
            this.m_146926_(TraceArrowEntity.m_37273_((float)this.f_19860_, (float)this.m_146909_()));
            this.m_146922_(TraceArrowEntity.m_37273_((float)this.f_19859_, (float)this.m_146908_()));
            float f2 = 0.99f;
            float f3 = 0.05f;
            if (this.m_20069_()) {
                for (int j = 0; j < 4; ++j) {
                    float f4 = 0.25f;
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, d5 - d3 * (double)f4, d1 - d4 * (double)f4, d2 - d0 * (double)f4, d3, d4, d0);
                }
                f2 = this.m_6882_();
            }
            this.m_20256_(vector3d.m_82490_((double)f2));
            if (!this.m_20068_() && !flag) {
                Vec3 vector3d4 = this.m_20184_();
                this.m_20334_(vector3d4.f_82479_, vector3d4.f_82480_ - (double)0.05f, vector3d4.f_82481_);
            }
            this.m_6034_(d5, d1, d2);
            this.m_20101_();
        }
    }

    protected void m_5790_(@NotNull EntityHitResult pResult) {
        ToolUtils.infinityTraceArrowDamage(this.m_9236_(), pResult, this);
    }

    protected void m_8060_(BlockHitResult hitResult) {
        this.f_36696_ = this.m_9236_().m_8055_(hitResult.m_82425_());
        BlockState blockstate = this.m_9236_().m_8055_(hitResult.m_82425_());
        blockstate.m_60669_(this.m_9236_(), blockstate, hitResult, (Projectile)this);
        Vec3 vec3 = hitResult.m_82450_().m_82492_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        this.m_20256_(vec3);
        Vec3 vec31 = vec3.m_82541_().m_82490_((double)0.05f);
        this.m_20343_(this.m_20185_() - vec31.f_82479_, this.m_20186_() - vec31.f_82480_, this.m_20189_() - vec31.f_82481_);
        this.m_5496_(this.m_36784_(), 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
        this.seekNextTarget();
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11685_, SoundSource.PLAYERS, 4.0f, 1.0f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SPECTRAL_TIME, (Object)0);
        this.f_19804_.m_135372_(JUMP_COUNT, (Object)0);
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        if (this.getSpectralTime() > 0) {
            compound.m_128405_("spectral_time", ((Integer)this.f_19804_.m_135370_(SPECTRAL_TIME)).intValue());
        }
        if (this.getJumpCount() > 0) {
            compound.m_128405_("jump_count", ((Integer)this.f_19804_.m_135370_(JUMP_COUNT)).intValue());
        }
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("spectral_time")) {
            this.setSpectral(compound.m_128451_("spectral_time"));
        }
        if (compound.m_128441_("jump_count")) {
            this.setJumpCount(compound.m_128451_("jump_count"));
        }
    }

    public void m_7761_(@NotNull LivingEntity livingEntity) {
        super.m_7761_(livingEntity);
        int spectralTime = (Integer)this.f_19804_.m_135370_(SPECTRAL_TIME);
        if (spectralTime > 0) {
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19619_, spectralTime, 0));
        }
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean m_6673_(DamageSource source) {
        return source.m_276093_(DamageTypes.f_268468_) || super.m_6673_(source);
    }

    public void seekNextTarget() {
        if (this.getJumpCount() <= 16 && this.m_36792_()) {
            if (this.seekOrigin == null) {
                this.seekOrigin = this.m_20182_();
            }
            if (!this.m_9236_().f_46443_) {
                TargetingConditions conditions = TargetingConditions.m_148352_().m_26888_(living -> living.m_142582_((Entity)this));
                this.homingTarget = this.m_9236_().m_45963_(LivingEntity.class, conditions, this.owner instanceof LivingEntity ? (LivingEntity)this.owner : null, this.seekOrigin.f_82479_, this.seekOrigin.f_82480_, this.seekOrigin.f_82481_, this.m_20191_().m_82400_(64.0));
                if (this.homingTarget != null) {
                    Vec3 targetPos = this.homingTarget.m_146892_();
                    double x = targetPos.f_82479_ - this.m_20185_();
                    double y = targetPos.f_82480_ - this.m_20186_();
                    double z = targetPos.f_82481_ - this.m_20189_();
                    this.m_6686_(x, y, z, 3.0f, 0.0f);
                    this.setJumpCount(this.getJumpCount() + 1);
                    this.homingTime = 0;
                } else {
                    this.destroyArrow();
                }
            }
        } else {
            this.destroyArrow();
        }
    }

    private void updateHoming() {
        if (this.homingTarget != null) {
            if (this.homingTime++ > 60) {
                this.destroyArrow();
            } else if (!this.homingTarget.m_21224_() && !this.homingTarget.m_213877_()) {
                Vec3 targetPos = this.homingTarget.m_146892_();
                if (targetPos.m_82557_(this.m_20182_()) >= 4.0) {
                    double x = targetPos.f_82479_ - this.m_20185_();
                    double y = targetPos.f_82480_ - this.m_20186_();
                    double z = targetPos.f_82481_ - this.m_20189_();
                    this.m_6686_(x, y, z, 3.0f, 0.0f);
                    this.f_19812_ = true;
                }
            } else {
                this.homingTarget = null;
                this.seekNextTarget();
            }
        }
    }

    private void destroyArrow() {
        Level level1 = this.m_9236_();
        if (!level1.f_46443_) {
            if (level1 instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)level1;
                ClientboundLevelParticlesPacket packet = new ClientboundLevelParticlesPacket((ParticleOptions)ParticleTypes.f_123762_, true, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, 0.0f, 0.0f, 4.0f, 10);
                Entity entity = this.owner;
                if (entity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)entity;
                    player.f_8906_.m_9829_((Packet)packet);
                }
                level.m_254849_((Entity)(this.m_19749_() == null ? this : this.m_19749_()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 4.0f, Level.ExplosionInteraction.NONE);
            }
            this.m_146870_();
        } else {
            level1.m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        }
    }
}

