/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.item.singularity;

import committee.nova.mods.avaritia.api.iface.IColored;
import committee.nova.mods.avaritia.api.util.lang.Localizable;
import committee.nova.mods.avaritia.common.entity.ImmortalItemEntity;
import committee.nova.mods.avaritia.core.singularity.Singularity;
import committee.nova.mods.avaritia.core.singularity.SingularityDataManager;
import committee.nova.mods.avaritia.init.registry.ModEntities;
import committee.nova.mods.avaritia.init.registry.ModRarities;
import committee.nova.mods.avaritia.init.registry.ModTooltips;
import committee.nova.mods.avaritia.util.SingularityUtils;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingularityItem
extends Item
implements IColored {
    public static final AtomicInteger currentSingularityIndex = new AtomicInteger(0);
    public static List<Singularity> enabledSingularities = null;

    public SingularityItem() {
        super(new Item.Properties().m_41497_(ModRarities.UNCOMMON));
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack stack) {
        Singularity singularity = SingularityUtils.getSingularity(stack);
        if (singularity == null) {
            return Localizable.of(this.m_5671_(stack)).args("NULL").build();
        }
        return Localizable.of(this.m_5671_(stack)).args(singularity.getDisplayName()).build();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@NotNull ItemStack stack, Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        Singularity singularity = SingularityUtils.getSingularity(stack);
        if (singularity != null) {
            String modid = singularity.getId().m_135827_();
            if (!modid.equals("avaritia")) {
                tooltip.add(ModTooltips.getAddedByTooltip(modid));
            }
            if (flag.m_7050_()) {
                tooltip.add((Component)ModTooltips.SINGULARITY_ID.args(singularity.getId()).color(ChatFormatting.DARK_GRAY).build());
            }
        }
    }

    @Override
    public int getColor(int i, ItemStack stack) {
        Singularity singularity;
        if (stack.m_41782_() && stack.m_41783_().m_128471_("IsCreativeTab")) {
            if (enabledSingularities == null) {
                enabledSingularities = SingularityDataManager.getInstance().getSingularities().stream().filter(s -> s.isEnabled() && s.getIngredient() != Ingredient.f_43901_).toList();
            }
            if (!enabledSingularities.isEmpty()) {
                Singularity currentSingularity = enabledSingularities.get(currentSingularityIndex.get());
                return i == 0 ? currentSingularity.getUnderlayColor() : (i == 1 ? currentSingularity.getOverlayColor() : -1);
            }
        }
        if ((singularity = SingularityUtils.getSingularity(stack)) == null) {
            return -1;
        }
        return i == 0 ? singularity.getUnderlayColor() : (i == 1 ? singularity.getOverlayColor() : -1);
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    @Nullable
    public Entity createEntity(Level level, Entity location, ItemStack stack) {
        return ImmortalItemEntity.create((EntityType<ImmortalItemEntity>)((EntityType)ModEntities.IMMORTAL.get()), level, location.m_20185_(), location.m_20186_(), location.m_20189_(), stack);
    }
}

